	SUBROUTINE CURSAV (ROW, COL)
C
C		R. W. Barnard
C		BIO/COMP Applications
C		P. O. Box 5342
C		Albuquerque, NM 87185
C
C	Uses the VT-100 cursor position report to generate cursor
C	position variables which can be saved and reused.  Different
C	from SAVCUR and RESCUR because the values are saved in memory,
C	not in the terminal.
C	CAUTION!!!	If you are not careful, Fortran carriage controls
C	can cause you to get incorrect row and column values:
C	e.g.;	CALL CUP (10,20)
C		TYPE *, 'Here I am'
C		CALL CURSAV (ROW, COL)
C	will report the column as being 1, because of the Fortran carriage
C	control on the TYPE statement.
C
	INTEGER*2 INPCHR	!Necessary for ITTINR
	INTEGER*2 ROW, COL
	BYTE CPR(5), CURPOS(10)
C
	DATA CPR /27,'[','6','n',"200/
C
	DO 10 K= 1,10
10	CURPOS(K)= 0
C
	CALL PRINT (CPR)
	CALL IPOKE ("44,"10000.OR.IPEEK("44))
C
20	INPCHR= ITTINR ()	!INPCHR must be integer here!
	IF (INPCHR.LT.0) GO TO 20
C
	CURPOS(1)= INPCHR
	K= 2
30	ISTAT= ISLEEP (0,0,0,1)
	IF (ISTAT.NE.0) STOP 'CURPOS-F-Q-Element Failure'
	INPCHR= ITTINR ()
	IF (INPCHR.GE.0) THEN
	  CURPOS(K)= INPCHR
	  K= K+ 1
	  GO TO 30
	ENDIF
C
	CALL IPOKE ("44,"10000.XOR.IPEEK("44))
	DO 40 K= 1,10
	IF (CURPOS(K).EQ.'[') NR= K+ 1
	IF (CURPOS(K).EQ.';') NC= K+ 1
40	IF (CURPOS(K).EQ.'R') NE= K
	IF (NE.NE.0) THEN
	  CALL CVAI (CURPOS(NR), ROW, NC-NR-1)
	  CALL CVAI (CURPOS(NC), COL, NE-NC)
	ELSE
	  ROW= 0
	  COL= 0
	ENDIF
	RETURN
C
	END
                                                               