	PROGRAM TESTKS
C
C	Test program for the subroutine KUTSIM.
C
	DIMENSION Y1(2),Y2(2),F(2),G(2)
	COMMON /CONST/ A,B
C
	A = 2.
	B = 0.5
	X = 0.
	Y1(1) = 1.
	Y1(2) = -1.
	Y1TRUE = Y1(1)
	Y2TRUE = Y1(2)
	WRITE (5,10)
10	FORMAT(' Test Program for subroutine KUTSIM'/
     1	' Enter step size: '$)
	READ (5,*) H
	WRITE (5,20)
20	FORMAT(1X//9X'X'9X'Y1'12X'Y1,TRUE'11X'Y2'11X'Y2,TRUE'/)
	WRITE (5,30) X,Y1(1),Y1TRUE,Y1(2),Y2TRUE
30	FORMAT(1X,F10.3,4(1PE16.7))
	DO 40 I=1,100
	CALL KUTSIM (H,X,2,Y1,Y2,F,G)
	X = X+H
	Y1TRUE = X*EXP(A*X) + EXP(B*X)
	Y2TRUE = X*EXP(A*X) - EXP(B*X)
	WRITE (5,30) X,Y2(1),Y1TRUE,Y2(2),Y2TRUE
	Y1(1) = Y2(1)
40	Y1(2) = Y2(2)
	CALL EXIT
	END
	SUBROUTINE FUNC (F, X, Y)
C
C	Test function subroutine for solution of differential
C	equations.  The system to be solved is
C		dy(1)/dx = (a+b+1/x)y(1)/2 + (a-b+1/x)y(2)/2
C		dy(2)/dx = (a-b+1/x)y(1)/2 + (a+b+1/x)y(2)/2
C	which has the solution
C		y(1) = xexp(ax) + exp(bx)
C		y(2) = xexp(ax) - exp(bx)
C
	DIMENSION F(2), Y(2)
	COMMON /CONST/ A,B
	IF (X.EQ.0.) GO TO 10
	T1 = 0.5*(A+B+1./X)
	T2 = 0.5*(A-B+1./X)
	F(1) = T1*Y(1)+T2*Y(2)
	F(2) = T2*Y(1)+T1*Y(2)
	RETURN
10	F(1) = 1.+B
	F(2) = 1.-B
	RETURN
	END
                                                                                                                                                                                                                                                                                                                      