/*
 * Create Runoff files from MACRO documentation
 */
#include <std.h>
#define FF  014

/*
 * flags:
    -e		Select Elite type
    -l		Select landscape layout
    -ml		Set left margin
    -mr		Set right margin
    -u		Select unformatted output
    -w		Select 132 columns
 */

BOOL  eflag	{NO};
BOOL  hflag	{NO};
BOOL  lflag	{NO};
LONG  mtop	{-1};
LONG  mbottom	{-1};
LONG  mleft	{-1};
LONG  mright	{-1};
BOOL  uflag	{NO};
BOOL  wflag	{NO};

BOOL main(ac, av)
    BYTES	ac;
    TEXT	**av;
    {
    IMPORT BOOL eflag;
    IMPORT BOOL hflag;
    IMPORT BOOL	lflag;
    IMPORT LONG	mtop;
    IMPORT LONG	mbottom;
    IMPORT LONG mleft;
    IMPORT LONG mright;
    IMPORT BOOL	uflag;
    IMPORT BOOL	wflag;
    IMPORT FIO 	stdout;
    BOOL 	ok	{YES};
    COUNT	n;
    FILE	fd;
    FIO		inf;
    FIO		ouf;
    TEXT	inlin[81];
    BOOL	done;
    BOOL        ws;
    COUNT	length;

    getflags(&ac, &av, "e,h,l,ml##,mr##,mt##,mb##,u,w:F <files>", 
             &eflag, &hflag, &lflag, &mleft, &mright, &mtop, &mbottom, 
    	     &uflag, &wflag);

    if (hflag)
/*
 *  The user requested help.
 */
	{
	remark ("GETRNO - Make runoff source from MACRO documentation");
	return(ok);
	}

/*
    if (!fopen(&ouf, "GKS.RNO", WRITE))
    	{
    	errfmt("Can't open GKS.RNO");
	ok = NO;
    	return(ok);
    	}
 */

/*
 *  The primary loop for file processing begins here.
 */
    for (ok = YES; 0 <= (fd = getfiles(&ac, &av, STDIN, STDERR));)
    	{
    	if (fd == STDERR)
    	    {
	    remark("Can't read: ", av[-1]);
	    ok = NO;
	    }
	else
/*
 *	    Read the file from beginning to end, one character at a time
 *	    and send the characters to the printer. Adjacent form feed
 *	    characters are removed.
 */
	    {
	    finit(&inf, fd, READ);
	    while ((length=getl(&inf, inlin, 80)) != 0)
		{
                if ((inlin[0] == ';') && (inlin[1] == '+'))
		    {
		    length = getl(&inf, inlin, 80);
		    done = NO;
                    while (!done)
			{
			length = getl(&inf, inlin, 80);
			if ((inlin[0] == ';') && (inlin[1] == '-'))
			    {
			    done = YES;
			    }
			else
			    {
			    inlin[00] = ' ';
			    inlin[01] = ' ';
			    if (inlin[02] == '*') 
				{
				length = 3;
				}

			    for (n=2; n <= length-1; n++)
			        {
			        inlin[n-2] = inlin[n];
				}
			    length = length - 2;

			    if (length >= 1)
				{
				for (n=length-1; inlin[n--] != '*';) 
				    {
				    }

				for (; (ws = iswhite(inlin[n--])) == YES
                                    && n >= 0;)
				    {
				    }
				inlin[n+3] = '\n';
				length = n + 4;
				}

			    if (inlin[0] == '*') inlin[0] = ' ';
			    putlin(inlin, length);
			    }
			}
		    }
		}
	    fclose(&inf);
	    }
	}
    fclose (&ouf);
    return (ok);
    }
                                                                                                                                                                                    