c typplt - output plot file to console terminal
c popen -
      subroutine popen
      real psc
      common/scale/xsc,ysc
      real xsc,ysc
      common/cpplot/buf,ixpen,iypen,symbol
      integer ixpen,iypen
      byte buf(80,24),symbol
      real arcsmo,segmin
      common/arccom/arcsmo,segmin
c minimum arc segment length
      segmin=39.
      arcsmo=1.
c Scaled for tektronics 4663 addressable graphics units (ADU)
c Page format is `A-DRAFTING`
c X = 10.5 inches = 4096 ADU
c Y = 7.74 inches = 3019.23 ADU
c tek ADU's per inch
      psc=4096/10.5
c 7 dots per inch in x dimension
      xsc=7/psc
c 3 dots per inch in y dimension
      ysc=3/psc
c     for
      i=1
23000 if(.not.(i.le.80))goto 23002
c        for
         j=1
23003    if(.not.(j.le.24))goto 23005
            buf(i,j)=' '
            j=j+1
            goto 23003
c        endfor
23005    continue
         i=i+1
         goto 23000
c     endfor
23002 continue
      symbol='*'
      return
      end
c pclose -
      subroutine pclose
      common/cpplot/buf,ixpen,iypen,symbol
      integer ixpen,iypen
      byte buf(80,24),symbol
      call doplot
      call pwait
      return
      end
c pmove - move the pen to (ixm,iym) without drawing
      subroutine pmove(ix,iy)
      integer ix,iy
      common/scale/xsc,ysc
      real xsc,ysc
      common/cpplot/buf,ixpen,iypen,symbol
      integer ixpen,iypen
      byte buf(80,24),symbol
      ixpen=ix*xsc+1.
      iypen=iy*ysc+1.
      return
      end
c pdraw - draw a line from current pen position to the point (ixp,iyp)
      subroutine pdraw(ix,iy)
      real x,y,dx,dy
      integer ix,iy,ixp,iyp,ixdif,iydif,ixdis,iydis,idx,idy
      common/scale/xsc,ysc
      real xsc,ysc
      common/cpplot/buf,ixpen,iypen,symbol
      integer ixpen,iypen
      byte buf(80,24),symbol
      ixp=ix*xsc+1.
      iyp=iy*ysc+1.
      ixdif=ixp-ixpen
      iydif=iyp-iypen
      ixdis=iabs(ixdif)
      iydis=iabs(iydif)
      buf(ixpen,iypen)=symbol
      if(.not.((ixdis.eq.0).and.(iydis.eq.0)))goto 23006
         return
23006 continue
      if(.not.(ixdis.gt.iydis))goto 23008
         idx=ixdif/ixdis
         dy=iydif/float(ixdif)
         y=iypen
c        for
         ix=ixpen
23010    if(.not.(ix.ne.ixp))goto 23012
            buf(ix,nint(y))=symbol
            y=y+dy
             ix=ix+idx
            goto 23010
c        endfor
23012    continue
         goto 23009
c     else
23008    continue
         dx=ixdif/float(iydif)
         x=ixpen
         idy=iydif/iydis
c        for
         iy=iypen
23013    if(.not.(iy.ne.iyp))goto 23015
            buf(nint(x),iy)=symbol
            x=x+dx
             iy=iy+idy
            goto 23013
c        endfor
23015    continue
23009 continue
      buf(ixp,iyp)=symbol
      ixpen=ixp
      iypen=iyp
      return
      end
c ppen -
      subroutine ppen(ipen)
      byte ipen
      common/cpplot/buf,ixpen,iypen,symbol
      integer ixpen,iypen
      byte buf(80,24),symbol
      symbol=ipen
      return
      end
c ppage -
      subroutine ppage
      common/cpplot/buf,ixpen,iypen,symbol
      integer ixpen,iypen
      byte buf(80,24),symbol
      call doplot
c     for
      i=1
23016 if(.not.(i.le.80))goto 23018
c        for
         j=1
23019    if(.not.(j.le.24))goto 23021
            buf(i,j)=' '
            j=j+1
            goto 23019
c        endfor
23021    continue
         i=i+1
         goto 23016
c     endfor
23018 continue
      call pwait
      return
      end
c pwait
      subroutine pwait
      byte junk
      call ittour(7)
c     while
23022 if(.not.(ittinr().eq.0))goto 23023
         goto 23022
c     endwhile
23023 continue
      return
      end
c doplot - put out hard copy of plot file to the console
      subroutine doplot
      common/cpplot/buf,ixpen,iypen,symbol
      integer ixpen,iypen
      byte buf(80,24),symbol
c     for
      j=24
23024 if(.not.(j.ge.1))goto 23026
c        for
         n=80
23027    if(.not.(buf(n,j).eq.' '))goto 23029
             n=n-1
            goto 23027
c        endfor
23029    continue
         write(7,200)(buf(i,j),i=1,n)
          j=j-1
         goto 23024
c     endfor
23026 continue
      return
200   format(' ', 80 a1)
      end
c nint - nearest integer
      integer function nint(rnum)
      real rnum
      nint = (rnum+sign(.5,rnum))
      return
      end
                                                                                                   