c
c
      subroutine axanno (iseg,vmin,vmax,cyc,vint,xlc,ylc,axlen,apct,
     & annlab,fmt,annpos,ang,ndig)
c
c
c	PROG NAME:			AXANNO.rat
c
c	DATE OF FIRST VERSION:		 9-Feb-83
c	DATE OF CURRENT VERSION:	21-Jun-83
c
c	PURPOSE:	PLTFIL routine to plot axis annotations.
c
c	USAGE:		call AXANNO (ISEG,VMIN,VMAX,CYC,VINT,XLC,YLC,AXLEN,APCT,
c				     ANNLAB,FMT,ANNPOS,ANG,NDIG)
c
c			where
c
c			  ISEG = Axis segment number.  Values:
c				   1 for bottom axis
c				   2 for left axis
c				   3 for top axis
c				   4 for right axis
c			  VMIN = Minimum axis value
c			  VMAX = Maximum axis value
c			   CYC = No. of cycles (0 if linear plot)
c			  VINT = Number of major intervals on this axis
c			   XLC = X-position of left-hand axis edge
c			   YLC = Y-position of left-hand axis edge
c			 AXLEN = Length of axis segment (inches)
c			  APCT = Percent axis length to use
c			ANNLAB = Annotation skip factor
c			   FMT = Annotation format (ASCIZ string)
c			ANNPOS = Position of the annotation
c			   ANG = Annotation angle (degrees)
c			  NDIG = Centering indicator (see NUMB2)
c
c	Programmer:	E. Javel / M. Prucka
c
c*******************************************************************
c
c	Common block for PLT parameters
c
      real*8prmnam,txtnam,keywrd
      bytexlabel,ylabel,rlabel,xfmt,yfmt,rfmt,msg,filonm(14)
      bytefilinm(40)
      logical*1dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,newpag,
     & ecflg,typerr,dbflg
c
      common /params/xmin,xmax,xint,xcycle,xpct,xlen,xllc,ymin,ymax,
     & yint,ycycle,ypct,ylen,yllc,rmin,rmax,rint,rcycle,rpct,pltype,
     & typlin,pltlin,symnum,sizsym,solid,sizann,wtlnan,xanlab,yanlab,
     & ranlab,yhor,grid,sizlab,wtlnlb,ticmrk,shade,echo,wtlnax,openax,
     & sizmsg,wtlnms,xmsg,ymsg,angmsg,datmsg,sizfac,smooth,header,sort,
     & unused(1)
      common /flags/dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,
     & newpag,ecflg,typerr,dbflg
      common /names/prmnam(50),txtnam(6),keywrd(25),filinm,filonm
      common /text/xlabel(52),ylabel(52),rlabel(52),xfmt(6),yfmt(6),
     & rfmt(6),msg(256)
      common /misc/ifrom,ito,inow,ipage,model,lunin,lunout
c
      common /axes/rxmin,rxmax,rymin,rymax,rxlen,rylen,rxllc,ryllc,
     & pxmin,pxmax,pymin,pymax,pxlen,pylen,pxllc,pyllc
      common /size/tiklen,hitann,hitlab,hitsym,hitmsg,iaxlnw,igrlnw,
     & ianlnw,ilblnw,ipllnw,imslnw,avgaxl
      common /msks/ msk1,msk2,msk3,msk4,msk5
      byte fmt(1)
c
c----------------------------------------------------------------------
c
c Establish the direction indicators
      if(.not.(iseg.eq.1 .or. iseg.eq.3))goto 23000
         xdir = 1.
         ydir = 0.
         goto 23001
c     else
23000    continue
         xdir = 0.
         ydir = 1.
23001 continue
c Initialize
c Offset to first tick
      offs = (100.-apct)/200.*axlen
c Format indicator
      jfmt = ifmt(fmt)
      if(.not.(cyc .eq. 0.))goto 23002
         a = vmax - vmin
         b = aint(vint)
         c = a / b
         pos = 0.
         val = vmin
         goto 23003
c     else
23002    continue
         a = alog10(vmax) - alog10(vmin)
         b = alog10(amin1(vmin,vmax))
         c = alog10(vmin)
         zend = alog10(amax1(vmin,vmax))
         pos = (b-c)/a
         val = 10.**b
23003 continue
c Annotate until we run out of intervals
      z = 0.
      skip = annlab + 1.
c     repeat
23004    continue
c See if this annotation is being generated
         if(.not.(cyc.ne.0. .or. (cyc.eq.0. .and. amod(z,skip).eq.0.) ))
     &    goto 23007
            pos = pos * axlen * apct/100. + offs
            xpos = xlc + pos*xdir
            ypos = ylc + pos*ydir
            if(.not.(jfmt .lt. 0 .and. b .lt. 0.))goto 23009
               kfmt = .99 - b
               goto 23010
c           else
23009          continue
               kfmt = jfmt
23010       continue
            call numb2 (ndig,xpos*xdir+annpos*ydir,annpos*xdir+ypos*
     &       ydir,hitann,val,ang,kfmt)
c Establish the next annotation value and its position
23007    continue
         z = z + 1.
         if(.not.(cyc .eq. 0.))goto 23011
c Linear axis
            if(.not.(z .gt. b))goto 23013
               return
23013       continue
            val = vmin + c*z
            pos = (val-vmin) / a
            goto 23012
c        else
23011       continue
c Log axis
            if(.not.(b .ge. zend))goto 23015
               return
23015       continue
            if(.not.(b.ge.0. .or. (b.lt.0. .and. amod(b,1.).eq.0.) ))
     &       goto 23017
               b = b + 1.
23017       continue
            b = amin1(zend,aint(b))
            pos = (b-c) / a
            val = 10.**b
23012    continue
23005    goto 23004
      return
      end
                                                                                                                                                                                                                                                                                                                