c
c
      function annlen (text,nchar,height)
c
c
c	PROG NAME:			ANNLEN.rat
c
c	DATE OF FIRST VERSION:		10-Jan-83
c	DATE OF CURRENT VERSION:	21-Jun-83
c
c	PURPOSE:	PLTFIL function to determine actual length in
c			inches of an ASCII string, given the number
c			of characters in it and the height of a character
c			in inches.
c
c	USAGE:		A = ANNLEN (TEXT,NCHAR,HEIGHT)
c
c			where    TEXT = Text string to consider.  If its
c					length is zero, then simply
c					compute the length of a string
c					NCHARS long, each of which is
c					HEIGHT tall
c				NCHAR = Number of characters in the string
c			       HEIGHT = Character height in inches
c
c	PROGRAMMER:	Eric Javel / Matt Prucka
c
c*********************************************************************
c
c
c	Common block for PLT parameters
c
      real*8prmnam,txtnam,keywrd
      bytexlabel,ylabel,rlabel,xfmt,yfmt,rfmt,msg,filonm(14)
      bytefilinm(40)
      logical*1dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,newpag,
     & ecflg,typerr,dbflg
c
      common /params/xmin,xmax,xint,xcycle,xpct,xlen,xllc,ymin,ymax,
     & yint,ycycle,ypct,ylen,yllc,rmin,rmax,rint,rcycle,rpct,pltype,
     & typlin,pltlin,symnum,sizsym,solid,sizann,wtlnan,xanlab,yanlab,
     & ranlab,yhor,grid,sizlab,wtlnlb,ticmrk,shade,echo,wtlnax,openax,
     & sizmsg,wtlnms,xmsg,ymsg,angmsg,datmsg,sizfac,smooth,header,sort,
     & unused(1)
      common /flags/dataon,pltfnd,msgflg,finflg,modflg,conton,axflg,
     & newpag,ecflg,typerr,dbflg
      common /names/prmnam(50),txtnam(6),keywrd(25),filinm,filonm
      common /text/xlabel(52),ylabel(52),rlabel(52),xfmt(6),yfmt(6),
     & rfmt(6),msg(256)
      common /misc/ifrom,ito,inow,ipage,model,lunin,lunout
c
      common /axes/rxmin,rxmax,rymin,rymax,rxlen,rylen,rxllc,ryllc,
     & pxmin,pxmax,pymin,pymax,pxlen,pylen,pxllc,pyllc
      common /size/tiklen,hitann,hitlab,hitsym,hitmsg,iaxlnw,igrlnw,
     & ianlnw,ilblnw,ipllnw,imslnw,avgaxl
      common /msks/ msk1,msk2,msk3,msk4,msk5
      bytetext(1),c,length(160)
      logical*1delim
      data length /4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,3,4,6,0,4,4,3,4,
     & 8,6,4,4,6,6,4,1,3,4,4,4,4,1,2,2,4,4,1,4,1,4,4,2,4,4,4,4,4,4,4,4,
     & 1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
     & 4,2,0,2,0,8,1,4,4,4,4,4,4,4,4,2,3,4,2,4,4,4,4,4,4,4,4,4,4,4,4,4,
     & 4,0,0,0,6,0,4,4,4,5,2,4,4,4,4,4,4,2,4,4,4,4,5,2,4,4,4,4,4,4,2,2,
     & 4,4,4,5,4,4/
c
c---------------------------------------------------------------------
c
c Character width is 4/7ths its height, and there is 2/7ths of a space
c between adjacent characters.  There are NCHAR widths and (NCHAR-1)
c spaces between characters in the string.  Superscripted and subscripted
c characters are .7 times normal height, symbols inside messages are
c HITSYM inches tall, with HITSYM/4 inches spacing.
      width = .8572439 * height
      if(.not.(text(1) .eq. 0))goto 23000
c Just use NCHAR and HEIGHT
         total = nchar * width
         goto 23001
c     else
23000    continue
c Consider the TEXT string
         total = 0.
         delim = .false.
c        for
         i=1
23002    if(.not.(i.le.nchar))goto 23004
            c = text(i)
            j = c + 1
c Superscript/Subscript delimiter
            if(.not.( (c.ge."133 .and. c.le."136) .or. c.eq."173 .or. c
     &       .eq."175))goto 23005
               delim = .not.delim
               if(.not.(delim))goto 23007
                  width = width * .7
                  goto 23008
c              else
23007             continue
                  width = width / .7
23008          continue
c Symbol delimiter
               goto 23006
c           else
23005          continue
               if(.not.(c .eq. "174))goto 23009
                  goto 23003
c Symbol
c              else
23009             continue
                  if(.not.(c .le. 14))goto 23011
                     total = total + 1.25*hitsym
c Text
                     goto 23012
c                 else
23011                continue
                     total = total + (length(j)+2)/6.*width
23012             continue
23010          continue
23006       continue
23003        i=i+1
            goto 23002
c        endfor
23004    continue
23001 continue
c Correct for the missing space after the last character
      annlen = total - .2857143*height
      return
      end
                                                                                                                                                     