/*
 *				o s p a n . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	ospan	Pattern Match -- Span Optional Matching Characters
index		Pattern match -- span optional matching characters

synopsis

	 #ifdef vms
	 #include "c:cset.h"
	 #else
	 #include <cset.h>
	 #endif

	 char *
	 ospan(s,cs)
	 char s[];
	 CSET *cs;

description

	Ospan() matches the longest leading substring of s that consists
	entirely of characters that are members of the cset cs.  It returns
	a pointer to the first character after the matched characters.

	Ospan(), unlike span(), will match the null string, returing s if
	the first character in s is a member of cs.

	The null that terminates s is never considered to be a member of the
	cset, and is never included in the spanned characters; if all the
	other characters in s are members of cs, ospan() returns a pointer
	to the trailing null.

bugs

author

	Jerry Leichter

#endif

/*
)EDITLEVEL=02
 * Edit history
 * 0.0 19-Jul-82 JSL	Invention
 */

#ifdef vms
#include "c:cset.h"
#else
#include <cset.h>
#endif
#define NULL 0

char *
ospan(s,cs)
register char *s;
register CSET *cs;
{
	while (*s && csmember(cs,*s))
		s++;
	return(s);
}
                                                                                                                                                                                                                                                                                                          