
/*
 *                      *************
 *                      * X R F . H *
 *                      *************
 *
 * This is the common header for the C xrf'er.
 *
 * Version V1.3          9-May-80
 * Version V1.4		10-Jul-80 MM
 */

#ifdef vms
#include		<ssdef.h>
#include		<stsdef.h>
#define	IO_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)
#define	IO_ERROR	SS$_ABORT
#endif
/*
 * Note: IO_SUCCESS and IO_ERROR are defined in the Decus C stdio.h file
 */
#ifndef	IO_SUCCESS
#define	IO_SUCCESS	0
#endif
#ifndef	IO_ERROR
#define	IO_ERROR	1
#endif

#define NCPS    8               /* Relevant characters per symbol */
#define LWIDTH  132             /* Listing width, characters */
#define RSIZE	5		/* Reference width in format statement */
#define MAXLIN  57              /* Listing lines per page (excl. header) */

/*
 * Structure definitions.
 */

struct  ref     {                       /* REFERENCE LIST NODE */
                int lno;                /* Line number of reference */
                struct ref *next;       /* Link to next ref in chain */
                };

struct  idt     {                       /* ID TREE NODE STRUCTURE */
                char *keyp;             /* Pointer to stashed key string */
                struct ref *first;      /* Pointer to head of ref chain */
                struct ref *last;       /* Pointer to tail of ref chain */
                struct idt *left;       /* Left link in id tree */
                struct idt *right;      /* Right link in id tree */
                };

/*
 * Global Variables.
 */

extern FILE *src;               /* Source file pointer */
extern FILE *lst;               /* List file pointer */

extern char scanbf[LWIDTH+1];   /* Source line scan buffer */
extern char *scanp;             /* Scan pointer */

extern char idbuf[NCPS+1];      /* ID string buffer */

extern char pghead[LWIDTH+1];   /* Listing page heading */

extern int  lineno;             /* Current source line number */
extern int  linpg;              /* Lines-per-page count */
extern int  rperline;		/* References per line */
extern struct idt *root;        /* --> root of ident tree */
                                                                                                                                                                                                                                                                                                                                                                   