      SUBROUTINE RDVOL1

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  90j31a
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Read and report the VOL1 label record.
C
C	Call a routine to read the first record on the tape.  If this
C	is not the VOL1 label record, set the error flag, display an
C	error message, and exit this subroutine.  Write the tape volume
C	identifier, the tape owner identifier, and several blank lines
C	to the output directory file.  If a write error occurs, set the
C	error flag, display an error message, and exit this subroutine.
C
C
C Edit Record:
C
C	12-Oct-90:  Original creation started.
C	31-Oct-90:  Original creation completed.
C
C
C Calling sequence:
C
C	BtBfLn = <integer>
C	MTDvNm = <string>
C	OutLun = <integer>
C	Read = <integer>
C	CALL RDVOL1
C
C
C Returns:
C
C	Error
C	LblRcd
C
C
C Called By:
C
C	TDINIT
C
C
C Routines Called:
C
C	MTFOR
C
C***********************************************************************

      INCLUDE 'TAPEDR.DAT'		!Common & variables declarations

      CALL MTFOR (MTDvNm,Read,BtBfLn,ByteBf,Iret)
      IF (Iret .EQ. 0) GOTO 800
      IF (LblRcd(1:4) .NE. 'VOL1') GOTO 800

      WRITE (OutLun,*,ERR=850) 'Tape Volume Identifier:       ',
     *    LblRcd(5:10)
      WRITE (OutLun,*,ERR=850) 'Tape Owner Identifier:        ',
     *    LblRcd(38:51)
      WRITE (OutLun,*,ERR=850)
      WRITE (OutLun,*,ERR=850)

      GOTO 900

800   CONTINUE
      Error = .TRUE.
      TYPE *, 'RDVOL1:  VOL1 label record expected'
      GOTO 900

850   CONTINUE
      Error = .TRUE.
      TYPE *, 'RDVOL1:  write error'

900   CONTINUE
      RETURN
      END				!RDVOL1.FOR.
                                                                                                                                                                                                                              