      SUBROUTINE GTSSNM

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  90l04a
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Get the saveset name.
C
C	Call a routine to prompt for and accept the desired saveset
C	name.  If no entry is made, display an error message and loop
C	back for another try.  If the entry is made in lower case,
C	convert it to upper case.  If the entry is too lengthy, display
C	an error message and loop back for another try.
C
C
C Edit Record:
C
C	14-Nov-90:  Original creation started.
C	04-Dec-90:  Original creation completed.
C
C
C Calling sequence:
C
C	CALL GTSSNM
C
C
C Returns:
C
C	SSName
C	SSNmLn
C
C
C Called By:
C
C	SDINIT
C
C
C Routines Called:
C
C	GTLIN
C
C***********************************************************************

      INCLUDE 'SVSTDR.DAT'		!Common & variables declarations

100   CONTINUE
          Answer = ' '
          CALL GTLIN (Answer,'Enter the desired saveset name')
          IF (AnsweB(1) .EQ. 0) THEN
              TYPE *, 'You MUST enter a saveset name'
              TYPE *
              GO TO 100
          END IF

      SSNmLn = 1
200   CONTINUE
          IF (AnsweB(SSNmLn) .EQ. 0) GOTO 300
          IF ((AnsweB(SSNmLn) .GE. 97) .AND.
     *        (AnsweB(SSNmLn) .LE. 122)) THEN 
              AnsweB(SSNmLn) = AnsweB(SSNmLn) - 32
          END IF
          SSNmLn = SSNmLn + 1
          IF (SSNmLn .GT. 16) THEN
              TYPE *, 'Saveset name too long'
              TYPE *
              GOTO 100
          END IF
      GOTO 200

300   CONTINUE
      SSName = Answer
      SSNmLn = SSNmLn - 1

      RETURN
      END				!GTSSNM.FOR.
                                                                                                                                                                                                                                             