      SUBROUTINE TSFLNM

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  9f04a
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Test the component parts of the DEV:FILNAM.EXT ASCII string.
C
C	Make sure that the error flag is reset.  Call routines to locate
C	the colon and period positions within the string.  Test for
C	proper limits on the DEV, FILNAM, and EXT.  If an error appears,
C	set the error flag, display an error message, and exit this
C	subroutine.  If no error condition prevails, simply exit this
C	subroutine.
C
C
C Edit Record:
C
C	26-Apr-91:  Original creation started.
C	04-Jun-91:  Original creation completed.
C
C
C Calling sequence:
C
C	Colon = <string>
C	FilNam = <string>
C	FlNmLn = <integer>
C	Period = <string>
C	CALL TSFLNM
C
C
C Returns:
C
C	ColPos
C	Error
C	PerPos
C
C
C Called By:
C
C	GTFLNM
C
C***********************************************************************

      INCLUDE 'CVRCDS.DAT'		!Common & variables declarations

      Error = .FALSE.
      ColPos = INDEX (FilNam,Colon)
      PerPos = INDEX (FilNam,Period)

      IF (ColPos .GT. 4) THEN
          TYPE *, 'DEV name too long'
          GOTO 850
      END IF

      IF ((PerPos-ColPos) .EQ. 1) THEN
          Type *, 'You MUST enter a FILNAM'
          GOTO 850
      ELSE IF ((PerPos-ColPos) .GT. 7) THEN
          TYPE *, 'FILNAM is too long'
          GOTO 850
      END IF

      IF ((FlNmLn-PerPos) .GT. 3) THEN
          TYPE *, 'EXT is too long'
          GOTO 850
      END IF

      GOTO 900

850   CONTINUE
      Error = .TRUE.
      TYPE *

900   CONTINUE
      RETURN
      END				!TSFLNM.FOR.
                                                                                                                                                                                                                                                          