/* netini.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "confgs.h"
#include "stask.h"
#include "mapskt.h"
#include "bytprc.h"
#include "cticks.h"
#include "suspnd.h"

/*
 *  hardware address for Ethernet broadcast address (used for ARP)
 */

static	char	bseed[]={0xff,0xff,0xff,0xff,0xff,0xff};


VOID netini()
{
	register int i;

	/*
	 * Read configuration file
	 */
	i = Sreadhosts();
	if(i) {
		printf("Sreadhosts() configuration error %d\r\n", i);
		exit(IO_ERROR);
	}

/*
 *  changes all sorts of ip numbers.
 *
 *  This routine assumes that there are currently NO open tcp connections.
 */
/* ntstip(st) */
	/*
	 *  Change all dependent locations
	 *  relating to the IP number.
	 */
	/*
	 * main ip number
	 */
	movebytes(nnipnum,Scon.myipnum,4);
	/*
	 * arp
	 */
	movebytes(arp.spa,nnipnum,4);
	/*
	 * ip source
	 */
	movebytes(ipblank.i.ipsource,nnipnum,4);
	/*
	 * udp source
	 */
	movebytes(ulist.tcps.source,nnipnum,4);
	/*
	 * more udp source
	 */
	movebytes(ulist.udpout.i.ipsource,nnipnum,4);

	/*
	 * Initialize the network
	 */
	i = Snetinit();
	if (i) {
		switch(i) {
			case -1:
				printf("netinit() failed\r\n");
				break;
			default:
				printf("Snetinit() failed\r\n");
				break;
		}
		exit(IO_FATAL);
	}
}

/*
 *  Snetinit
 *
 *  Handle all the initialization:
 *  internal queues and parameters.
 */
int Snetinit()
{
	register int i;
	register struct tasker *tp;

/*
 * Setup all the pointers for the event queue --
 * makes a circular list which is required for error messages.
 */
/* nteventinit() */
	for(i=0; i<NEVENTS; i++)
		nnq[i].next = i+1;
	nnq[NEVENTS-1].next = -1;
	nnefirst = 0;
	nnelast = 0;
	nnefree = 1;

	/*
	 * load linked list
	 */
	for(i=0; i<NTIMES; i++)
		Stq[i].next = i+1;

	Stq[NTIMES-1].next = -1;
	Stfirst = -1;
	Stfree = 0;

	/*
	 * starts up hardware
	 */
	if((i = ntinit()) == 0) {
		/*
		 * Give the lower layers a chance to check to
		 * see if anyone else is using the same ip number.
		 */
		reqarp(Scon.myipnum);
		/*
		 * finish IP inits
		 */
		Ssetgates();
		return(0);
	}
	/*
	 * ntinit() failed
	 */
	return(-1);
}

/*
 *  ntinit ()
 *
 *  Handles all the initialization to bring up the network connection.
 *  Assumes that the configuration file has already been read up.
 *  (called from Snetinit () )
 *
 *  Returns 0 on successful initialization.
 */
int ntinit()
{
	register int ret;
	register int i;
	register int sknum;

	/*
	 *   Initializes all buffers and hardware for data link layer.
	 *   Machine/board dependent.
	 */

/* dlinit() */
	engetaddr(nnmyaddr);
	ret = enopen();

	if(ret) {
		printf("Board initialization failed!.  Error code=%d\r\n", ret);
		skposterr(101);
		return(ret);
	}
	/*
	 * Call all the other packet initializations.
	 * Keep this order as some packet inits require
	 * lower layers already be initialized.
	 */

/*
 * Setup the ethernet headers -- this needs to be done
 * first as it is copied for the other headers .
 */
/* etherinit () */
	movebytes(broadaddr,bseed,DADDLEN);
	/*
	 * some are broadcast
	 */
	movebytes(dblank.dest,broadaddr,DADDLEN);
	/*
	 * always from me
	 */
	movebytes(dblank.me,nnmyaddr,DADDLEN);
	/*
	 * mostly IP packets
	 */
	dblank.type = EIP;

/*
 * Setup an arp packet -- also sets up an arp cache
 */
/* arpinit() */
	movebytes(&arp.d,&dblank,sizeof(DLAYER));
	/*
	 * 0x0806 is ARP type
	 */
	arp.d.type = EARP;
	/*
	 * Ether = 1
	 */
	arp.hrd = intswap(HTYPE);
	/*
	 * IP protocol = 0x0800
	 */
	arp.pro = intswap(ARPPRO);
	/*
	 * Ethernet hardware length
	 */
	arp.hln = DADDLEN;
	/*
	 * IP length = 4
	 */
	arp.pln = 4;
	/*
	 * sender's hardware addr
	 */
	movebytes(arp.sha,nnmyaddr,DADDLEN);
	/*
	 * target hardware addr
	 */
	movebytes(arp.tha,broadaddr,DADDLEN);
	/*
	 * sender's IP addr
	 */
	movebytes(arp.spa,nnipnum,4);
	/*
	 *  initialize the ARP cache to 0 time, none are gateways to start
	 */
	for(i=0; i<CACHELEN; i++) {
		arpc[i].tm = 0L;
		arpc[i].gate = 0;
	}

/*
 * initialize one packet to use for internet transmission -- most packets
 * will be tcp/udp, so they will be initialized at a different layer,
 * but some require a generic ip packet.
 *
 * Also takes a guess at setting a netmask if it hasn't happened by now.
 *
 */
/* ipinit() */
	movebytes(&ipblank.d,&dblank,sizeof(DLAYER));
	/*
	 * smallest header, version 4
	 */
	ipblank.i.versionandhdrlen = 0x45;
	/*
	 * normal service
	 */
	ipblank.i.service = 0;
	/*
	 * no data yet, maximum size 
	*/
	ipblank.i.tlen = 576;
	ipblank.i.identity = 0;
	/*
	 * not a fragment of a packet
	 */
	ipblank.i.frags = 0;
	/*
	 * time to live in seconds
	 */
	ipblank.i.ttl = UDPTTL;
	/*
	 * default to UDP
	 */
	ipblank.i.protocol = PROTUDP;
	/*
	 * disable checksums for now
	 */
	ipblank.i.check = 0;
	/*
	 * my return address
	 */
	movebytes(ipblank.i.ipsource,nnipnum,4);
	/*
	 * to ?
	 */
	movebytes(ipblank.i.ipdest,broadip,4);
	/*
	 * create a mask which can determine whether a machine
	 * is on the same wire or not.  RFC950
	 * Only set the mask if not previously set.
	 * This mask may be replaced by a higher level
	 * request to set the subnet mask.
	 */

	/*
	 * now blank
	 */
	if(comparen(nnmask,"\0\0\0\0",4)) {
		if(!(nnipnum[0]&0x80)) {
			/*
			 * class A
			 */
			ntstmask(nnamask);
		} else
		if((nnipnum[0]&0xC0)==0x80) {
			/*
			 * class B
			 */
			ntstmask(nnbmask);
		} else 
		if((nnipnum[0]&0xC0)==0xC0) {
			/*
			 * class C
			 */
			ntstmask(nncmask);
		}
	}

/*
 * setup for makesocket ()
 */
/* tcpinit() */
	/*
	 * no sockets open yet
	 */
	for(sknum=0; sknum<LSCKTS; sknum++) {
		sktlist[sknum].region =
		sktlist[sknum].inport =
		sktlist[sknum].outport = 0;
		for(i=0; i<4; i++)
			sktlist[sknum].remoteip[i] = '\0';
	}

/*
 * Setup ulist for receive of udp packets
 */
/* udpinit() */
	ulist.stale = 1;
	ulist.length = 0;

	movebytes(&ulist.udpout,&ipblank,sizeof(DLAYER)+sizeof(IPLAYER));
	ulist.tcps.proto = PROTUDP;
	movebytes(ulist.tcps.source,nnipnum,4);

	return(0);
}
                                                                                                                                                                                                                                                                  