/* ftpsb.c */

#define FTPSBMASTER

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vftpsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "ftppi.h"
#include "rtfile.h"
#include "sesutl.h"
#include "confgs.h"
#include "sktlib.h"
#include "kbdutl.h"
#include "inierr.h"
#include "cticks.h"
#include "suspnd.h"
#include "ftpsb.h"


/*
 * main - main procedure.  Displays opening message, parses arguments,
 *	  initializes network, reads user commands and executes them, and
 *	  cleans up.
 */

main(argc,argv)
int argc;
char *argv[];
{
	/*
	 * Initialize
	 */
	ftpsbi(argc,argv);


	if(destname[0])
		/*
		 * if destination specified, connect to it
		 */
		sprintf(ftpcommand,"open %s",destname);

	while(1) {
		if(*ftpcommand) {
			/*
			 * if command available, execute it
			 */
			ftppi(ftpcommand);
#ifdef	DEBUGOPTION
if(debug&0x02) {
			printf("after returning from ftppi()\r\n");
}
#endif
		}
		/*
		 * prompt
		 */
		kb_puts("ftp> ");
		/*
		 * read cmd from user
		 */
		ftpgets(ftpcommand,sizeof(ftpcommand),1);
	}
}

/*
 * tstbrk
 *
 * if fndbrk is set then:
 *	return(1)
 * else
 *	return(0)
 */
int tstbrk()
{
	if(fndbrk) {
		fndbrk = 0;
		return(1);
	} else {
		return(0);
	}
}

/*
 * dumpcon
 *
 * take everything from a connection and send it to the screen
 * return -1 on closed connection, else 0, 1 if paused
 */

int dumpcon()
{
	register int cnt;

	/*
	 * get some from queue
	 */
	do {
		cnt = skread(ftpcskt,s,sizeof(s));
		if(cnt>0) {
			skdeque(ftpcskt);
			/*
			 * display on screen, etc.
			 */
			filter(cnt);
		}
	} while(cnt>0);
	/*
	 * 0 normally, -1 if connection closed
	 */
	return(cnt);
}


/*
 * filter
 *
 * filter telnet options on incoming data
 */

VOID filter(cnt)
int cnt;
{
	register int i;

#ifdef	DEBUGOPTION
if(debug&0x100) {
	printf("filter(): cnt=%d \r\n",cnt);
}
#endif
	/*
	 * put on screen
	 */
	for(i=0; i<cnt; i++) {
		if(s[i] & 128) {
			/*
			 * if over ASCII 128 show as number
			 */
			kbprintf(" %d ", s[i]&0xFF);
		} else {
			kb_out(s[i]);
		}
	}

#ifdef	DEBUGOPTION
if(debug&0x100) {
	printf("filter(): leaving \r\n");
}
#endif
}

/*
 *  printout text
 */
VOID printtxt(txt)
register char **txt;
{
	register char **dp;

	for (dp = txt; *dp; dp++) {
		if (**dp == '_') {
			kb_puts(*dp + 1);
		} else {
			kb_puts(*dp);
			kb_nline();
		}
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    