/* ftppi4.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vftpsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "ftppi.h"
#include "rtfile.h"
#include "sesutl.h"
#include "sktlib.h"
#include "kbdutl.h"
#include "inierr.h"
#include "cticks.h"
#include "suspnd.h"
#include "ftpsb.h"

VOID ftppi4(cmdno,command)
register int cmdno;
register char *command;
{
	char cmndline[100];
	char word[50],answer[20];

	switch(cmdno) {
	case ASCII:		/* transfer mode */
		ftpdo("TYPE A");
		return;

	case BINARY:		/* binary mode */
		ftpdo("TYPE I");
		return;

	case CD:		/* change remote directory */
		/*
		 * if no arg, get from user
		 */
		if(askq(command,79,"To: "))
			return;
		getword(command,word);
		/*
		 * special case
		 */
		if(!strcmp(word,"..")) {
			/*
			 * if CDUP understood
			 */
			if(ftpdo("CDUP") != ERROR)
				return;
			kb_puts("Trying again...\r\n");
			/*
			 * try alternative
			 */
			if(ftpdo("XCUP") != ERROR)
				return;
			kb_puts("Trying again...\r\n");
	 	}
		/*
		 * else try usual CWD
		 */
		sprintf(cmndline,"CWD %s",word);
		if(ftpdo(cmndline) != ERROR)
			return;
		kb_puts("Trying again...\r\n");
		/*
		 * else try XCWD
		 */
		sprintf(cmndline,"XCWD %s",word);
		ftpdo(cmndline);
		return;

	case CLOSE:		/* drop connection */
		ftpdo("QUIT");
		linked = FALSE;
		/*
		 * Close Connections
		 */
		skclose(ftpcskt);
		ftpcskt = skrelease(ftpcskt,1);

		skclose(ftpdskt);
		ftpdskt = skrelease(ftpdskt,1);

		fclose(ftpfh);
		ftpfh = NULL;

		return;

	case DEL:
	case RM:
		getword(command,word);
		if(askq(word,79,"File: "))
			return;
		/*
		 * check interactively
		 */
		kbprintf("Delete %s ? ",word);
		ftpgets(answer,sizeof(answer),1);
		if(tolower(*(stpblk(answer))) != 'y')
			return;
		sprintf(cmndline,"DELE %s",word);
		ftpdo(cmndline);
		return;			

	default:
		return;
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              