/* tsxutl.h */

#define	DELCMDFIL	1	/* delete  generated command files */
#define	EXECMDFIL	1	/* execute generated command files */

/*
 *	The value for SUBDMAX specifies the maximum subdirectory
 *	nesting allowed.  The maximum level is constrained to
 *	8 by the Logical Disk handler.
 *
 *	The value SUBDBASE specifies the first logical unit
 *	to be used for subdirectory nesting.  e.g. for
 *	SUBDMAX = 2 and SUBDBASE = 2 the logical disk units
 *	ld2: and ld3: will be used for subdirectories.
 */

#define	SUBDNEST	2	/* Maximum nesting of subdirectories */
#define	SUBDBASE	2	/* Base 'ld' unit number */

/*
 *	An external buffer is required for building the command
 *	file used to make directories. RTBUFFR must be an array.
 *	Define the size of the array as RTBUFSZ.
 */

#define	RTBUFFR		xs
#define	RTBUFSZ		2048

/*
 *	An external routine is required to print the
 *	error string errstr, define ERRPRINT as required.  
 *	The routine should clear the string when finished.
 */

#define	ERRPRINT	lsterr

/*
 *	An external routine is required to print messages,
 *	the routine could be printf or some derivative.
 */

#define	RTPRINT		kbprintf

/*
 *	An external routine is required to process answers
 *	to questions, define RTRESPONSE as required.
 */

#define	RTRESPONSE	rtresp

/*
 *	An external integer flag is required to check for a
 *	break, define RTFNDBRK as required.
 */

#define	RTFNDBRK	fndbrk

/*
 *	An external integer is required to specifiy the
 *	program's job number, define RTJOBNUM as required.
 */

#define	RTJOBNUM	tljobn


extern	char	RTBUFFR[];
extern	VOID	ERRPRINT();
extern	VOID	RTPRINT();
extern	int	RTRESPONSE();
extern	int	RTFNDBRK;
extern	int	RTJOBNUM;

/*
 * Due to DECUS C aborts from lack of space
 * all functions/subroutines of type 'int'
 * are no longer explicitly defined.
 *
 * DECUS C defaults to 'int', VOID == int
 */

#if 0
extern	VOID	rtusage();	/* filespec description */

extern	int	rtclose();	/* close opened file, delete if zero length */

extern	int	filsiz();	/* get length of lookup file */

extern	int	cd();		/* (s) Change directory */
extern	int	lgcdsk();	/* (s) Logical Disk Directory */
extern	int	tstdev();	/* (s) Test file/directory default */
extern	VOID	argscan();	/* (d,s,cnt) scan converted rad50 string */
extern	VOID	respath();	/* restore path */
extern	int	dispatch();	/* (call,s) subdirectory dispatch */
extern	VOID	dspdir();	/* (s) screen dump of directory */
extern	int	mkdir();	/* (s) make a directory */
extern	int	rename();	/* (frm,to,p,w) rename files */
extern	VOID	setclrp();	/* (s,p,w) set/clr file protection */
extern	int	chkwild();	/* (s,w) check filespec for wildcards */
extern	VOID	r50blk();	/* (out,s1,s2) build a rad50 file spec */
extern	int	bldcmd();	/* (s,cnt) build a command file */
extern	int	addcmd();	/* (s,cnt) add string to command file */
extern	int	wrtcmd();	/* (cnt) write command file with cnt chars */
#endif

extern	char	*filtxt[];	/* filespec description strings */
extern	char	*lclfile();	/* (s) Local filespec */
extern	char	*rmtfile();	/* (s) Remote filespec */

extern	FILE	*rtopen();	/* (f,i,m,a) open a file with options */

extern	char	*firstname();	/* (s) Wild card lookup */
extern	char	*nextname();	/* Next wildcard match */
extern	char	*lastname();	/* Terminate wildcard lookup */
extern	char	*filnam();	/* (st,p,w) file lookup */

extern	FILE	*filiop();	/* get file handle of lookup file */

extern	char	*getdef();	/* get default device */
extern	char	*getpath();	/* get expanded default path */
extern	char	*gethome();	/* find home directory path */
extern	char	*setpath();	/* (st) setup path and return filespec */
extern	char	*expand();	/* (s) expand directory for list */

extern	char	errstr[];	/* the error report string */
extern	int	subdbase;	/* base 'ld' unit */
extern	int	subdnest;	/* maximum subdirectory nesting */
extern	int	subdlevl;	/* subdirectory level */
extern	int	delcmd;		/* delete  command file flag */
extern	int	execmd;		/* execute command file flag */
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              