/* vt1xx.c */

#include <stdio.h>
#include <string.h>

#include "vt1xx.h"
#include "fmtdat.h"
#include "suspnd.h"

/*
 *	VT-100/KEYPAD MODE
 */


char	outbuf[(SCRNBT-SCRNTP+1)*SCRNW];
int	outz;


/* vt1xx */
/* Terminal escape sequence translator */

/* The following external system dependent routines are
 * required by vt1xx.c
 *
 *	tt_inp()	-	returns a single character from the
 *				console keyboard. A 'NULL' character
 *				is returned if no character is
 *				available.
 *
 *	tt_out()	-	outputs a single character to the
 *				console screen.
 */

int
syscin()
{
register int c;

	if ( (c = tt_inp()) == ESCAPE ) {
		while((c = tt_inp()) == 0) {
			suspnd(0);
		}
		if ( c == 'O' ) {
			while((c = tt_inp()) == 0) {
				suspnd(0);
			}
			switch (c) {
				case 'l': return(DELC);
				case 'm': return(DELW);
				case 'n': return(SELECT);
				case 'p': return(LINE);
				case 'q': return(WORD);
				case 'r': return(EOL);
				case 's': return(CHAR);
				case 't': return(ADVANCE);
				case 'u': return(BACKUP);
				case 'v': return(CUT);
				case 'w': return(PAGE);
				case 'x': return(SECTION);
				case 'y': return(APPEND);
				case 'M': return(ENTER);
				case 'P': return(GOLD);
				case 'Q': return(HELP);
				case 'R': return(FNDNXT);
				case 'S': return(DELL);
				default:  return(ERROR);
			}
			/*
				(GOLD)(DELC)	--> (UNDEL C)
				(GOLD)(DELW)	--> (UNDEL W)
				(GOLD)(SELECT)	--> (RESET)
				(GOLD)(LINE)	--> (OPENLINE)
				(GOLD)(WORD)	--> (CHNGCASE)
				(GOLD)(EOL)	--> (DEL EOL)
				(GOLD)(CHAR)	--> (BOTTOM)
				(GOLD)(BACKUP)	--> (TOP)
				(GOLD)(CUT)	--> (PASTE)
				(GOLD)(PAGE)	--> (COMMAND)
				(GOLD)(SECTION)	--> (MOVE CURSOR)
				(GOLD)(APPEND)	--> (REPLACE)
				(GOLD)(ENTER)	--> (SUBS)
				(GOLD)(GOLD)	--> (GOLD)
				(GOLD)(HELP)	--> (HELP)
				(GOLD)(FNDNXT)	--> (FIND)
				(GOLD)(DELL)	--> (UNDEL L)
			*/
		}
		if (c == '[')  {
			while((c = tt_inp()) == 0) {
				suspnd(0);
			}
			switch (c) {
				case 'A': return(SCRLU);
				case 'B': return(SCRLD);
				case 'C': return(SCRLR);
				case 'D': return(SCRLL);
				default:  return(ERROR);
			}
		}
		return(ERROR);
	}
	return(c);
}


VOID
escout(s)
register char *s;
{
	tt_out(ESCAPE);
	while (*s) {
		tt_out(*s++);
	}
}

VOID
outpos(x,y)
int x,y;
{
	tt_out(ESCAPE);
	tt_out('[');
	outarg(y);
	tt_out(';');
	outarg(x);
	tt_out('H');
}

VOID
outarg(ones)
register int ones;
{
register int hundreds,tens;

	hundreds = 0;
	tens = 0;
	ones++;
	while (ones >= 100) {
		hundreds++;
		ones -= 100;
	}
	while (ones >= 10) {
		tens++;
		ones -= 10;
	}
	if (hundreds) {
		tt_out('0'+hundreds);
	}
	if ((hundreds) | (tens)) {
		tt_out('0'+tens);
	}
		tt_out('0'+ones);
}

int
outrev()
{
	if (outz) {
		return(1);	/* in reverse mode */
	}
	else {
		escout("[7m");	/* reverse video mode */
		outz = 1;
		return(0);	/* in normal mode */
	}
}

int
outnorm()
{
	if (outz) {
		escout("[m");	/* normal video mode */
		outz = 0;
		return(1);	/* in reverse mode */
	}
	else {
		return(0);	/* in normal mode */
	}
}

VOID
outzset(z)
int z;
{
	if (z) {
		escout("[7m");	/* reverse video mode */
		outz = 1;
	}
	else {
		escout("[m");	/* normal video mode */
		outz = 0;
	}	
}

VOID
outclr()
{
	escout("[2J");		/* clear screen */
}

VOID
outdeol()
{
	escout("[K");		/* clear to end of line */
}

VOID
outekp()
{
register char	*p;
register int	i,j;

	p = &outbuf[0];
	for (i=0; i<(SCRNBT-SCRNTP+1); i++) {
		for (j=0; j<SCRNW; j++) {
			*p++ = CRLF;
		}
	}

	escout("=");			/* enable alternate keypad mode */
	outscroll(SCRNTP,SCRNBT);	/* set scroll region */
}

VOID
outdkp()
{
	escout("<");			/* disable alternate keypad mode */
	outsup(0,SCRNL-1);		/* reset scroll region and scroll */
}

VOID
outscroll(top,bot)
int top, bot;
{
	escout("[");
	outarg(top);
	tt_out(';');
	outarg(bot);
	tt_out('r');
}

VOID
outsup(top,bot)
int top, bot;
{
register char	*p,*q;
register int	i,j;

	outscroll(top,bot);
	outpos(0,bot);
	tt_out(10);
	for (i=top-SCRNTP; i<bot-SCRNTP; i++) {
		p = &outbuf[0] + findex[i];
		q = p + SCRNW;
		for (j=0; j<SCRNW; j++) {
			*p++ = *q++;
		}
	}
	p = &outbuf[0] + findex[bot-SCRNTP];
	for (j=0; j<SCRNW; j++) {
		*p++ = CRLF;
	}
}

VOID
outsdn(top,bot)
int top, bot;
{
register char	*p,*q;
register int	i,j;

	outscroll(top,bot);
	outpos(0,top);
	escout("[L");
	for (i=bot-SCRNTP; top-SCRNTP<i; --i) {
		p = &outbuf[0] + findex[i];
		q = p - SCRNW;
		for (j=0; j<SCRNW; j++) {
			*p++ = *q++;
		}
	}
	p = &outbuf[0] + findex[top-SCRNTP];
	for (j=0; j<SCRNW; j++) {
		*p++ = CRLF;
	}
}

VOID
outscan()
{
register char *p,*q;
register char *f,*o;
register int i,b,t;

scan:
	b = SCRNBT - SCRNTP;
	t = SCRNTP - SCRNTP;
	f = &fmtbuf[0];
	o = &outbuf[0];
	/*
	 * Remove identical lines top and bottom of screen
	 */
	for (; t<b; t++) {
		p = f + findex[t];
		q = o + findex[t];
		if (strncmp(p,q,SCRNW)) { break; }
	}
	for (; t<b; --b) {
		p = f + findex[b];
		q = o + findex[b];
		if (strncmp(p,q,SCRNW)) { break; }
	}
	if ((t+1)>=(b-1)) {
		outblk();
		return;
	}
	/*
	 * Check for SCROLL UP (BOTTOM of SCREEN Check)
	 */
	i = b;
	do {
		p = f + findex[i-1];
		q = o + findex[i];
	} while ((strncmp(p,q,SCRNW) == 0) && (t < --i));
	if (i != b) {
		outsup(i+SCRNTP,b+SCRNTP);
		goto scan;
	}
	/*
	 * Check for SCROLL DOWN (TOP of SCREEN Check)
	 */
	i = t;
	do {
		p = f + findex[i+1];
		q = o + findex[i];
	} while ((strncmp(p,q,SCRNW) == 0) && (++i < b));
	if (i != t) {
		outsdn(t+SCRNTP,i+SCRNTP);
		goto scan;
	}
	/*
	 * Check for SCROLL DOWN (BOTTOM of SCREEN Check)
	 */
	i = b;
	do {
		p = f + findex[i];
		q = o + findex[i-1];
	} while ((strncmp(p,q,SCRNW) == 0) && (t < --i));
	if (i != b) {
		outsdn(i+SCRNTP,b+SCRNTP);
		goto scan;
	}
	/*
	 *Check for SCROLL UP (TOP of SCREEN Check)
	 */
	i = t;
	do {
		p = f + findex[i];
		q = o + findex[i+1];
	} while ((strncmp(p,q,SCRNW) == 0) && (++i < b));
	if (i != t) {
		outsup(t+SCRNTP,i+SCRNTP);
		goto scan;
	}
	/*
	 * If all other checks fail, just redraw screen
	 */
	outblk();
}


VOID
outblk()
{
register char	c,*s,*t;
register int	i,j,z;
register int	change;

	change = 0;
	z = outz;
	for(i=SCRNTP-SCRNTP; i<=SCRNBT-SCRNTP; i++) {
		s = &fmtbuf[0] + findex[i];
		t = &outbuf[0] + findex[i];
		if (strncmp(s,t,SCRNW)) {
			change++;
			j = 0;
			while (*t == *s) { t++; s++; j++; }
			outpos(j,i+SCRNTP);
			for(; j<SCRNW; j++) {
				c = *t++ = *s++;
				if ((!c) || (c == CRLF)) {
					break;
				}
				if (c & REVERSE) {
					outrev();
					tt_out(c&0x7F);
				}
				else {
					outnorm();
					tt_out(c);
				}
			}
			for (j++; j<SCRNW; j++) { *t++ = *s++; }
			outdeol();
		}
	}
	if(change)
		outpos(fmtcol,fmtrow+SCRNTP);
	if(z != outz) {
		outzset(z);
	}
}
                                                                                                                                           