.;  DR:[333,106]MD.CMD		*** MAIL DELIVERY ***
.;
.;		A background task indirect command file which looks at
.;		appointment calender files in DTC format and sends system
.;		mail and broadcasts messages to users at the times for
.;		which appointments are scheduled.
.;
.;
.ENABLE SUBSTITUTION
.ENABLE GLOBAL

.BEGINN:

.;
.;  Every hour, scan the appointment calender files of each user on the
.;  system, and if a file exists for that hour, send the sucker mail and
.;  remind him of the appointment on his screen via Jimmy Downards MAI...
.;  MAILTSK program if he/she is logged on.  Even if he/she is not logged
.;  on, use a terminal numbers table and broadcast a message to his/her
.;  terminal telling him/her he/she has an appointment now
.;

.;  Get today's date, and translate the month name into a month number:

	.SETS TDATE <DATE>
	.SETS $YR1 TDATE[10:11]
	.SETS $MO1 TDATE[4:6]
	.SETS $DA1 TDATE[1:2]
	.GOSUB GETMN

.;=============================================================================
.; Table of users on the system to whom we wanna mail notice of appointments
.; and broadcast messages when the appointment is for this hour:


	.SETS $FIL "DR:[5,1]DTC.DAT"
	.SETS $USR "MFW"
	.SETS $TERM "TT7:"
	.GOSUB LOOKY

	.SETS $FIL "DR:[333,35]DTC.DAT"
	.SETS $USR "JMG"
	.SETS $TERM "TT17:"
	.GOSUB LOOKY

	.SETS $FIL "DR:[333,47]DTC.DAT"
	.SETS $USR "OAL"
	.SETS $TERM "TT10:"
	.GOSUB LOOKY

	.SETS $FIL "DR:[333,106]DTC.DAT"
	.SETS $USR "MFW"
	.SETS $TERM "TT7:"
	.GOSUB LOOKY

	.SETS $FIL "DR:[333,1]DTC.DAT"
	.SETS $USR "CJM"
	.SETS $TERM "TT2:"
	.GOSUB LOOKY
.;
.;=============================================================================

.;  Wait an hour to insure not mailing someone notice of his appointment(s)
.;  more than once
.;	.DELAY 60M
.;
.;	.GOTO BEGINN
.;
.;;;;	^^^^^^^^^^^^^^ commented out to allow this command file to be called
.;;;;			by the system background command file as a subroutine
.;;;;			this command file is called once each hour...........
.;


	.GOTO GETOUT

.;
.;  Look in the appointment calender file of the given user.  If the
.;  file is not there, tell the system manager and get out of here.

.LOOKY:
	.CLOSE
	.OPENR '$FIL'
	.IF <FILERR> NE 1 .GOSUB OPNERR
	.IF <FILERR> NE 1 .RETURN
.;
.;  Otherwise, keep on reading appointments, parse for the time:

.NEXT1:
	.READ $APPOI
	.IFT <EOF> .RETURN
	.GOSUB READIT
	.GOTO NEXT1

.;  If the file is empty then get next file, otherwise
.;  keep reading appointments and comparing times  in them to time now


.READIT:
	.SETS YR $APPOI[1:2]
	.SETS MO $APPOI[3:4]
	.SETS DA $APPOI[5:6]
	.SETS HR $APPOI[7:10]
	.SETS TIM <TIME>
	.SETS $HR1 TIM[1:2]
	.SETS TIM1 TIM[1:2]

.;  If the time and date of the appointment are the time and date now
.;  then mail and broadcast the sucker some messages reminding him of
.;  the appointment:

 .IF YR = $YR1 .IF MO = $MO1 .IF DA = $DA1 .IF HR = $HR1 .GOSUB MAILIT
	.RETURN

.MAILIT:
	.OPEN #2 XXXX.MAI
	.SETS $APPOI $APPOI[13:66]
	.DATA #2 Appointment '$APPOI' now
	.CLOSE #2
	MAIL XXXX.MAI/NO TO '$USR'
	PIP XXXX.MAI;*/DE

.;  Also broadcast a message, just in case:

	BRO '$TERM' Appointment now: '$APPOI'
	.RETURN

.GETMN:
	.IF $MO1 = "JAN" .SETS $MO1 "01"
	.IF $MO1 = "FEB" .SETS $MO1 "02"
	.IF $MO1 = "MAR" .SETS $MO1 "03"
	.IF $MO1 = "APR" .SETS $MO1 "04"
	.IF $MO1 = "MAY" .SETS $MO1 "05"
	.IF $MO1 = "JUN" .SETS $MO1 "06"
	.IF $MO1 = "JUL" .SETS $MO1 "07"
	.IF $MO1 = "AUG" .SETS $MO1 "08"
	.IF $MO1 = "SEP" .SETS $MO1 "09"
	.IF $MO1 = "OCT" .SETS $MO1 "10"
	.IF $MO1 = "NOV" .SETS $MO1 "11"
	.IF $MO1 = "DEC" .SETS $MO1 "12"
.RETURN
.OPNERR:
    .CLOSE
    .OPEN XXX.MAI
    .DATA --MD-- Error on OPEN calender file:  '$FIL' on '<DATE>' at '<TIME>'
    .CLOSE
    MAIL XXX.MAI TO MFW
    PIP XXX.MAI;*/DE
.RETURN
.GETOUT:
                                                                                                                                                                           