
C  include constant definition if not defined
C###############################################################################
C	Definitions of constants used in the PP software
C###############################################################################
C###############################################################################
C	Codes that are used in initialization of the prom programmer
C###############################################################################
C###############################################################################
C	Function code returns from the PP
C###############################################################################
C###############################################################################
C	Codes returned by HOST PP subroutines
C###############################################################################
C
      PROGRAM PROM
C
C###############################################################################
C	Program for programming, listing and verifying PROMs.
C
C
C	Please refer to the 'SYSTEM 19 UNIVERSAL PROGRAMMER 990-1902
C   INSTRUCTION MANUAL'.
C
C	pages                 |    topic
C	----------------------|------------------------------------------------
C	APPENDIX 2-1 to 2-4   |    data translation formats
C	APPENDIX 3-1 to 3-8   |    remote control operation and command summary
C	3-8 to 3-9            |    detailed error description
C###############################################################################
      INTEGER GETL, GETTY, SHRTEN, GETHEX
      BYTE OPTION, ANY
      BYTE LINE ( 132 )
      BYTE MEMORY ( 8192 )
      COMMON / PROM / LINE, MEMORY
      CALL PUTL ( ' ', 5 )
      CALL PUTL ( ' 	PROM	version 2	May 82', 5 )
      CALL PRMINI
20000 CONTINUE
      CONTINUE
20003 CONTINUE
      CALL PUTL ( ' ', 5 )
      L = GETTY ( 
     $' option (L)ist, (P)rogram, (V)erify, (E)nd , (H)elp: ', LINE )
      L = SHRTEN ( LINE, ' 	' )
      CALL LCUC ( LINE )
      IF (.NOT.( ANY ( 'H', LINE ) .GT. 0 )) GOTO 20006
      CALL HELP
      GOTO 20004
20006 CONTINUE
      IF (.NOT.( ANY ( 'LPVE', LINE ) .LT. 0 )) GOTO 20008
      IF (.NOT.( LENGTH ( LINE ) .GT. 0 )) GOTO 20010
      CALL PUTL ( ' * invalid option', 5 )
      GOTO 20011
20010 CONTINUE
      CALL PUTL ( ' 	PROM	version 2	May 82', 5 )
20011 CONTINUE
      GOTO 20004
20008 CONTINUE
      OPTION = LINE ( 1 )
      GOTO 20005
20009 CONTINUE
20004 GOTO 20003
20005 CONTINUE
      IF (.NOT.( OPTION .EQ. 'E' )) GOTO 20012
      CALL PRMSTP
      STOP
20012 CONTINUE
      CALL DOIT ( OPTION )
20001 GOTO 20000
20002 CONTINUE
      END

C
      SUBROUTINE HELP
C
C###############################################################################
C	This routine prints a help message to the terminal
C###############################################################################
      CALL PUTL ( ' ', 5 )
      CALL PUTL ( ' 	PROM	version 2	May 82', 5 )
      CALL PUTL ( ' ', 5 )
      CALL PUTL ( 
     $'      PROM.SAV is a fairly simple utility  program  which  incor
     $porates', 5 )
      CALL PUTL ( 
     $' these  basic functions described above.  It allows the user to 
     $program', 5 )
      CALL PUTL ( 
     $' a PROM or list or verify the contents of a PROM.  The  data  in
     $put  to', 5 )
      CALL PUTL ( 
     $' the  program is read from an input file (i.e.  in the case when
     $ a PROM', 5 )
      CALL PUTL ( 
     $' is being programmed).  When an input file  is  read,  several  
     $options', 5 )
      CALL PUTL ( 
     $' must  be  specified.   First, only the HEX data in between colu
     $mn LEFT', 5 )
      CALL PUTL ( 
     $' and column RIGHT inclusively is actually used.  Also, it  is  p
     $ossible', 5 )
      CALL PUTL ( 
     $' to  allow  for a single character comment delimiter in the inpu
     $t file.', 5 )
      CALL PUTL ( ' ', 5 )
      CALL PUTL ( 
     $'      In the program PROM, two HEX parameters (BEGIN  and  OFFSE
     $T)  are', 5 )
      CALL PUTL ( 
     $' used  to  map  from  the VIRTUAL address space of the microcomp
     $uter on', 5 )
      CALL PUTL ( 
     $' which the PROM resides to the ABSOLUTE address of a specific  b
     $yte  in', 5 )
      CALL PUTL ( 
     $' PROM  relative to the hex address 0000 which is the start of th
     $e PROM.', 5 )
      CALL PUTL ( 
     $' The VIRTUAL base address is specified by the parameter BEGIN, a
     $nd  the', 5 )
      CALL PUTL ( 
     $' absolute  base  address  is  specified by BEGIN-OFFSET.  The nu
     $mber of', 5 )
      CALL PUTL ( 
     $' bytes actually tested, read or programmed is exactly COUNT,  wh
     $ich  is', 5 )
      CALL PUTL ( ' also a HEX value.', 5 )
      CALL PUTL ( ' ', 5 )
      CALL PUTL ( 
     $'     The program PROM will handle up to 4k (4096(10), 1000(16)) 
     $bytes of', 5 )
      CALL PUTL ( 
     $' memory, however  the program may be rebuilt if larger array  sp
     $ace  is', 5 )
      CALL PUTL ( 
     $' needed to accomodate larger PROMs. PROM will  accept  commands 
     $ stored', 5 )
      CALL PUTL ( 
     $' in an indirect  command file, (e.g.  the first command in the  
     $file is', 5 )
      CALL PUTL ( 
     $' to RUN PROM, etc...) PROM.SAV is not (as yet) documented elsewh
     $ere.', 5 )
      RETURN
      END

C
      SUBROUTINE DOIT ( OPTION )
C
C###############################################################################
C	Subroutine accepts a single character command, either 'P', 'L', 'V' or 'E'
Cand processes the command, then returns for the next command.
C
C	The subroutine calculates addresses according to the formula:
C
C		abegin=rbegin-offset
C
Cwhere, OFFSET is entered by the user in response to the prompt OFFSET, and
CRBEGIN is entered by the user in response to the BEGIN prompt.
C###############################################################################
      INTEGER GETL, GETTY, SHRTEN, GETHEX
      INTEGER LEFT, RIGHT
      BYTE COUNT ( 4 ), RBEGIN ( 4 ), ABEGIN ( 4 ), SUM ( 4 )
      BYTE TEMP1 ( 4 ), TEMP2 ( 4 ), OFFSET ( 4 )
      BYTE OPTION, ANY, MEMCHK, HEXSUB
      BYTE LINE ( 132 )
      BYTE MEMORY ( 8192 )
      COMMON / PROM / LINE, MEMORY
20014 CONTINUE
      IOFSET = GETHEX ( ' offset [hex, def=0]: ', OFFSET )
      IBEGIN = GETHEX ( ' begin [hex, def=0]: ', RBEGIN )
      IF (.NOT.( HEXSUB ( RBEGIN, OFFSET, ABEGIN ) )) GOTO 20017
      GOTO 20016
20017 CONTINUE
      CALL PUTL ( ' 	*ERROR* OFFSET less than BEGIN', 5 )
      RETURN
20018 CONTINUE
20015 GOTO 20014
20016 CONTINUE
      ICNT = GETHEX ( ' count [hex, def=0, max=1000]: ', COUNT )
      IF (.NOT.( ICNT .GT. 4096 )) GOTO 20019
      CALL PUTL ( ' 	*ERROR* COUNT greater than PROM memory size', 5 )
      RETURN
20019 CONTINUE
      IF (.NOT.( OPTION .EQ. 'L' )) GOTO 20021
      L = GETTY ( ' output file [def=tt:]: ', LINE )
      CONTINUE
20023 CONTINUE
      IF (.NOT.( L .EQ. 0 )) GOTO 20026
      CALL COPY ( 'TT:', LINE, 4 )
20026 CONTINUE
      OPEN ( UNIT = 3, NAME = LINE, TYPE = 'NEW', ACCESS = 'SEQUENTIAL'
     $, FORM = 'FORMATTED', ERR = 10 )
      GOTO 20025
10    CALL PUTL ( '$ re-enter output file: ', 5 )
      L = GETL ( LINE, 132, 5 )
20024 GOTO 20023
20025 CONTINUE
      GOTO 20022
20021 CONTINUE
      L = GETTY ( ' input file : ', LINE )
      CONTINUE
20028 CONTINUE
      OPEN ( UNIT = 4, NAME = LINE, TYPE = 'OLD', ACCESS = 'SEQUENTIAL'
     $, FORM = 'FORMATTED', ERR = 20 )
      GOTO 20030
20    CALL PUTL ( '$ re-enter input file: ', 5 )
      L = GETL ( LINE, 132, 5 )
20029 GOTO 20028
20030 CONTINUE
      CALL PUTL ( '$ input file left margin: ', 5 )
      LEFT = INTGET ( 0, 130 )
      CALL PUTL ( '$ input file right margin: ', 5 )
      RIGHT = INTGET ( LEFT + 1, 132 )
      L = GETTY ( ' comment delimiter [return if none]: ', LINE )
      ISTS = LODMEM ( LEFT, RIGHT, LINE, 4, COUNT, MEMORY )
      CLOSE ( UNIT = 4 )
      IF (.NOT.( ISTS .EQ. - 3 )) GOTO 20031
      CALL PUTL ( ' 	*ERROR* illegal HEX data read from file', 5 )
      RETURN
20031 CONTINUE
      IF (.NOT.( ISTS .LT. 0 )) GOTO 20033
      CALL ERRH ( ISTS )
      RETURN
20033 CONTINUE
      IF (.NOT.( ISTS .EQ. 0 )) GOTO 20035
      CALL PUTL ( ' no data read from input file', 5 )
      RETURN
20035 CONTINUE
      IF (.NOT.( ICNT .GT. ISTS )) GOTO 20037
      CALL BINHEX ( ICNT, TEMP1 )
      CALL BINHEX ( ISTS, TEMP2 )
      WRITE ( 5, 200 ) ( TEMP1 ( J ), J = 1, 4 ), ( TEMP2 ( J ), J = 1,
     $ 4 )
200   FORMAT ( ' # of bytes expected: ', 4a1, '   # of bytes read: ', 
     $4a1 )
      CALL PUTL ( '$ continue? [Y/N] : ', 5 )
      L = GETL ( LINE, 132, 5 )
      IF (.NOT.( LINE ( 1 ) .NE. 'Y' .AND. LINE ( 1 ) .NE. 'y' )) GOTO 
     $20039
      RETURN
20039 CONTINUE
      ICNT = ISTS
      CALL BINHEX ( ICNT, COUNT )
      CALL PUTL ( 
     $' COUNT changed to reflect number of data points READ', 5 )
20037 CONTINUE
20036 CONTINUE
20034 CONTINUE
20022 CONTINUE
      CALL BEGDEV ( ABEGIN, ISTS )
      IF (.NOT.( ISTS .NE. 1 )) GOTO 20041
      CALL PUTL ( ' 	*ERROR* setting BEGIN', 5 )
      CALL ERRH ( ISTS )
      RETURN
20041 CONTINUE
      CALL BLKSIZ ( COUNT, ISTS )
      IF (.NOT.( ISTS .NE. 1 )) GOTO 20043
      CALL PUTL ( ' 	*ERROR* setting COUNT', 5 )
      CALL ERRH ( ISTS )
      RETURN
20043 CONTINUE
      CALL PUTL ( 
     $'$ insert prom in adapter socket (return when done): ', 5 )
      L = GETL ( LINE, 132, 5 )
      IF (.NOT.( OPTION .EQ. 'P' )) GOTO 20045
      CALL BLANK ( ISTS )
      IF (.NOT.( ISTS .EQ. 0 )) GOTO 20047
      CALL PUTL ( '$ * PROM is not blank, continue [Y/N] : ', 5 )
      L = GETL ( LINE, 132, 5 )
      IF (.NOT.( LINE ( 1 ) .NE. 'Y' .AND. LINE ( 1 ) .NE. 'y' )) GOTO 
     $20049
      RETURN
20049 CONTINUE
      GOTO 20048
20047 CONTINUE
      IF (.NOT.( ISTS .NE. 1 )) GOTO 20051
      CALL PUTL ( ' 	*ERROR* in PROM BLANK test', 5 )
      CALL ERRH ( ISTS )
      RETURN
20051 CONTINUE
20048 CONTINUE
      CALL INDATA ( COUNT, MEMORY, ISTS )
      IF (.NOT.( ISTS .NE. 1 )) GOTO 20053
      CALL PUTL ( ' 	*ERROR* host to programmer RAM data transfer', 5 )
      CALL ERRH ( ISTS )
      RETURN
20053 CONTINUE
      CALL PRGRM ( ISTS )
      IF (.NOT.( ISTS .NE. 1 )) GOTO 20055
      CALL PUTL ( ' 	*ERROR* programmer RAM to PROM data transfer', 5 )
      CALL ERRH ( ISTS )
      RETURN
20055 CONTINUE
20045 CONTINUE
      CALL LOAD ( ISTS )
      IF (.NOT.( ISTS .NE. 1 )) GOTO 20057
      CALL PUTL ( ' 	*ERROR* PROM to programmer RAM data transfer', 5 )
      CALL ERRH ( ISTS )
      RETURN
20057 CONTINUE
      IF (.NOT.( OPTION .EQ. 'L' )) GOTO 20059
      CALL ODATA ( COUNT, MEMORY, ISTS )
      IF (.NOT.( ISTS .NE. 1 )) GOTO 20061
      CALL PUTL ( ' 	*ERROR* programmer RAM to host data transfer', 5 )
      CALL ERRH ( ISTS )
      RETURN
20061 CONTINUE
      CALL LSTMEM ( RBEGIN, COUNT, MEMORY, 3, ISTS )
      IF (.NOT.( .NOT. MEMCHK ( COUNT, MEMORY, SUM ) )) GOTO 20063
      CALL PUTL ( ' 	*ERROR* checksum calculation', 5 )
      RETURN
20063 CONTINUE
      WRITE ( 3, 300 ) ( SUM ( J ), J = 1, 4 )
300   FORMAT ( ' checksum: ', 4a1 )
      CLOSE ( UNIT = 3 )
20059 CONTINUE
      IF (.NOT.( OPTION .EQ. 'V' .OR. OPTION .EQ. 'P' )) GOTO 20065
      CALL PUTL ( ' beginning verification', 5 )
      CALL CMPRAM ( RBEGIN, OFFSET, COUNT, MEMORY, 5, ISTS )
      IF (.NOT.( ISTS .NE. 1 )) GOTO 20067
      CALL PUTL ( ' 	*ERROR* during verification', 5 )
      CALL ERRH ( ISTS )
      RETURN
20067 CONTINUE
      CALL PUTL ( ' verification complete', 5 )
20068 CONTINUE
20065 CONTINUE
      RETURN
      END

C
      INTEGER FUNCTION GETHEX ( PMT, HEXVAL )
C
C###############################################################################
C	Reads a hex value from the terminal, returns ASCII hex value in HEXVAL
Cand integer value is returned as value of function. Function re-reads until
Clegal value is obtained. PMT is an arbitrary length string that is written to
Cterminal as a prompt.
C###############################################################################
      BYTE HEXVAL ( 4 ), HEXBIN, PMT ( 1 )
      INTEGER GETTY, GETL, SHRTEN
      BYTE LINE ( 132 )
      BYTE MEMORY ( 8192 )
      COMMON / PROM / LINE, MEMORY
      L = GETTY ( PMT, LINE )
20069 CONTINUE
      L = SHRTEN ( LINE, ' 	' )
      CALL LCUC ( LINE )
      IF (.NOT.( L .GT. 4 .OR. .NOT. HEXBIN ( LINE, IVAL ) )) GOTO 
     $20072
      CALL PUTL ( '$ re-enter HEX value [HHHH] : ', 5 )
      L = GETL ( LINE, 132, 5 )
      GOTO 20073
20072 CONTINUE
      CONTINUE
       I = 1
20074 IF (.NOT.( I .LE. L)) GOTO 20076
      HEXVAL ( I ) = LINE ( I )
20075 I = I + 1 
      GOTO 20074
20076 CONTINUE
      IF (.NOT.( L .LT. 4 )) GOTO 20077
      HEXVAL ( L + 1 ) = 0
20077 CONTINUE
      gethex = ( IVAL )
      RETURN
20073 CONTINUE
20070 GOTO 20069
20071 CONTINUE
      END

C
      SUBROUTINE ERRH ( ISTS )
C
C###############################################################################
C	ERROR handler subroutine, writes message indicating kind of
Cerror that occured.
C###############################################################################
      BYTE ERRLIN ( 10 )
      IF (.NOT.( ISTS .EQ. 0 )) GOTO 20079
      CALL PUTL ( ' 	*ERROR* function failed', 5 )
      GOTO 20080
20079 CONTINUE
      IF (.NOT.( ISTS .EQ. - 2 )) GOTO 20081
      CALL ERRSTS ( ERRLIN, ISTS )
      IF (.NOT.( ISTS .NE. 1 )) GOTO 20083
      CALL PUTL ( ' 	*ERROR* unable to reset PPERR error', 5 )
      RETURN
20083 CONTINUE
      WRITE ( 5, 101 ) ( ERRLIN ( J ), J = 1, 8 )
101   FORMAT ( ' 	*ERROR* error status : ', 8a1 )
      CALL PUTL ( 
     $' 	(see PROM programmer manual APPENDIX pages 3-8 and 3-9)', 5 )
      GOTO 20082
20081 CONTINUE
      IF (.NOT.( ISTS .EQ. - 1 )) GOTO 20085
      CALL PUTL ( ' 	*ERROR* serial receiver communications error', 5 )
      GOTO 20086
20085 CONTINUE
      IF (.NOT.( ISTS .EQ. - 3 )) GOTO 20087
      CALL PUTL ( ' 	*ERROR* illegal hex value', 5 )
20087 CONTINUE
20086 CONTINUE
20082 CONTINUE
20080 CONTINUE
      RETURN
      END

                                                                                                                                                                                                                                                                                                                                                                                                                                                                           