	SUBROUTINE VTROLL(ITOP,IBOT)
C
C	FUNCTION: SETS THE VT100 SCROLL AREA
C	ARGUMENTS: ITOP IS THE TOP OF THE ROLL AREA
C		   IBOT IS THE BOTTOM OF THE ROLL AREA
C	IF IBOT<= ITOP THE ROUTINE WILL RETURN WITH NO ACTION
C
	BYTE CHAR(10)
	DATA CHAR/27,'[',0,0,';',0,0,'r',0,0/
	IF (IBOT .LE. ITOP)RETURN
	ENCODE(2,10,CHAR(3))ITOP
10	FORMAT(I2)
	ENCODE(2,10,CHAR(6))IBOT
	IF (CHAR(3).EQ.' ')CHAR(3)=0
	IF (CHAR(6).EQ.' ')CHAR(6)=0
	CALL OUTSTR(CHAR,8)
	RETURN
	END
	SUBROUTINE VTERAS(IARG)
C
C	FUNTION: ERASE ALL OR A PORTION OF THE SCREEN
C	ARGUMENTS: IARG =0 ERASE FROM CURSOR TO END OF SCREEN
C		   	=1 ERASE FROM START OF SCREEN TO CURSOR
C			=2 ERASE ENTIRE SCREEN AND RESET TO SINGLE WIDTH
C
	BYTE CHAR(5)
	DATA CHAR/27,'[',0,'J',0/
	IF ((IARG .LT. 0).OR.(IARG .GT. 2))RETURN
	CHAR(3)=IARG+"60
	CALL OUTSTR(CHAR)
	RETURN
	END
	SUBROUTINE VTMCUR(IROW,ICOL)
C
C	FUNCTION: POSITION THE CURSOR TO A PARTICULAR ROW AND COLUMN
C	ARGRUMENTS: IROW    THE ROW POSITION
C		    ICOL    THE COLUMN POSITION
C	THE VALIDITY OF THE POSITION IS NOT CHECKED
C
	BYTE CHAR(9)
	DATA CHAR/27,'[',0,0,';',0,0,0,'H'/
	ENCODE(2,10,CHAR(3))IROW
10	FORMAT(I2)
	ENCODE(3,11,CHAR(6))ICOL
11	FORMAT(I3)
	DO 20 I=3,7
	IF(CHAR(I).EQ.' ')CHAR(I)=0
20	CONTINUE
	CALL OUTSTR(CHAR,9)
	RETURN
	END
	SUBROUTINE VTHOME
C
C	MOVES THE CURSOR TO THE HOME POSITION
C
	BYTE CHAR(4)
	DATA CHAR/27,'[',';','H'/
	CALL OUTSTR(CHAR,4)
	RETURN
	END
	SUBROUTINE VTHTXT(IDSPLY,IROW,ICOL,ITEXT)
C
C	FUNCTION::	PRINTS THE STRING CONTAINED IN ITEXT WITH

C			THE FIRST CHARACTER AT IROW,ICOL IN A 
C			DISPLAY MODE GOVERNED BY IDSPLY
C	ARGUMENTS::
C		IDSPLY  (IN ORDER TO INVOKE COMBINATION OF OPTIONS
C			USE THE SUM OF THE CODES)
C		  0	NO EFFECT
C		  1	BOLD
C		  2	UNDERSCORE
C		  4	BLINK
C		  8	REVERSE
C
C		IROW AND ICOL ARE THE ROW AND COLUMN FOR THE FIRST CHARACTER
C		ITEXT IS A BYTE ARRAY CONTAINING THE DATA (WHICH MUST BE 
C		     TERMINATED BY A NULL CHARACTER), OR A QUOTED LITERAL
C
	BYTE CHAR(2),C(4)
	DATA C/0,';','m',0/
	DATA CHAR/27,'['/
	CALL VTMCUR(IROW,ICOL)
	IFLAG=0
	IF (IDSPLY .EQ. 0)GOTO 100
	CALL OUTSTR(CHAR,2)
	IF ((IDSPLY.AND.1) .EQ. 0)GOTO 1
	IFLAG=1
	C(1)="61
	CALL OUTSTR(C,1)
1	IF ((IDSPLY.AND.2) .EQ. 0)GOTO 2
	IF (IFLAG.EQ.1)CALL OUTSTR(';')
	IFLAG=1
	C(1)="64
	CALL OUTSTR(C,1)
2	IF ((IDSPLY.AND.4) .EQ. 0)GOTO 3
	IF(IFLAG.EQ.1)CALL OUTSTR(';')
	IFLAG=1
	C(1)="65
	CALL OUTSTR(C,1)
3	IF ((IDSPLY.AND.8) .EQ. 0)GOTO 4
	IF(IFLAG.EQ.1)CALL OUTSTR(';')
	C(1)="67
	CALL OUTSTR(C,1)
4	CALL OUTSTR('m')	!TERMINATE LIST
100	CALL OUTSTR(ITEXT)
	C(1)="60
	CALL OUTSTR(CHAR)	!TURN ATTRIBUTES OFF
	RETURN
	END
	SUBROUTINE VTLED(IARG)
C
C	FUNCTION: ALLOW THE USER TO CONTROL THE LED DISPLAY ON THE 
C		  KEYBOARD
C	ARGUMENTS: A SINGLE INTEGER ARGUMENT IS USED, AND, DEPENDING
C		   ON THE VALUE OF THE ARGUMENT CAN CAUSE THE FOLLOWING
C		   IARG		FUNCTION
C		    0 		ALL LEDS OFF
C		    1		LED #1 ON
C		    2		LED #2 ON
C		    3		LED #3 ON
C		    4		LED #4 ON
C
C	ANY OTHER VALUES WILL BE IGNORED
C
	BYTE CHAR(6)
	DATA CHAR/27,'[',0,'q',0,0/
	IF((IARG.LT.0) .OR. (IARG.GT.4))RETURN
	CHAR(3)="60+IARG
	CALL OUTSTR(CHAR)
	RETURN
	END
	SUBROUTINE VTGCUR(IROW,ICOL)
C
C	FUNCTION: OBTAIN THE CURRENT ROW AND COLUMN POSITION FOR THE
C		  CURSOR
C	ARGUMENTS: IROW AND ICOL ARE INTEGER VARIABLES, WHICH ON
C		   RETURN FROM THE SUBROUTINE, WILL CONTAIN THE
C		   DESIRED INFORMATION
C
	BYTE CHAR(5),INCHR(10),IBYTE,FMT(16),ASCII(3)
	EQUIVALENCE (ISTR,INCHR(1))
	DATA FMT/'(','2','X',',','I','?',',','1','X',',','I','?',
     1	',','1','X',')'/	!DECODE FORMAT
	DATA CHAR/27,'[','6','n',0/
	DATA ASCII/'1','2','3'/
	JSW=IPEEK("44)
	CALL IPOKE("44,"10000.OR.JSW)	!SPECIAL MODE
	CALL OUTSTR(CHAR)	!SEND INQUIRY STRING
	DO 10 I=1,9	!LOOP TO GET CHARACTERS BACK
1	ITEST=ITTINR()
	IF (ITEST .LT. 0)GOTO 1
	IBYTE=ITEST
	INCHR(I)=IBYTE
	IF (IBYTE .EQ. 'R')GOTO 12
10	CONTINUE
C
C	NOW SET UP DECODING FORMAT
C
12	NCHAR=I		!NUMBER OF CHARACTERS TO DECODE
	IF(INCHR(4).NE.';')GOTO 20
	FMT(6)='1'	!MODIFY FORMAT
	ISEMI=4		!POINT TO POSITION OF SEMICOLON
	GOTO 30		!FIND NEXT NUMERIC STRING
20	FMT(6)='2'	!DECODE 2 CHARACTERS
	ISEMI=5		!SPOT SEMICOLON
30	I=0
32	I=I+1		!I IS THE POSITION POINTER
	IF(INCHR(ISEMI+1+I).NE.'R')GOTO 32
	FMT(12)=ASCII(I)	!MODIFY FORMAT FOR SECOND CHARACTER
100	DECODE(NCHAR,FMT,INCHR(1))IROW,ICOL
	CALL IPOKE("44,JSW)	!RESET SPECIAL MODE
	RETURN
	END
	SUBROUTINE VTDBLW(IROW,IARG)
C
C	FUNCTION:  SWITCHES A LINE TO DOUBLE WIDTH/SINGLE WIDTH DEPENDING
C		   ON IARG
C	ARGUMENTS: IARG:  IF =0 SINGLE WIDTH
C			  IF =1 DOUBLE WIDTH
C
	BYTE C0(4),C1(4)
	DATA C0/27,'#','5',0/
	DATA C1/27,'#','6',0/
	IF ((IARG .LT. 0) .OR. (IARG .GT. 1))RETURN
	CALL VTGCUR(IR,ICOL)
	CALL VTMCUR(IROW,1)
	IF (IARG .EQ. 1)GOTO 1
	CALL OUTSTR(C0)
	GOTO 2
1	CALL OUTSTR(C1)
2	CALL VTMCUR(IR,ICOL)
	RETURN
	END
	SUBROUTINE VT80C
C
C	SUBROUTINE TO SET VT100 TO 80 COLUMN MODE
C
C	CALLING SEQUENCE: CALL VT80C
C
C
	BYTE CHAR(6)
	DATA CHAR/27,'[','?','3','l',0/
	CALL OUTSTR(CHAR)
	RETURN
	END
	SUBROUTINE VT132C
C
C	SUBROUTINE TO SET VT100 TO 132 COLUMN MODE
C
C	CALLING SEQUENCE: CALL VT132C
C
	BYTE CHAR(6)
	DATA CHAR/27,'[','?','3','h',0/
	CALL OUTSTR(CHAR)
	RETURN
	END
	SUBROUTINE VTJUMP
C
C	SUBROUTINE TO SET VT100 TO JUMP MODE
C
C	CALLING SEQUENCE: CALL VTJUMP
C
	BYTE CHAR(6)
	DATA CHAR/27,'[','?','4','l',0/
	CALL OUTSTR(CHAR)
	RETURN
	END
	SUBROUTINE VTSCRL
C
C	SUBROUTINE TO SET VT100 TO JUMP MODE
C
C	CALLING SEQUENCE: CALL VTSCRL
C
	BYTE CHAR(6)
	DATA CHAR/27,'[','?','4','h',0/
	CALL OUTSTR(CHAR)
	RETURN
	END
	SUBROUTINE VTBRIT
C
C	SUBROUTINE TO GIVE THE TERMINAL A LIGHT BACKGROUND
C
C	CALLING SEQUENCE: CALL VTBRIT
C
	BYTE CHAR(6)
	DATA CHAR/27,'[','?','5','h',0/
	CALL OUTSTR(CHAR)
	RETURN
	END
	SUBROUTINE VTDARK
C
C	SUBROUTINE TO GIVE THE TERMINAL A DARK BACKGROUND
C
C	CALLING SEQUENCE: CALL VTDARK
C
	BYTE CHAR(6)
	DATA CHAR/27,'[','?','5','l',0/
	CALL OUTSTR(CHAR)
	RETURN
	END
                                   