	PROGRAM TST101
C	
C	This program can be used for testing the VT escape codes sequences
C	using a hard copy terminal, such as the LA36 DecWriter, which does
C	not respond to the codes. It is similar in operation to TST100 and
C	takes identical input codes (see last page of VT.TXT for a sorted
C	list of codes). The only difference from TST100 is that the
C	backspacing over echoed output for the VT100 is replaced by a
C	carriage return/line feed combination (at labels 30 & 60), as
C	backspacing over the echoed hard-copy output causes over-printing
C	on the LA36 and is not appropriate.
C	
	IMPLICIT INTEGER (A-Z)
	DATA A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z/
     1	65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,
     2	85,86,87,88,89,90/
	CALL IPOKE("44,"40000.OR.IPEEK("44))	! Enable lower case output
	CALL ANSI
1	CALL SAVCUR
	CALL CUP(1,1)
	CALL CLRLIN
	CALL IPOKE("44,"167777.AND.IPEEK("44))	! Unset terminal special mode
	TYPE 100
100	FORMAT('+O.K.  INPUT LINE,COL  '$)
	ACCEPT *,LINE,COL
	CALL IPOKE("44,"10000.OR.IPEEK("44))	! Set terminal special mode
	CALL RESCUR
10	INPUT=ITTINR()
	IF(INPUT.LT. 0)		GOTO 10	! Go back for input if none typed
	IF(INPUT.LE.32)		GOTO 35	! Don't echo control characters
20	IF(ITTOUR(INPUT).NE.0)	GOTO 20	! Echo the character
30	CONTINUE			! In TST100 this line backspaces
35	CALL ISLEEP(0,0,0,8)		! Wait 8 ticks
	IF(INPUT.EQ.1)	GOTO 1		! Ctrl A for new "LINE,COL" values
	IF(INPUT.EQ.4)	GOTO 50		! Ctrl D to reset VT100 and stop
	IF(INPUT.EQ.7)  GOTO 11		! Ctrl G for new "MODE" value
	IF(INPUT.EQ.A)	CALL SAVCUR
	IF(INPUT.EQ.B)	CALL RESCUR
	IF(INPUT.EQ.C)	CALL KPAM
	IF(INPUT.EQ.D)	CALL KPNM
	IF(INPUT.EQ.E)	CALL RIS
	IF(INPUT.EQ.F)	CALL RI
	IF(INPUT.EQ.G)	CALL ALIGND
	IF(INPUT.EQ.H)	CALL BIGTOP
	IF(INPUT.EQ.I)	CALL BIGBOT
	IF(INPUT.EQ.J)	CALL DWL
	IF(INPUT.EQ.K)	CALL SWL
	IF(INPUT.EQ.L)	CALL SGS
	IF(INPUT.EQ.M)	CALL DGS
	IF(INPUT.EQ.N)	CALL CLRALL
	IF(INPUT.EQ.O)	CALL CLRTOP
	IF(INPUT.EQ.P)	CALL CLRBOT
	IF(INPUT.EQ.Q)	CALL LL  (MODE)
	IF(INPUT.EQ.R)	CALL CLRLIN
	IF(INPUT.EQ.S)	CALL CLRBEG
	IF(INPUT.EQ.T)	CALL CLREND
	IF(INPUT.EQ.U)	CALL NEGVID
	IF(INPUT.EQ.V)	CALL POSVID
	IF(INPUT.EQ.W)	CALL SM  (MODE)
	IF(INPUT.EQ.X)	CALL RM  (MODE)
	IF(INPUT.EQ.Y)	CALL CUP (LINE,COL)
	IF(INPUT.EQ.Z)	CALL STBM(LINE,COL)
	IF(INPUT.EQ.91) CALL NEL		! [ has Ascii value 91
	IF(INPUT.EQ.92) CALL IND		! \ has Ascii value 92
	IF(INPUT.EQ.49) CALL CUU(MODE)		! 1 has Ascii value 49
	IF(INPUT.EQ.50) CALL CUD(MODE)		! 2 has Ascii value 50
	IF(INPUT.EQ.51) CALL CUF(MODE)		! 3 has Ascii value 51
	IF(INPUT.EQ.52) CALL CUB(MODE)		! 4 has Ascii value 52
	IF(INPUT.EQ.53) CALL ANSI		! 5 has Ascii value 53
	IF(INPUT.EQ.54) CALL CRLF		! 6 has Ascii value 54
C	The following statement echoes the input character in lower case,
C	if it is a letter; consult a table of Ascii codes to see how
C	non-alphabetic characters should echo
40	IF(ITTOUR(INPUT+32).NE.0) GOTO 40
60	CALL CRLF			! In TST100 this line backspaces
	GOTO 10
11	CALL SAVCUR
	CALL CUP(1,1)
	CALL CLRLIN
	CALL IPOKE("44,"167777.AND.IPEEK("44))
	TYPE 110
110	FORMAT('+O.K.  INPUT MODE  '$)
	ACCEPT *,MODE
	CALL IPOKE("44,"10000.OR.IPEEK("44))
	CALL RESCUR
	GOTO 10
50	CALL RIS
	CALL EXIT
	END
                                                                                                                                                                                                                                                                                            