	SUBROUTINE GRINDX(IBUF,X,NPTS,ARRAY,IGR)
C
C	GRINDX ALLOWS THE USER TO MOVE A CURSOR ALONG THE SCREEN
C	AND "REMEMBER" THE CURSOR POSITION FOR UP TO 10 POINTS.
C
C	THE POINTS ARE NUMBERED 1-0 (0  IS THE TENTH POINT) AND WILL
C	FILL THE REAL ARRAY "ARRAY" AT THOSE APPROPRIATE POSITIONS.
C
C	TYPING A CARRIGE RETURN WILL CAUSE THE USER TO EXIT FROM THE
C	SUBROUTINE
C
C	CURSOR POSITIONING IS PERFORMED WITH THE CURSOR CONTROL KEYS
C	FOR LEFT AND RIGHT MOVEMENT, THE CURSORS WILL RIDE ON THE DATA
C
C	ANY CHARACTERS NOT MENTIONED ABOVE WILL CAUSE THE TERMINAL TO
C	BEEP
C
C----------------------------------------------------------------
C
C	THE ARGUMENTS FOR THE SUBROUTINE ARE AS FOLLOWS:
C
C	IBUF	THE INFORMATION BUFFER DESCRIBED IN GRDOC
C	X	THE DATA VECTOR FOR THE X AXIS
C	NPTS	THE NUMBER OF POINTS IN THE DATA
C	ARRAY	THE TEN ELEMENT ARRAY WHICH WILL CONTAIN THE
C		CURSOR POSITIONS ON EXIT
C	IGRAPH	THE GRAPH NUMBER (0/1)
C
C	DEFAULTS::
C
C	IGRAPH ==> 0
C	X      ==> POINT COUNT
C
C
	DIMENSION IBUF(1),TEMP(2),ITEMP(4),ARRAY(1),X(1),IB(2)
	BYTE CMD(4),ENTRGR(3),EXITGR(3),IGCODE(2),CHAR(2),OKCHAR(16)
	EQUIVALENCE (TEMP(1),ITEMP(1))	!THIS IS TO PROVIDE A QUICK MEANS
	EQUIVALENCE (TEMP(1),XMIN)	!OF GETTING SCALED VALUES FROM
	EQUIVALENCE (TEMP(2),XMAX)	!FROM IBUF INTO THE APPROPRIATE
	DATA CMD(4)/0/
	DATA IB/10,18/
	DATA OKCHAR/'1','2','3','4','5','6','7','8','9','0',
     1	            "15,'D','C','[',"33,0/ !VALID KEYBOARD RESPONSES
	DATA ENTRGR/"33,'1',0/
	DATA EXITGR/"33,'2',0/
	DATA IGCODE/'C','K'/ !CODES FOR ACCESSING THE GRAPH MARKERS
	DATA CHAR(2)/0/
	F(Z,ZMAX,ZMIN)=(Z-ZMIN)/(ZMAX-ZMIN) !ARITH. STAT. FUNCTION
C
C	BEGINNING OF EXECUTABLE CODE
C
	PTS=NPTS !FLOAT THE NUMBER OF POINTS
	CALL IDFLT(IGRAPH,0,IGR)	!CHECK FOR DEFAULT ON GRAPH #
	IF((IGRAPH.EQ.0).OR.(IGRAPH.EQ.1))GOTO 1 !IGRAPH OK?
	CALL ERRMSG('?GRINDX - invalid graph number, must be 0/1')
	CALL EXIT
	RETURN
1	IF(IBUF(27).EQ."52525)GOTO 4 !GRINIT CALLED?
	CALL ERRMSG('?GRINDX - GRINIT not called')
	CALL EXIT
	RETURN
4	IRGN=IBUF(8+IGRAPH)
	IF(IRGN.NE.-1)GOTO 3	!FIND WHICH REGION IS BEING PLOTTED
	CALL ERRMSG('?GRINDX - graph not assigned to region')
	CALL EXIT
	RETURN
3	IFX=0 !INITIALIZE FLAG TO 0
	IF(IADDR(X).EQ."177777)IFX=1 !SHOW X DEFAULTED
C
C	GET SCALING VALUES FOR X AXIS
C
	IBASE=IB(IGRAPH+1)
10	IF(IBUF(2+IGRAPH).NE.0)GOTO 12	!HAVE SCALED VALUES BEEN ENTERED?
	CALL ERRMSG('?GRINDX - scaling has not been provided for graph')
	CALL EXIT
	RETURN
12	DO 15 I=1,4
15	ITEMP(I)=IBUF(IBASE+I) !GET SCALED VALUES FROM IBUF
C
	JSWOLD=IPEEK("44) !SAVE COPY OF OLD JSW
	CALL IPOKE("44,"50100.OR.JSWOLD) !MODIFY IT FOR ITTINR
	CALL OUTSTR(ENTRGR) !ENTER GRAPHICS MODE
C
C	CHECK TO SEE IF GRAPH MARKERS HAVE BEEN ENABLED, IF NOT,
C	ENABLE THEM.
C
	MASK=4 !MASK VALUE FOR GRAPH 0
	IF(IGRAPH.EQ.1)MASK=8 !MASK VALUE FOR GRAPH 1
	IF((MASK.AND.IBUF(6)).NE.0)GOTO 90
	IBUF(6)=IBUF(6).OR.MASK !SET BIT
	CMD(1)='I'
	CMD(2)=IBUF(6)
	CMD(3)=IBUF(7)
	CALL OUTSTR(CMD,3) !UPDATE REGISTER 1
C
C	NOW PUT UP THE CURSOR SO THAT THEY WILL KNOW WE ARE READY
C	... THEN GET AND PROCESS CHARACTERS
C
90	IOLD=1
	NEW=1
	GOTO 150 !PUT UP CURSOR
100	ICHAR=ITTINR()
	IF(ICHAR.LT.0)GOTO 100
	CHAR(1)=ICHAR
	CALL INDEX(OKCHAR,CHAR,,MPOS) !IF VALID, LOC. WILL BE IN MPOS
	IF(MPOS.NE.0)GOTO 110
	CALL OUTSTR(EXITGR) !OUT OF GRAPHICS MODE
	CALL OUTSTR(7,1) !RING BUZZER (BELL IF YOU ARE ASR33 ORIENTED)
	CALL OUTSTR(ENTRGR) !BACK INTO GRAPHICS
	GOTO 100 !TRY FOR MORE
110	GOTO (120,120,120,120,120,120,120,120,120,120,999,130,140,
     1        100,100),MPOS !GOTO APPROPRIATE ROUTINE FOR PROCESSING
120	ICHAR=ICHAR-"60 !CONVERT TO SUBSCRIPT
	IF(ICHAR.EQ.0)ICHAR=10 !'0' REALLY MEANS 10
	IF(IFX.EQ.0)ARRAY(ICHAR)=X(IOLD)
	IF(IFX.EQ.1)ARRAY(ICHAR)=IOLD
	GOTO 100 !GO BACK FOR MORE
130	NEW=IOLD-1
C	IF(MOD(NEW,128).EQ.1)NEW=NEW-1
	IF(NEW.LT.1)NEW=IOLD
	GOTO 150
140	NEW=IOLD+1
C	IF(MOD(NEW,128).EQ.1)NEW=NEW+1
	IF(NEW.GT.511)NEW=IOLD
150	CMD(1)=IGCODE(IGRAPH+1)
	IF(IFX.EQ.1)IX=(FLOAT(IOLD)/PTS)*511.
	IF(IFX.EQ.0)IX=F(X(IOLD),XMAX,XMIN)*511.
	IF(MOD(IX,128).EQ.0)GOTO 155 !DON'T ERASE UNIT MARKERS
	CMD(2)=32+(IX.AND."37)
	CMD(3)=32+((IX.AND."740)/32)
	CALL OUTSTR(CMD) !ERASE EXISTING CURSOR
155	IF(IFX.EQ.1)IX=(FLOAT(NEW)/PTS)*511.
	IF(IFX.EQ.0)IX=F(X(NEW),XMAX,XMIN)*511.
	CMD(2)=32+(IX.AND."37)
	CMD(3)=48+((IX.AND."740)/32)
	CALL OUTSTR(CMD) !PUT UP THE NEW ONE
	IOLD=NEW
	GOTO 100
999	CALL OUTSTR(EXITGR)
	CALL IPOKE("44,JSWOLD) !RESTORE JSW
	RETURN
	END
                                               