      COMPLEX Z,SUM,A(16384)
	CALL HEADER('COMPLEX VAR. U. OF SAN DIEGO BENCHMARK')
	DO 200 IXYZ = 1,2	!DO 2 ITERATIONS OF PROGRAM
	CALL TIMRB		!START OF TIMING LOOP
      N=16384
      DA=1./(N-1)
      DO 1 I=1,N
 1    A(I)=CMPLX(DA*(I-1),0.)
      CALL FFTTWO(A,N)
      CALL FFTINV(A,N)
      SUM=(0.,0.)
      DO 2 I=1,N
      Z=A(I)-CMPLX(DA*(I-1),0.)
 2    SUM=SUM+Z*CONJG(Z)
      RMS=SQRT(REAL(SUM)/N)
      WRITE(6,100)SUM,RMS
 100  FORMAT(10X,3E10.1)
	CALL TIMRE	!END OF TIMING LOOP
200	CONTINUE
      STOP
      END
      SUBROUTINE FFTTWO(A,N)
      DIMENSION A(N)
      COMPLEX A,U,W,T
      DATA PI/3.1415926535/
      M=ALOG(FLOAT(N))/0.693147
      IF(N.NE.2**M) GO TO 1000
      NV2=N/2
      NM1=N-1
      J=1
      DO 7 I=1,NM1
      IF(I.GE.J) GO TO 5
      T=A(J)
      A(J)=A(I)
      A(I)=T
5     K=NV2
6     IF(K.GE.J) GO TO 7
      J=J-K
      K=K/2
      GO TO 6
7     J=J+K
      LE=1
      DO 20 L=1,M
      LE1=LE
      LE=2*LE
      U=(1.,0.)
      B=PI/FLOAT(LE1)
      W=CMPLX(COS(B),SIN(B))
      DO 20 J=1,LE1
      DO 10 I=J,N,LE
      IP=I+LE1
      T=A(IP)*U
      A(IP)=A(I)-T
10    A(I)=A(I)+T
20    U=U*W
       RETURN
 1000 WRITE(6,100)N
100    FORMAT(5(4H ***),I6,70H IS NOT A POWER OF 2.  FFTWO CANNOT TRANSF
     1ORM A SERIES OF THIS LENGTH    )
      RETURN
      END                                                               FFTTWO
      SUBROUTINE FFTINV(A,N)
      DIMENSION A(N)
      COMPLEX A,AI
      CALL FFTTWO(A,N)
      ANORM=1.0/N
      N1=1 + N/2
      DO 1100 I=2,N1
      NI=N-I+2
      AI=A(I)
      A(I)=A(NI)*ANORM
 1100 A(NI)=AI*ANORM
      A(1)=A(1)*ANORM
      RETURN
      END
 
 1000 WRITE(6,100)N
100    FORMAT(5(4H ***),I6,70H IS NOT A POWER OF 2.  FFTWO CANNOT TRANSF
     1ORM A SERIES OF THIS LENGTH    )
      RETURN
      END                                                               FFTTWO
      SUBROUTINE FFTINV(A,N)
      DIMENSION A(N)
      COMPLEX A,AI
      CALL FFTTWO(A