      PROGRAM CCA2
C
C BENCHMARK CCA2, DOUBLE PRECISION WHETSTONE
C   BENCHMARK  = SYNTH FORD IN NPL REPORT NAC62
C------------------------------------------------------------
C LAWRENCE LIVERMORE LAB. MODIFICATION OF WHETSTONE BENCHMARK
C MODIFIED FOR AUTOMATIC TIMING OF BENCHMARK
C  USER  SHALL MODIFY THIS PROGRAM IN THE AREAS INDICATED
C TO PROVIDE AUTOMATIC TIMING. (SEE BELOW)
C  USER  SHALL RUN THIS BENCHMARK TWICE,
C ONCE WITH LOGICAL UNIT 6 SET TO A NULL DEVICE
C AND ONCE WITH LOGICAL UNIT 6 SET TO A PRINTING DEVICE.
C LOGICAL UNIT 7 SHALL ALWAYS BE SET TO A PRINTING DEVICE.
C--------------------------------------------------------
C WHETSTONE BENCHMARK TEST 1
C
C VERSION 3  OCT. 17, 1977
C
C REFERENCE:
C   THE DESIGN OF SYNTHETIC PROGRAMS I, BRIAN A. WICHMANN
C   BENCHMARKING; COMPUTER EVALUATION AND MEASUREMENT,
C   JOHN WILEY & SON, NEW YORK 1975, PP 89-98
C
C   THE DESIGN OF SYNTHETIC, PROGRAMS II, HARRY J. CURNOW
C   BENCHMARKING; COMPUTER EVALUATION AND MEASUREMENT,
C   JOHN WILEY & SON, NEW YORK 1975, PP 99-114
C
C   A SYNTHETIC BENCHMARK, H. J. CURNOW AND B. A. WICHMANN,
C   A COMPUTER JOURNAL, VOL. 19, NUMBER 1.
C
C   CENTRAL COMPUTER AGENCY PROGRAM FOPR13
C
C THIS PROGRAM HAS A SINGLE PARAMETER LOOP
C SET LOOP=1 FOR 1,000,000 WHETSTONE INSTRUCTIONS
C SET LOOP=10 FOR 10,000,000 WHETSTONE INSTRUCTIONS
C SET LOOP=9 FOR ONE MINUTE ON MACHINE OF POWER OF 360/65
C SET LOOP=1 FOR MACHINE 1/10 POWER OF 360/65
C SET LOOP=91  FOR MACHINE TEN TIMES POWER OF 360/65
C
C MAIN PROGRAM
      DOUBLE PRECISION X1, X2, X3, X4, X,Y,Z,T,T1,T2,E1
      COMMON T,T1,T2,E1(4),J,K,L
C------------------------------------------------------------
C  USER  SHALL MODIFY THIS TO SET "STIME" TO A REFERENCE TIME
C IN SECONDS (ACCURATE TO AT LEAST ONE SECOND).
C-------------------------------------------------------------
	STIME=SECNDS(0.0)
1     T = 0.499975
      T1 = 0.50025
      T2 = 2.0
C
C     SET NTTY FOR TERMINAL OUTPUT DEVICE NUMBER
      NTTY = 6
C
C IF LOOP = 10 THEN THIS COORESPONDS TO THE EXECUTION OF
C 10 TIMES  1,000,000 WHETSTONE INSTRUCTIONS.
C
      LOOP = 10
C
C I=10 COORESPONDS TO 1,000,000 WHETSTONE INSTRUCTIONS PER MAJOR LOOP
      I = 10
C
C ESTABLISH MODULE EXECUTION TIME PARAMETERS
      N1 = 0
      N2 = 12*I
      N3 = 14*I
      N4 = 345*I
      N5 = 0
      N6 = 210*I
      N7 = 32*I
      N8 = 899*I
      N9 = 616*I
      N10 = 0
      N11 = 93*I
      N12 = 0
C
C BEGINNING OF MAJOR LOOP
C WE HAVE THIS MAJOR LOOP RATHER THAN USING A BIGGER I BECAUSE
C A LARGE I (GREATER THAN 36) WILL OVERFLOW ON A 16 BIT MACHINE.
C
      DO 500  JJ = 1,LOOP
C
C BEGINNING OF MODULE 1, SIMPLE IDENTIFIERS
C
        X1 = 1.0
        X2 = -1.0
        X3 = -1.0
        X4 = -1.0
        IF(N1)19,19,11
11      DO 18 I = 1,N1,1
           X1 = (X1+X2+X3-X4)*T
           X2 = (X1+X2-X3+X4)*T
           X3 = (X1-X2+X3+X4)*T
           X4 = (-X1+X2+X3+X4)*T
18      CONTINUE
C
19      CONTINUE
D        IF(JJ.EQ.LOOP) CALL DPOUT (N1,N1,N1,X1,X2,X3,X4)
C
C BEGINNING OF MODULE 2, ARRAY ELEMENTS
C
        E1(1) = 1.0
        E1(2) = -1.0
        E1(3) = -1.0
        E1(4) = -1.0
        IF(N2)29,29,21
21      DO 28 I = 1,N2,1
           E1(1) = (E1(1)+E1(2)+E1(3)-E1(4))*T
           E1(2) = (E1(1)+E1(2)-E1(3)+E1(4))*T
           E1(3) = (E1(1)-E1(2)+E1(3)+E1(4))*T
           E1(4) = (-E1(1)+E1(2)+E1(3)+E1(4))*T
28      CONTINUE
C
29      CONTINUE
D        IF(JJ.EQ.LOOP) CALL DPOUT (N2,N3,N2,E1(1),E1(2),E1(3),E1(4))
C
C BEGINNING OF MODULE 3, ARRAY AS A PARAMETER
C
        IF(N3)39,39,31
31      DO 38 I = 1,N3,1
38      CALL DPA (E1)
C
39      CONTINUE
D        IF(JJ.EQ.LOOP) CALL DPOUT (N3,N2,N2,E1(1),E1(2),E1(3),E1(4))
C
C BEGINNING OF MODULE 4, CONDITIONAL JUMPS
C
        J = 1
        IF(N4)49,49,41
41      DO 48 I = 1,N4,1
           IF(J-1)43,42,43
42         J = 2
           GO TO 44
43         J = 3
44         IF(J-2)46,46,45
45         J = 0
           GO TO 47
46         J = 1
47         IF(J-1)411,412,412
411        J = 1
           GO TO 48
412        J = 0
48      CONTINUE
C
49      CONTINUE
D        IF(JJ.EQ.LOOP) CALL DPOUT (N4,J,J,X1,X2,X3,X4)
C
C THERE IS NO MODULE 5
C
C BEGINNING OF MODULE 6, INTEGER ARITHMETIC
C
        J = 1
        K = 2
        L = 3
        IF(N6)69,69,61
61      DO 68 I = 1,N6,1
           J = J*(K-J)*(L-K)
           K = L*K-(L-J)*K
           L = (L-K)*(K+J)
           E1(L-1) = J+K+L
           E1(K-1) = J*K*L
68      CONTINUE
C
69      CONTINUE
D        IF(JJ.EQ.LOOP) CALL DPOUT (N6,J,K,E1(1),E1(2),E1(3),E1(4))
C
C BEGINNING OF MODULE 7, TRIG. FUNCTIONS
C
        X = 0.5
        Y = 0.5
        IF(N7)79,79,71
71      DO 78 I = 1,N7,1
           X=T*DATAN(T2*DSIN(X)*DCOS(X)/(DCOS(X+Y)+DCOS(X-Y)-1.0))
           Y=T*DATAN(T2*DSIN(Y)*DCOS(Y)/(DCOS(X+Y)+DCOS(X-Y)-1.0))
78      CONTINUE
C
79      CONTINUE
D        IF(JJ.EQ.LOOP) CALL DPOUT (N7,J,K,X,X,Y,Y)
C
C BEGINNING OF MODULE 8, PROCEDURE CALLS
C
        X = 1.0
        Y = 1.0
        Z = 1.0
        IF(N8)89,89,81
81      DO 88 I = 1,N8,1
88      CALL DP3 (X,Y,Z)
C
89      CONTINUE
D        IF(JJ.EQ.LOOP) CALL DPOUT (N8,J,K,X,Y,Z,Z)
C
C BEGINNING OF MODULE 9, ARRAY REFERENCES
C
        J = 1
        K = 2
        L = 3
        E1(1) = 1.0
        E1(2) = 2.0
        E1(3) = 3.0
        IF(N9)99,99,91
91      DO 98 I = 1,N9,1
98      CALL DP0
C
99      CONTINUE
D        IF(JJ.EQ.LOOP) CALL DPOUT (N9,J,K,E1(1),E1(2),E1(3),E1(4))
C
C BEGINNING OF MODULE 10, INTEGER ARITHMETIC
C
        J = 2
        K = 3
        IF(N10)109,109,101
101     DO 108 I = 1,N10,1
           J = J+K
           K = J+K
           J = K-J
           K = K-J-J
108     CONTINUE
C
109     CONTINUE
D        IF(JJ.EQ.LOOP) CALL DPOUT (N10,J,K,X1,X2,X3,X4)
C
C BEGINNING OF MODULE 11, STANDARD FUNCTIONS
C
        X = 0.75
        IF(N11)119,119,111
111     DO 118 I = 1,N11,1
118     X=DSQRT(DEXP(DLOG(X)/T1))
C
119     CONTINUE
D        IF(JJ.EQ.LOOP) CALL DPOUT (N11,J,K,X,X,X,X)
C
C THERE IS NO MODULE 12
C
C THIS IS THE END OF THE MAJOR LOOP
 500  CONTINUE
C------------------------------------------------------------
C  USER  SHALL MODIFY THIS TO SET "TTIME" TO TOTAL AMOUNT OF
C ELAPSED TIME SINCE "STIME" IN SECONDS.
C-------------------------------------------------------------
	TTIME=SECNDS(STIME)
C LLL MODIFICATION TO PRINT TOTAL ELAPSED TIME OF BENCHMARK
      ETIME = TTIME/60.0
      WRITE(NTTY,1000)ETIME
1000  FORMAT(' EXECUTION TIME IS ',F8.4,' MINUTES')
C--------------------------------------------------------------
C COMPUTE SHETSTONE IPS RATE
C
	WHETS = (1/TTIME)*LOOP*1000
	WRITE(NTTY,999) WHETS
999	FORMAT(' RATE IS ',F8.0,' THOUSAND ',
	2 'DOUBLE PRECISION WHETSTONE INSTRUCTIONS PER SECOND')
        STOP
        END
C===========================================================
      SUBROUTINE DPA(E)
      DOUBLE PRECISION T,T1,T2,E
      COMMON T,T1,T2
      DIMENSION E(4)
      J=0
    1 E(1)=(E(1)+E(2)+E(3)-E(4))*T
      E(3)=(E(1)-E(2)+E(3)+E(4))*T
      E(4)=(-E(1)+E(2)+E(3)+E(4))/T2
      J=J+1
      IF (J-6) 1,2,2
    2 CONTINUE
      RETURN
      END
C===========================================================
      SUBROUTINE DP0
      DOUBLE PRECISION T,T1,T2,E1
      COMMON T,T1,T2,E1(4),J,K,L
      E1(J)=E1(K)
      E1(K)=E1(L)
      E1(L)=E1(J)
      RETURN
      END
C===========================================================
      SUBROUTINE DP3(X,Y,Z)
      DOUBLE PRECISION T,T1,T2,X1,Y1,X,Y,Z
      COMMON T,T1,T2
      X1=X
      Y1=Y
      X1=T*(X1+Y1)
      Y1=T*(X1+Y1)
      Z=(X1+Y1)/T2
      RETURN
      END
DC===========================================================
D      SUBROUTINE DPOUT(N,J,K,X1,X2,X3,X4)
D      DOUBLE PRECISION X1,X2,X3,X4
D      WRITE(6,1) N,J,K,X1,X2,X3,X4
D    1 FORMAT(1H ,3I7,4E12.4)
D      RETURN
D      END
                                                                                                                                              