      PROGRAM CCA11
C
C BENCHMARK CCA11, FOPR04, DOUBLE FUN
C CENTRAL COMPUTER AGENCY PROGRAM FOPR04
C BENCHMARK NO 11 = DOUBLE FUN IN NPL REPORT NAC62
C--------------------------------------------------------
C LAWRENCE LIVERMORE LAB. MODIFICATION OF NPL BENCHMARK
C MODIFIED FOR AUTOMATIC TIMING OF BENCHMARK
C  USER  SHALL MODIFY THIS PROGRAM IN THE AREAS INDICATED
C TO PROVIDE AUTOMATIC TIMING. (SEE BELOW)
C  USER  SHALL RUN THIS BENCHMARK TWICE,
C ONCE WITH LOGICAL UNIT 6 SET TO A NULL DEVICE
C AND ONCE WITH LOGICAL UNIT 6 SET TO A PRINTING DEVICE.
C LOGICAL UNIT 7 SHALL ALWAYS BE SET TO A PRINTING DEVICE.
C
C - THIS PROGRAM HAS BEEN MODIFIED TO RUN ON 16 BIT MACHINES
C   BY REDUCING DO LOOP UPPER LIMITS FROM 50001 TO 24276
C   AND BY REDUCING THE THE DO LOOP INCREMENT BY 1/2 (=24275/IA).
C--------------------------------------------------------
C THIS PROGRAM HAS A SINGLE PARAMETER IA
C SET IA=1400 FOR ONE MINUTE ON MACHINE OF THE POWER OF 360/65
C SET IA=140 FOR MACHINE 1/10 POWER OF 360/65
C SET IA=14000 FOR ONE MINUTE ON MACHINE TEN TIMES POWER OF 360/65
      DOUBLE PRECISION RM,PII,A,R,B,D(10),E(10)
      COMPLEX CA
      COMMON RM
C------------------------------------------------------------
C  USER  SHALL MODIFY THIS TO SET "STIME" TO A REFERENCE TIME
C IN SECONDS (ACCURATE TO AT LEAST ONE SECOND).
C-------------------------------------------------------------
      STIME=SECNDS(0.0)
      PI=3.14159265
      PII=DBLE(PI/100000.0)
      IA = 140
      IC=2
      IB = 24275 / IA
      WRITE(6,1)
      RM=1.0
      DO 100 I=1,24276,IB
      A=FLOAT(I-1)*PII
      DO 100 J=1,IC
      R=DSIN(A)**2+DCOS(A)**2
  100 RM=RM*R
      WRITE(6,11)
      CALL SUMCK
      RM=1.0
      DO 200 I=1,24276,IB
      A=FLOAT(I)/300.0
      DO 200 J=1,IC
      SA=SNGL(A)
      R=(DEXP(A)-DEXP(-A))/(DEXP(A)+DEXP(-A))/TANH(SA)
  200 RM=RM*R
      WRITE(6,12)
      CALL SUMCK
      RM=1.0
      DO 300 I=1,24276,IB
      A=FLOAT(I)/300.0
      DO 300 J=1,IC
      B=DEXP(A)
      R=DLOG(B)/A
  300 RM=RM*R
      WRITE(6,13)
      CALL SUMCK
      RM=1.0
      DO 400 I=1,24276,IB
      DO 400 J=1,IC
      A=FLOAT(I)*FLOAT(J)
      B=2.0*DLOG10(A)
      B=10.0**B
      R=DSQRT(B)/A
  400 RM=RM*R
      WRITE(6,14)
      CALL SUMCK
      RM=1.0
      DO 500 I=1,24276,IB
      C=(FLOAT(I)-0.8)*SNGL(PII)
      DO 500 J=1,IC
      CA=CEXP(CMPLX(C,C))
      CA=CSQRT(CA*CONJG(CA)*CMPLX(COS(C)**2-SIN(C)**2,
     12.0*SIN(C)*COS(C)))
      CA=CLOG(CA)
      R=(DABS(DBLE(REAL(CA)))+ABS(AIMAG(CA)))/(2.0*C)
  500 RM=RM*R
      WRITE(6,15)
      CALL SUMCK
      RM=1.0
      DO 600 I=1,24276,IB
      CA=CMPLX(FLOAT(I),FLOAT(24276-I))
      DO 600 J=1,IC
      R=CABS(CA)/SQRT(REAL(CA)**2+AIMAG(CA)**2)
  600 RM=RM*R
      WRITE(6,16)
      CALL SUMCK
      RM=1.0
      DO 700 I=1,24276,IB
      DO 688 M=1,10
      D(M)=AMIN0(I,M)*AMAX0(I,M)
  688 E(M)=1.0/FLOAT(MIN0(I,M)*MAX0(I,M))
      DO 700 J=1,IC
      DO 699 N=1,10
      A=DMIN1(D(1),D(2),D(3),D(4),D(5),D(6),D(7),D(8),
     1D(9),D(10))
      D(N)=1000000.0
      R=A*DMAX1(E(1),E(2),E(3),E(4),E(5),E(6),E(7),E(8),
     1E(9),E(10))
      RM=RM*R
  699 E(N)=0.000001
  700 CONTINUE
      WRITE(6,17)
      CALL SUMCK
      RM=1.0
      PII=3.142/1000000.0
      DO 800 I=1,24276,IB
      C=FLOAT(I)*SNGL(PII*2.0)
      DO 800 J=1,IC
      R=DBLE(ATAN(SIN(C)/COS(C))/C)
     1*DATAN2(DSIN(DBLE(C)),DCOS(DBLE(C)))/C
      R=-R*DSIGN(R,DBLE(-1.0))*FLOAT(MOD(I+5000,I+4999))
     1*AINT(SNGL(R)/2.0+FLOAT(I))/FLOAT(I)
  800 RM=RM*R
      WRITE(6,18)
      CALL SUMCK
C------------------------------------------------------------
C  USER  SHALL MODIFY THIS TO SET "TTIME" TO TOTAL AMOUNT OF
C ELAPSED TIME SINCE "STIME" IN SECONDS.
C-------------------------------------------------------------
	TTIME=SECNDS(STIME)
C LLL MODIFICATION TO PRINT TOTAL ELAPSED TIME OF BENCHMARK
      TTIME = TTIME/60.0
      WRITE(6,1000)TTIME
C--------------------------------------------------------------
      STOP
    1 FORMAT(10H1FUNCTIONS,18X,6HANSWER,15X,8HSUMCHECK)
   11 FORMAT(8H SIN COS)
   12 FORMAT(9H EXP TANH)
   13 FORMAT(8H LOG EXP)
   14 FORMAT(11H LOG10 SQRT)
   15 FORMAT(11H CEXP CMPLX,5H CLOG/12H CONJG CSQRT)
   16 FORMAT(5H CABS,5H REAL,6H AIMAG)
   17 FORMAT(12H DMIN1 DMAX1)
   18 FORMAT(18H ATAN DATAN2 DSIGN/9H MOD AINT)
1000  FORMAT(' BENCHMARK 11 EXECUTION TIME IS ',F8.4,' MINUTES')
      END
      SUBROUTINE SUMCK
      DOUBLE PRECISION RM,V,VW
      COMMON RM
      V=RM
      VW=0.0
      IV=0
      DO 111 I=1,100
      V=(V-VW)*10.0
      VV=SNGL(V)
      IW=IFIX(VV)
      IV=IV+IW*I
  111 VW=FLOAT(IW)
      WRITE(6,9)RM,IV
    9 FORMAT(1H+,15X,D28.20,I10)
      RETURN
      END
                                                                                                                                                                                                                                                                                               