C -- SM8008.FOR
C
C -- SIMULATOR FOR MPS WRITTEN IN PDP-11 FORTRAN.
C
	LOGICAL*1 MSX,MSK1,MSKL,MSKH,MSK5
	LOGICAL*1 ARG(5),NUM(3),SNUM(2),ARGO(6),ARGX(17)
	INTEGER TEM,TEM1,TEM2,TEM3,TEM4
	INTEGER IREG(7),AC,CARRY,FLAG,STACK(8),SP
	LOGICAL*1 KA,KB,KC,KD,KE,KG,KH,KI,KL
	LOGICAL*1 KM,KN,KO,KP,KR,KS,KBL,K0,K7
	LOGICAL*1 MEMORY(8192)
	LOGICAL*1 FIL(14)
	INTEGER IOF(3)
	EQUIVALENCE (AC,IREG(1))
C
	DATA IOF/0,0,0/
	DATA SP/1/
	DATA MSX/7/
	DATA MSK/255/
	DATA MSK1/1/
	DATA MSKL/63/
	DATA MSKH/511/
	DATA MSKLOC/8191/
	DATA MSK5/31/
	DATA KA/"101/
	DATA KE/"105/
	DATA KG/"107/
	DATA KB/"102/
	DATA KP/"120/
	DATA KD/"104/
	DATA KI/"111/
	DATA KS/"123/
	DATA KC/"103/
	DATA KO/"117/
	DATA KL/"114/
	DATA KM/"115/
	DATA KH/"110/
	DATA KN/"116/
	DATA KR/"122/
	DATA K0/"60/
	DATA K7/"67/
	DATA KBL/"40/
C
C -- START SIMULATOR
C
	WRITE(5,7000)
7000	FORMAT(' SM8008.FOR VERS 8K'/)
C
C -- CONTROL INPUT LOOP.
C
1	WRITE(5,7001)
7001	FORMAT('$*')
	READ(5,6002)ARGX
6002	FORMAT(17A1)
	IC=ARGX(1)
	IF(IC.EQ.KA)GOTO 76
	CALL CNVT(ARGX(2),5,IARG,IER)
	IF(IER.NE.0)GOTO 5
	IF(IC.EQ.KM)GOTO 90
	IF(IC.EQ.KG)GOTO 15
	IF(IC.EQ.KH)GOTO 20
	IF(IC.EQ.KC)GOTO 105
	IF(IC.EQ.KO)GOTO 30
	IF(IC.EQ.KR)GOTO 40
	IF(IC.EQ.KS)GOTO 50
	IF(IC.EQ.KB)GOTO 10
	IF(IC.EQ.KP)GOTO 25
	IF(IC.EQ.KD)GOTO 60
	IF(IC.EQ.KL)GOTO 61
	IF(IC.EQ.KI)GOTO 80
	IF(IC.EQ.KE)GOTO 6
5	WRITE(5,6000)
6000	FORMAT(' ?')
	GOTO 1
6	STOP
C
C -- START PROGRAM
C
10	SP=1
	FLAG=0
	CARRY=0
	DO 11 I=1,7
	IREG(I)=0
11	CONTINUE
15	STACK(SP)=IARG.AND.MSKLOC
	GOTO 105
C
C -- SET STOP ADDRESS
C
20	ISTOP=(IARG.AND.MSKLOC)+1
	GOTO 1
25	ISTOP=0
	GOTO 1
C
C -- OPEN MEMORY LOCATION.
C
30	IARG=IARG.AND.MSKLOC
	LOC=IARG+1
	CALL DCNVT(ARG,5,IARG)
	IVAL=MEMORY(LOC).AND.MSK
	CALL DCNVT(NUM,3,IVAL)
	WRITE(5,7002)ARG,NUM
7002	FORMAT('$',5O1,': ',3O1,': ')
	READ(5,6003)ARGO
6003	FORMAT(6A1)
	IC=ARGO(1)
	IF(IC.EQ.KBL)GOTO 1
	IF((IC.GE.K0).AND.(IC.LE.K7))GOTO 31
	IF(IC.EQ.KH)GOTO 32
	IF(IC.EQ.KL)GOTO 33
	IF(IC.EQ.KO)GOTO 34
	GOTO 5
31	CALL CNVT(ARGO,3,IVAL,IER)
	IF(IER.NE.0)GOTO 5
	MEMORY(LOC)=IVAL
32	IARG=IARG+1
	GOTO 30
33	IARG=IARG-1
	GOTO 30
34	CALL CNVT(ARGO(2),5,IARG,IER)
	IF(IER.NE.0)GOTO 5
	GOTO 30
C
C -- OUTPUT REGISTERS AND FLAGS.
C
40	DO 41 I=1,7
	J=I-1
	CALL DCNVT(NUM,3,IREG(I))
	WRITE(5,7003)J,NUM
7003	FORMAT(' R',O1,': ',3O1)
41	CONTINUE
	CALL DCNVT(NUM,3,FLAG)
	WRITE(5,7004)NUM,CARRY
7004	FORMAT(' FG: ',3O1/' CA: ',O1)
	GOTO 1
C
C -- OUTPUT STACK AND SP
C
50	DO 51 I=1,8
	J=I-1
	CALL DCNVT(ARG,5,STACK(I))
	WRITE(5,7005)J,ARG
7005	FORMAT(' S',O1,': ',5O1)
51	CONTINUE
	J=SP-1
	IF(J.LE.0)J=0
	WRITE(5,7006)J
7006	FORMAT(' SP: ',O1)
	GOTO 1
C
C -- DUMP BINARY.
C
60	IRT=1
	GOTO 65
C
C -- LIST PROGRAM.
C
61	IRT=0
C
C -- ASK FOR STARTING AND ENDING ADDRESS.
C
65	WRITE(5,7007)
7007	FORMAT('$S: ')
	READ(5,6003)ARG
	CALL CNVT(ARG,5,IS,IER)
	IF(IER.NE.0)GOTO 5
	WRITE(5,7008)
7008	FORMAT('$E: ')
	READ(5,6003)ARG
	CALL CNVT(ARG,5,IE,IER)
	IF(IER.NE.0)GOTO 5
C
C -- FETCH AND OUTPUT DATA.
C
	IS=IS.AND.MSKLOC
	IE=IE.AND.MSKLOC
70	IVAL=MEMORY(IS+1).AND.MSK
	IF(IRT.NE.1)GOTO 75
	WRITE(2)IS,IVAL
	IOF(2)=1
71	IF(IS.EQ.IE)GOTO 1
	IS=(IS+1).AND.MSKLOC
	GOTO 70
75	CALL DCNVT(ARG,5,IS)
	CALL DCNVT(NUM,3,IVAL)
	WRITE(1,7009)ARG,NUM
	IOF(1)=1
7009	FORMAT(1X,5O1,': ',3O1)
	GOTO 71
C
C -- ASSIGN I/O FILES TO FORTRAN UNIT NUMBERS.
C
76	IC=ARGX(2)
	IFU=0
	IF(IC.EQ.KL)IFU=1
	IF(IC.EQ.KO)IFU=2
	IF(IC.EQ.KI)IFU=3
	IF(IFU.EQ.0)GOTO 5
	IF(IOF(IFU).EQ.0)GOTO 78
	CALL CLOSE(IFU)
78	CALL ASSIGN(IFU,'DK:SAMPLE.BIN',-13)
	GOTO 1
C
C -- INPUT BINARY PROGRAM.
C
80	READ(3,END=85)IS,IVAL
	MEMORY(IS+1)=IVAL
	GOTO 80
85	CALL CLOSE(3)
	GOTO 1
C
C -- MODIFY REGISTERS.
C
90	IF(IARG.GT.6)IARG=0
	IF(IARG.LT.0)IARG=6
	I=IARG+1
	CALL DCNVT(NUM,3,IREG(I))
	WRITE(5,7020)IARG,NUM
7020	FORMAT('$R',O1,': ',3O1,': ')
	READ(5,6003)ARGO
	IC=ARGO(1)
	IF(IC.EQ.KBL)GOTO 1
	IF((IC.LT.K0).OR.(IC.GT.K7))GOTO 5
	CALL CNVT(ARGO,3,IVAL,IER)
	IF(IER.NE.0)GOTO 5
	IREG(I)=IVAL
	IARG=IARG+1
	GOTO 90
C
C -- SECTION 0100
C -- INSTRUCTION FETCH
C
100	CALL ISW(NUMMY)
	IF((NUMMY.AND.MSK1).NE.0)GOTO 200
105	LOC=STACK(SP)+1
	IF(LOC.EQ.ISTOP)GOTO 210
	INST=MEMORY(LOC).AND.MSK
	STACK(SP)=LOC.AND.MSKLOC
	IF1=INST.AND.MSX
	IF2=(INST/8).AND.MSX
	IF3=INST/64
	IFP1=IF1+1
	IFP2=IF2+1
	IFP3=IF3+1
	GOTO(1000,2000,3000,4000)IFP3
C
C -- HALT SWITCH
C
200	WRITE(5,9000)
9000	FORMAT(' HALT SWITCH')
	GOTO 250
C
C -- HALT ADDRESS
C
210	WRITE(5,9001)
9001	FORMAT(' HALT ADDRESS')
	GOTO 250
C
C -- HALT INSTRUCTION.
C
220	CALL DCNVT(NUM,3,INST)
	WRITE(5,9002)NUM
9002	FORMAT(' HALT INST: ',3O1)
	GOTO 250
C
C -- ILLEGAL INSTRUCTION
C
230	CALL DCNVT(NUM,3,INST)
	WRITE(5,9003)NUM
9003	FORMAT(' ILLEGAL INST: ',3O1)
	GOTO 250
C
C -- PRINT LOCATION OF HALT.
C
250	CALL DCNVT(ARG,5,STACK(SP))
	WRITE(5,9004)ARG
9004	FORMAT(' PC: ',5O1)
	GOTO 1
C
C -- STACK OVERFLOW.
C
260	CALL DCNVT(ARG,5,STACK(8))
	WRITE(5,9005)ARG
9005	FORMAT(' STACK OVER AT: ',5O1)
	SP=1
	GOTO 1
C
C -- STACK UNDERFLOW.
C
270	CALL DCNVT(ARG,5,STACK(1))
	WRITE(5,9006)ARG
9006	FORMAT(' STACK UNDER AT: ',5O1)
	SP=8
	GOTO 1
C
C -- OUTPUT INSTRUCTION (01 RRM MM1), RR.NE.00.
C
300	CALL DCNVT(SNUM,2,TEM)
	CALL DCNVT(NUM,3,AC)
	WRITE(5,9007)SNUM,NUM
9007	FORMAT(' OUTPUT: ',2O1,': ',3O1)
	GOTO 100
C
C -- INPUT INSTRUCTION (01 00M MM1).
C
350	WRITE(5,9008)TEM
9008	FORMAT('$INPUT: ',O1,': ')
	READ(5,8008)ARG
8008	FORMAT(5A1)
	CALL CNVT(ARG,3,AC,IER)
	AC=AC.AND.MSK
	GOTO 100
C
C -- SECTION 1000 (00 XXX XXX)
C -- SPECIAL AND IMMEDIATE INSTRUCTIONS.
C
1000	GOTO(1100,1200,1300,1400,1500,1600,1700,1800)IFP1
C
C -- INCREMENT INDEX REGISTERS (00 DDD 000)
C
1100	I=1
1110	IF(IF2.EQ.0)GOTO 220
	IF(IF2.EQ.0)GOTO 230
	FLAG=(IREG(IFP2)+I).AND.MSK
	IREG(IFP2)=FLAG
	GOTO 100
C
C -- DECREMENT INDEX REGISTERS (00 DDD 001)
C
1200	I=-1
	GOTO 1110
C
C -- ALU ROTATE INSTRUCTIONS (00 III 010)
1300	GOTO(1310,1320,1330,1340,230,230,230,230)IFP2
C
C -- RLC (00 000 010)
C
1310	CARRY=0
	IF(AC.GE.128)CARRY=1
	AC=((AC*2).AND.MSK)+CARRY
	GOTO 100
C
C -- RRC (00 001 010)
C
1320	CARRY=AC.AND.MSK1
	AC=AC/2
	IF(CARRY.NE.0)AC=AC+128
	GOTO 100
C
C -- RAL (00 010 010)
C
1330	AC=AC*2+CARRY
	CARRY=0
	IF(AC.GE.256)CARRY=1
	AC=AC.AND.MSK
	GOTO 100
C
C -- RAR (00 011 010)
C
1340	TEM=AC.AND.MSK1
	AC=AC/2
	IF(CARRY.NE.0)AC=AC+128
	CARRY=TEM
	GOTO 100
C
C -- CONDITIONAL RETURN (00 CCC 011)
C
1400	IRT=1
C
C -- CONDITIONAL OPERATOR PROCESSOR (RETURN,CALL,JUMP)
C
1405	GOTO(1450,1460,1470,1480,1410,1420,1430,1440)IFP2
1410	IF(CARRY.NE.0)GOTO 1490
	GOTO 1495
1420	IF(FLAG.EQ.0)GOTO 1490
	GOTO 1495
1430	IF(FLAG.GE.128)GOTO 1490
	GOTO 1495
C -- EVEN PARITY
1440	TEM4=1
1441	TEM1=FLAG
	DO 1445 I=1,8
	IF((TEM1.AND.MSK1).NE.0)TEM4=-TEM4
	TEM1=TEM1/2
1445	CONTINUE
	IF(TEM4.GT.0)GOTO 1490
	GOTO 1495
1450	IF(CARRY.EQ.0)GOTO 1490
	GOTO 1495
1460	IF(FLAG.NE.0)GOTO 1490
	GOTO 1495
1470	IF(FLAG.LT.128)GOTO 1490
	GOTO 1495
C -- ODD PARITY
1480	TEM4=-1
	GOTO 1441
C
C -- RETURN TO PROPER SEQUENCE FROM CONDITION TEST.
C
1490	GOTO(1800,2400,2500)IRT
C
C -- IF CONDITION FAILS, PC MAY NEED INDEXING.
C
1495	IF(IRT.EQ.1)GOTO 100
	STACK(SP)=(STACK(SP)+2).AND.MSKLOC
	GOTO 100
C
C -- ALU IMMEDIATE INSTRUCTIONS (00 III 100)
C
1500	LOC=STACK(SP)+1
	STACK(SP)=LOC.AND.MSKLOC
C
C -- MEMORY OPERAND FETCH
C
1504	TEM=MEMORY(LOC).AND.MSK
C
C -- ALU INSTRUCTION DECODE.
C
1505	GOTO (1510,1520,1530,1540,1550,1560,1570,1580)IFP2
C
1510	FLAG=AC+TEM
	GOTO 1590
1520	FLAG=AC+TEM+CARRY
	GOTO 1590
1530	FLAG=AC-TEM
	GOTO 1590
1540	FLAG=AC-TEM-CARRY
	GOTO 1590
1550	FLAG=AC.AND.TEM
	GOTO 1590
1560	FLAG=(AC.AND..NOT.TEM).OR.(TEM.AND..NOT.AC)
	GOTO 1590
1570	FLAG=AC.OR.TEM
	GOTO 1590
C
C -- COMPARE OPERATION FOR ALU
C
1580	FLAG=(AC-TEM).AND.MSKH
	CARRY=0
	IF(FLAG.GE.256)CARRY=1
	FLAG=FLAG.AND.MSK
	GOTO 100
C
C -- FINISH UP ALU OPERATION
C
1590	FLAG=FLAG.AND.MSKH
	CARRY=0
	IF(FLAG.GE.256)CARRY=1
	FLAG=FLAG.AND.MSK
	AC=FLAG
	GOTO 100
C
C -- RST (00 AAA 101)
C
1600	SP=SP+1
	IF(SP.GT.8)GOTO 260
	STACK(SP)=IF2*8
	GOTO 100
C
C -- LOAD IMMEDIATE (00 DDD 110)
C
1700	LOC=STACK(SP)+1
	STACK(SP)=LOC.AND.MSKLOC
	TEM=MEMORY(LOC).AND.MSK
	IF(IF2.EQ.7)GOTO 1710
	IREG(IFP2)=TEM
	GOTO 100
C
C -- LMI (00 111 110)
C
1710	LOC=(IREG(6).AND.MSKL)*256 + (IREG(7).AND.MSK) + 1
	MEMORY(LOC)=TEM
	GOTO 100
C
C -- RET (00 XXX 111)
C
1800	SP=SP-1
	IF(SP.GE.1)GOTO 100
	GOTO 270
C
C -- SECTION 2000 (01 XXX XXX)
C -- PC AND STACK CONTROL (01 III II0)
C -- INPUT/OUTPUT (01 III II1)
C
2000	GOTO(2100,2200,2300,2200,2400,2200,2500,2200)IFP1
C
C -- CONDITIONAL JUMP (01 CCC 000)
C
2100	IRT=2
	GOTO 1405
C
C -- INPUT/OUTPUT (01 RRM MM1)
C
2200	TEM=(INST/2).AND.MSK5
	IF(TEM.GE.8)GOTO 300
	GOTO 350
C
C -- CONDITIONAL CALL (01 CCC 010)
C
2300	IRT=3
	GOTO 1405
C
C -- JMP (01 XXX 100)
C
2400	LOC=STACK(SP)+1
2405	STACK(SP)=(MEMORY(LOC+1).AND.MSKL)*256+(MEMORY(LOC).AND.MSK)
	GOTO 100
C
C -- CAL (01 XXX 110)
C
2500	LOC=STACK(SP)+1
	STACK(SP)=(LOC+1).AND.MSKLOC
	SP=SP+1
	IF(SP.LE.8)GOTO 2405
	GOTO 260
C
C -- SECTION 3000 (10 III SSS)
C -- ALU INDEX REGISTER OPERATIONS
C
3000	IF(IF1.EQ.7)GOTO 3010
	TEM=IREG(IFP1)
	GOTO 1505
C
C -- ALU MEMORY OPERATION (10 III 111)
C
3010	LOC=(IREG(6).AND.MSKL)*256+(IREG(7).AND.MSK)+1
	GOTO 1504
C
C -- SECTION 4000 (11 DDD SSS)
C -- LOAD INDEX REGISTERS
C
4000	IF(INST.EQ.255)GOTO 220
	IF(IF1.EQ.7)GOTO 4100
	IF(IF2.EQ.7)GOTO 4200
	IREG(IFP2)=IREG(IFP1)
	GOTO 100
C
C -- MEMORY IS SOURCE
C
4100	LOC=(IREG(6).AND.MSKL)*256+(IREG(7).AND.MSK)+1
	IREG(IFP2)=MEMORY(LOC).AND.MSK
	GOTO 100
C
C -- MEMORY IS DESTINATION
C
4200	LOC=(IREG(6).AND.MSKL)*256+(IREG(7).AND.MSK)+1
	MEMORY(LOC)=IREG(IFP1)
	GOTO 100
C
C ****** END OF PROGRAM ******
C
	END
                                                                                                                                                                                                                                        