100 REM
110 REM:  PROGRAM  RENUMB
120 REM
130 REM:  PROGRAM TO RE-SEQUENCE LINES OF ANY BASIC PROGRAM
140 REM:  WRITTEN IN RT-11 SINGLE USER BASIC.
150 REM:  THE LINE NUMBERS SHOULD BE IN ASCENDING ORDER,  BUT
160 REM:  NOT NECESSARILY EQUALLY SPACED.
170 REM
180 REM:  OLD AND NEW NAMES CAN BE THE SAME.  THE EXTENSION
190 REM:  .BAS IS ASSUMED IF NONE IS GIVEN.
200 REM:  A COPY OF THE ORIGINAL PROGRAM IS PUT IN THE FILE
210 REM:  RENUMB.COP ON THE DEFAULT DEVICE.
220 REM
230 REM:  ERRORS DETECTED:
240 REM:	1.  REFERENCES TO UNDEFINED LINE NUMBERS
250 REM:	   (REPLACED BY *???* IN THE RE-NUMBERED PROGRAM),
260 REM:	2.  LINE NUMBER WITH NO STATEMENT,
270 REM:	3.  LINE LONGER THAN 72 CHARACTERS
280 REM:	    (WILL BE TRUNCATED TO 72 IN RE-NUMBERED PROGRAM),
290 REM:	4.  LINE NUMBER IN RE-NUMBERED PROGRAM TOO BIG (>65532),
300 REM:	5.  PROGRAM TOO LONG.  CHANGE DIMENSION SIZE OF ARRAY
310 REM:		    L9 & VALUE OF VARIABLE L7 (SEE BELOW),
320 REM:	6.  LINE NUMBERS NOT IN ASCENDING ORDER.
330 REM
340 REM:  THE CHARACTERS REM ANYWHERE IN A LINE WILL CAUSE SUBSEQUENT
350 REM:	CHARACTERS UP TO THE NEXT <CR> TO BE COPIED EXACTLY,
360 REM:	UNLESS REM IS IMMEDIATELY PRECEDED BY ' OR ".
370 REM
380 REM:  A LONG PROGRAM MAY TAKE SEVERAL MINUTES TO RE-NUMBER.
390 REM
400 REM:  AUTHOR:  NICK HAMMOND, NEUROPSYCHOLOGY RESEARCH UNIT,
410 REM:	   FRIERN HOSPITAL, LONDON N11 3BP, ENGLAND.
420 REM
430 REM
440 DIM L9(2000)\REM:  ARRAY TO HOLD LINE NOS IN OLD PROG
450 L7=2000\REM:	DIMENSION CAN BE CHANGED (ALSO CHANGE L7)
460 E0=0\E1=0\REM:  ERROR COUNTER AND FLAG
470 REM
480 REM:  GET FILE DETAILS
490 PRINT 'PROGRAM NAME IS: ';\GOSUB 1410 
500 OPEN A$ AS FILE #1
510 PRINT 'NEW NAME IS: ';\GOSUB 1410 
520 OPEN A$ FOR OUTPUT AS FILE #2
530 OPEN 'RENUMB.COP' FOR OUTPUT AS FILE #3
540 REM
550 REM:  GET LINE NUMBER & STEP SIZE AND CHECK LEGALITY
560 PRINT 'ENTER INITIAL LINE NUMBER AND STEP SIZE ';
570 INPUT L1,I0\L0=0\PRINT 
580 IF (L1+1)*I0<=0GO TO 610 \REM:  ARE LINE NO & STEP LEGAL ?
590 IF L1<>INT(L1)GO TO 610 
600 IF I0=INT(I0)GO TO 640 
610 PRINT CHR$(7),'ILLEGAL ENTRY'\GO TO 560 
620 REM
630 REM:  FIRST PASS - STORE PROG IN RENUMB.COP & LINE NOS IN ARRAY L9
640 IF END #1GO TO 830 
650 INPUT #1:L$\PRINT #3:L$\REM: COPY INTO RENUMB.COP IN CASE INPUT
660 REM:  AND OUTPUT FILES ARE THE SAME AND A FILE ERROR OCCURS AT
670 REM:  THE END OF INPUT;  THIS OCCURS IF THE LAST LINE ISN'T
680 REM:  TERMINATED WITH A CR 
690 REM
700 IF E1=1GO TO 640 \REM:  COPY ONLY, IF ERROR DETECTED
710 REM:  GET THE FIRST NON-NUMERIC CHARACTER
720 GOSUB 1470 
730 IF P<LEN(L$)GO TO 750 
740 PRINT \PRINT 'WARNING - LINE NUMBER 'L$' HAS NO STATEMENT'\PRINT 
750 L9(L0)=VAL(SEG$(L$,1,P-1))
760 IF L0=0GO TO 800 
770 IF L9(L0)>L9(L0-1)GO TO 800 \REM:  IN ASCENDING ORDER ?
780 PRINT 'LINE NUMBERS NOT IN ASCENDING ORDER'
790 E1=1\REM:  SET ERROR FLAG
800 L0=L0+1\IF L0<L7+1GO TO 820 
810 PRINT 'PROGRAM IS TOO LONG'\E1=1
820 GO TO 640 
830 CLOSE #3\REM: COPY NOW IN RENUMB.COP
840 REM
850 REM:  IF ERROR IN FIRST PASS DON'T DO SECOND
860 IF E1=0GO TO 890 
870 PRINT 'ORIGINAL PROGRAM IS IN FILE RENUMB.COP'
880 GO TO 1380 
890 RESTORE #1\L3=L1\L8=0
900 REM
910 REM:  SECOND PASS - ASSIGN NEW LINE NOS & STORE IN NEW FILE
920 IF END #1GO TO 1290 
930 INPUT #1:L$\L2=LEN(L$)
940 FOR I=1 TO L2
950 IF SEG$(L$,I,I+2)<>'REM'GO TO 970 
960 B$=SEG$(L$,I-1,I-1)\IF B$='"'GO TO 970 \IF B$<>"'"GO TO 1010 
970 B$=SEG$(L$,I,I+1)
980 IF B$='GO'GO TO 1070 
990 IF B$='TH'GO TO 1070 
1000 NEXT I
1010 GOSUB 1470 \L$=STR$(L3)&SEG$(L$,P,100)
1020 L3=L3+I0
1030 IF LEN(L$)<=72GO TO 1060 \L$=SEG$(L$,1,72)
1040 PRINT 'LINE';L3-I0;'HAS BEEN TRUNCATED TO 72 CHARACTERS'
1050 PRINT \E0=E0+1\REM:  INCREMENT ERROR COUNT
1060 PRINT #2:L$\GO TO 920 
1070 P=POS(L$,' ',I+3)\IF P*(P-LEN(L$))>=0GO TO 1000 
1080 P1=POS(L$,' ',P+1)
1090 P2=POS(L$,'\',P+1)\IF P2=0GO TO 1120 
1100 IF P1=0GO TO 1110 \IF P2>P1GO TO 1120 
1110 P1=P2
1120 IF P1>0GO TO 1130 \P1=LEN(L$)+1
1130 IF P1<P+2 GO TO 1000
1140 FOR J=P+1 TO P1-1
1150 IF ASC(SEG$(L$,J,J))<48GO TO 1000 
1160 IF ASC(SEG$(L$,J,J))>57GO TO 1000 
1170 NEXT J
1180 V=VAL(SEG$(L$,P+1,P1-1))
1190 FOR J=0 TO L0-1
1200 IF L9(J)=VGO TO 1240 \NEXT J
1210 PRINT 'REFERENCE TO UNDEFINED LINE NUMBER: ';V
1220 PRINT L$\PRINT 
1230 E0=E0+1\A$='*???* '\GO TO 1250 
1240 A$=STR$(I0*J+L1)
1250 L$=SEG$(L$,1,P)&A$&SEG$(L$,P1,100)
1260 L8=L8+1\GO TO 1000 
1270 REM
1280 REM:  END OF SECOND PASS;  PRINT RE-NUMBERING DETAILS & STOP
1290 IF L3-I0<=65532GO TO 1320 
1300 PRINT 'WARNING - LAST LINE NUMBER GREATER THAN 65532'\PRINT 
1310 E0=E0+1
1320 PRINT \PRINT L0;'LINES RE-NUMBERED,';L8;'LINE REFERENCES CHANGED'
1330 IF E0=0GO TO 1370 
1340 PRINT TAB(12);E0;'ERROR';
1350 IF E0=1GO TO 1360 \PRINT 'S';
1360 PRINT ' DETECTED'\GO TO 1380 
1370 PRINT TAB(7);'RENUMBERING COMPLETED SUCCESSFULLY'
1380 PRINT \CLOSE \STOP
1390 REM
1400 REM:  SUBROUTINE TO APPEND FILE EXTENSION IF NECESSARY
1410 INPUT A$
1420 IF POS(A$,'.',1)>0GO TO 1430 \A$=A$&'.BAS'
1430 RETURN
1440 REM
1450 REM:  SUBROUTINE TO FIND THE POSITION OF THE FIRST NON-NUMERIC
1460 REM:  CHARACTER IN L$
1470 FOR P=1 TO LEN(L$)\J=ASC(SEG$(L$,P,P))
1480 IF J<48GO TO 1500 \IF J>57GO TO 1500 
1490 NEXT P\P=P+1
1500 RETURN
1510 END
*U*1                                                                                                                                                                                                                                                                                                      