/*+
 * VOID tfrpos(form)
 *     TEXT  *form;
 *
 * Description  : Routine to initialize settings for a specified form
 *
 * Arguments    : form  = STRING containing the name of the form
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 1-nov-1982
 *
 * Module name  : TFRPOS.FOR
 *
 * Package      : TFR
 *
 * Updates      : name                 version
 *
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : tfrpos.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <tfr.cmn>

VOID tfrpos(form)
    TEXT  *form;

    {
    IMPORT TFRCOM t;

/*
 *   form name-record
 *       FRNAM			! form name
 *       NRNXFR			! rec.nr. next form
 *       NRFFFR			! rec.nr. first fix field rec.
 *       NRLFFR			! rec.nr. last  fix field rec.
 *       NRFDFR			! rec.nr. first display-only fld.rec.
 *       NRLDFR			! rec.nr. last  display-only fld.rec.
 *       NRFUFR			! rec.nr. first update field rec.
 *       NRLUFR			! rec.nr. last  update field rec.
 */
#include <upddef.h>

    FAST i, j;

    TEXT  frnam[8], buf[40];
    COUNT next, irec;
    COUNT *pf;

    pf = &t.frec;
/*
 *    search file for specified form
 */
    next = t.nrnxfr;
    scvtlu(form);
    FOREVER
        {
        rcread(t.nunit, t.nrnxfr, t.maxbuf, buf);
        cpybuf(frnam, buf, 8);
        cpybuf(&t.nrnxfr, buf+8, 2);
        cpybuf(&t.nrfffr, buf+10, 12);   /* store nrfffr, nrlffr, nrfdfr,
                                                  nrldfr, nrfufr, nrlufr */
        
        if(cmpstr(form, frnam))
            {
            break;
            }
        if(next == t.nrnxfr)
            {
            error("TFRPOS", "-Form not found");
            }
        }
/*
 *    fill field copy record with default values
 */
    t.nlfcr = 0;
    if(t.nrfufr)
        {
        for(i = t.nrfufr; i <= t.nrlufr; ++i)
            {
            tfrru(i, "ALL");      /* read update field record and FCR */
            for(j = pf->npfcr; j < pf->npfcr+pf->lenupd; t.fcr[j] = ' ', ++j);
            t.fcr[j] = NULL;
            if(pf->nrdef)
                {
                irec = pf->nrdef;
                tfrfs(&irec);           /* read default -value record(s) */
                if((j = lenstr(&t.sbuf)) < pf->lenupd)
                    {
                    cpystr(&t.fcr[pf->npfcr], &t.sbuf, NULL);
                    t.fcr[pf->npfcr+j] = ' ' ;
                    }
                else
                    {
                    cpybuf(&t.fcr[pf->npfcr], &t.sbuf, pf->lenupd);
                    }
                }
            }
        }
    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       