/*+
 * VOID tfrfs(nrec)
 *    COUNT *nrec;
 *
 * Description  : Routine to fill the stringbuffer with 1, 2 or 3 records.
 *                This routine is reserved for TFR-subroutines only
 *
 * Arguments    : nrec   = input : INTEGER number of first record
 *                         output: INTEGER number of first or second record
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 1-nov-1982
 *
 * Module name  : TFRFS.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : tfrfs.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <tfr.cmn>

VOID tfrfs(nrec)
    COUNT *nrec;

    {
    VOID rcread();

    IMPORT TFRCOM t;

    COUNT i;

/*
 *    read 1, 2 or 3 records into the buffer
 */
    i = 0;
    --(*nrec);
    do
        {
        rcread(t.nunit, ++(*nrec), t.maxbuf, &t.sbuf[i*t.maxbuf]);
        ++i;
        }
    while(t.sbuf[i*t.maxbuf-1]  &&  i != 3);
    }
                                                                                  