/*+
 * VOID mprrst(file, lunit, inwpag)
 *     TEXT  *file;
 *     COUNT lunit, inwpag;
 *
 * Description  : Main routine of the MPR-subroutine package after a save.
 *                Restores menu-status and controls menu
 *
 * Arguments    : file   = STRING containing the save-file name without
 *                         extension
 *                lunit  = INTEGER logical unit number
 *                inwpag = INTEGER indicating whether the menu must be
 *                         (re-)displayed or not (1 or 0).
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 10-feb-1983
 *
 * Module name  : MPRRST.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : mprrst.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *  description : 
-*/
#include <local.h>
#include <mpr.cmn>

VOID mprrst(file, lunit, inwpag)
    TEXT  *file;
    COUNT lunit, inwpag;

    {
    VOID  swrite(), rcread(), mprmn();
    COUNT copen();

    IMPORT MPRCOM m;

    LOCAL TEXT  prog[] = "MPRRST";

    TEXT  filnam[16];
    COUNT ipcl;

/*
 *    generate complete save-file name and open
 */
    cpystr(filnam, file, NULL);
    cpystr(&filnam[scnstr(filnam, '.')], ".MAV", NULL);
    if(copen(lunit, filnam) < 0)
        {
        error(prog, "Error opening MPR save file");
        }
/*
 *    read MPRCOM from the save-file
 */
    rcread(lunit, 1, 342, &m);
    cclose(lunit);
/*
 *    open MPR-library file
 */
    if(copen(lunit, &m.mprfil) < 0)
        {
        error(prog, "Error opening MPR-library file");
        }
    m.nunit = lunit;
    ipcl = inwpag % 2;
/*
 *    control menu processing
 */
    mprmn(ipcl);
    swrite(m.iscr, "+$", &m.clrstr, &m.clrvat, NULL);
    }
                                                                                                                                                                                                                                                                                                                                                            