/*+
 * VOID mprps()
 *
 * Description  : Routine to 'push' the name-record number of the current
 *                menu on the menu-stack
 *                This routine is reserved for MPR-subroutines only
 *
 * Arguments    : none
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 1-nov-1982
 *
 * Module name  : MPRPS.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : mprps.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <mpr.cmn>

VOID mprps()

    {
    IMPORT MPRCOM m;

    COUNT i;

    if(m.istack[m.mstack])
        {
        error("MPRPS", "-Stack overflow");
        }
    for(i = m.mstack-1; i >= 0; m.istack[i+1] = m.istack[i], --i);
    m.istack[0] = m.nrnrcm;
    }
                                                                                                                                                                                                                                                                                       