/*+
 * VOID mprpm(nrec)
 *     COUNT nrec;
 *
 * Description  : Routine to initialize settings for a specified menu
 *                This routine is reserved for MPR-subroutines only
 *
 * Arguments    : nrec  = INTEGER record number of menu name-record
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 1-nov-1982
 *
 * Module name  : MPRPM.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : mprpm.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <mpr.cmn>

VOID mprpm(nrec)
    COUNT nrec;

    {
    VOID  rcread();

    IMPORT MPRCOM m;

/*
 *   menu name-record structure
 */
    STRUCT
        {
        TEXT  menam[8];        /* menu name */
        COUNT nrnxmr;          /* rec.nr. next menu name record */
        COUNT nrfflr1;         /* rec.nr. first function-list record */
        COUNT nrlflr1;         /* rec.nr. last  function-list record */
        };
/*
 *   function-list data record structure
 */
    STRUCT
        {
        TEXT  funkey[6];            /* key-characters */
        TEXT  funtyp[2];            /* function type (M/F/S) */
        TEXT  funptg[8];            /* primary target */
        TEXT  funstg[8];            /* secondary target */
        COUNT nrmtg;                /* rec.nr. of menu target */
        COUNT nrtr;                 /* number of text records */
        };

    LOCAL TEXT  prog[] = "MPRPM";

    TEXT  buf[40], *pb;
    COUNT irec;

    pb = buf;
/*
 *    read name-record of specified menu
 */
    if(nrec < m.nrmmr)
        {
        error(prog, "-Invalid record number");
        }
    if(nrec == m.nrnrcm)
        {
        return;
        }
    rcread(m.nunit, nrec, m.maxbuf, buf);
    m.nrfflr = pb->nrfflr1;
    m.nrlflr = pb->nrlflr1;
    m.nrnrcm = nrec;
/*
 *    fill function tables
 */
    m.nrfun = 0;
    irec = m.nrfflr;
    FOREVER
        {
        if(irec > m.nrlflr)
            {
            break;
            }
        rcread(m.nunit, irec, m.maxbuf, buf); /* get fnctn-list data */
        cpystr(m.funtab[m.nrfun], &pb->funkey, NULL);
        m.typtab[m.nrfun] = pb->funtyp[0];
        cpystr(m.mfttab[m.nrfun], &pb->funptg, NULL);
        m.nrttab[m.nrfun] = pb->nrmtg;
        ++m.nrfun;
        irec += (pb->nrtr+1);
        }
    }
                                                                                                                                                                                                                         