/*+
 * VOID mprmes(mess)
 *     TEXT *mess;
 *
 * Description  : Routine to write a message on the current menu
 *
 * Arguments    : mess  = STRING containing the message to be printed
 *
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 *
 * Version      : V1.0      Date : 1-nov-1982
 *
 * Module name  : MPRMES.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name                 version
 *
 *  description : 
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : mprmes.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *
 *  description : 
-*/
#include <local.h>
#include <mpr.cmn>

VOID mprmes(mess)
    TEXT *mess;

    {
    VOID  swrite(), mprcm();

    IMPORT MPRCOM m;

    LOCAL TEXT cc[][] = {"+\0",
                         " \0",
                         " $"};
    TEXT  text[80];
    COUNT ipos, i;

/*
 *    print message line(s)
 */
    if(m.imesfl)        /* clear messages if necessary */
        {
        mprcm();
        }
    ipos = 0;
    swrite(m.iscr, "+$", &m.mespat, NULL);
    while(m.imesfl < 3)
        {
        if(lenstr(&mess[ipos]) > 79)
            {
            for(i = ipos + 79; i >= ipos; --ipos)
                {
                if(mess[i] == ' '  ||  mess[i] == '-')
                    {
                    cpybuf(text, &mess[ipos], i-ipos+1);
                    text[i-ipos+1] = NULL;
                    swrite(m.iscr, cc[m.imesfl], text, NULL);
                    ++m.imesfl;
                    ipos = ++i;
                    }
                }
            if(i >= ipos)
                {
                break;
                }
            else
                {
                ipos = 79;
                }
            }
        else
            {
            cpystr(text, &mess[ipos], NULL);
            swrite(m.iscr, cc[m.imesfl], text, NULL);
            ++m.imesfl;
            break;
            }
        }
    }
                                                                                                                                                                                                                                                                        