/*+
 * VOID mprdm (ipcl)
 *     COUNT ipcl;
 *
 * Description  : Routine to display current menu
 *                This routine is reserved for MPR-subroutines only
 *
 * Arguments    : ipcl  = INTEGER indicating display-mode:
 *                         0  - do not execute display
 *                         1  - display completely 
 *                         2  - display partial if IBTFLG=0
 *                         3  - display partial regardless of IBTFLG
 * Author       : F.A.Minkema
 *                AKZO PHARMA, Oss Holland
 *                dept. SDA
 * Version      : V1.1      Date : 29-aug-83
 *
 * Module name  : MPRDM.FOR
 *
 * Package      : TRAMP
 *
 * Updates      : name F.A.Minkema     version V1.1
 *  description : For IPCL=1 display completely regardless of IBTFLG
 *                Set IBTFLG=0 for IPCL=3 only
 *
 * Rewritten by : J.W. Gatschuff
 *                Atomic Energy of Canada
 *                Whiteshell Nuclear Research Est.
 *                Pinawa, Manitoba, Canada
 *                branch: Technical Services 
 *
 * Version      : V1.0      Date : 22-OCT-85
 *
 * Module name  : mprdm.c
 *
 * Package      : TRAMPC
 *
 * Updates      : name                 version
 *  description : 
-*/
#include <local.h>
#include <mpr.cmn>

VOID mprdm (ipcl)
    COUNT ipcl;

    {
    VOID  swrite(), header();

    IMPORT MPRCOM m;
    IMPORT TEXT *_pname;
    IMPORT COUNT ifun;

    LOCAL TEXT cc[] =   "+$",
               crlf[] = "\r\n",
               prog[] = "MPRDM";

    TEXT  prec[80];
    COUNT irec, iofun, i;

/*
 *    display heading lines
 */
    if(ipcl == 0  ||  
      (ipcl == 2  &&  m.ibtflg == 1))
        {
        return;
        }
    else if(ipcl == 3)
        {
        m.ibtflg = 0;
        }
    else if(ipcl == 1)
        {
        rcread(m.nunit, m.nrmmr-3, m.maxbuf, prec); /* system header */
        rcread(m.nunit, m.nrmmr-2, m.maxbuf, &prec[40]);
        header(prec, _pname, prec);
        swrite(m.iscr, cc, &m.clrstr, &m.clrvat, prec, crlf, NULL);
        prec[m.maxbuf] = NULL;
        rcread(m.nunit, m.nrmmr-1, m.maxbuf, prec); /* general header */
        swrite(m.iscr, cc, &m.genvat, &m.genlat, prec, NULL);
        if(m.genlat[1][0])
            {
            swrite(m.iscr, cc, crlf, &m.genlat[1], prec, NULL);
            }
        }
    prec[m.maxbuf] = NULL;
    rcread(m.nunit, m.nrnrcm+1, m.maxbuf, prec);   /* menu header */
    swrite(m.iscr, cc, &m.clrvat, &m.menpat, prec, NULL);
    if(ipcl == 1)
        {
        swrite(m.iscr, cc, &m.fnppos, "Function: ", NULL);
        }
/*
 *    display function list
 */
    swrite(m.iscr, cc, &m.flspos, NULL);
    iofun = ifun;    
    ifun = -1;
    irec = m.nrfflr - 1;
    while(irec < m.nrlflr)
        {
        for(i = 0; i < m.lmar; cwrite(m.iscr, " ", 1), ++i);
        irec += 2;
        rcread(m.nunit, irec, m.maxbuf, prec); /* function-list first 
                                                        text record */
        if(prec[m.maxbuf-1] != NULL)
            {
            ++irec;
            rcread(m.nunit, irec, m.maxbuf, &prec[40]); /* function-list
                                                            second text rec */
            }
        ++ifun;
        swrite(m.iscr, cc, &m.flsvat, &m.erlstr, &m.funtab[ifun], &m.clrvat,
               prec, crlf, NULL);
        }
/*
 *    clear rest of function-list eventually
 */
    if(ipcl != 1  &&  ifun < iofun)
        {
        for( ; ifun <= iofun; ++ifun)
            {
            swrite(m.iscr, cc, &m.erlstr, crlf, NULL);
            }
        }
    }
                                                                                                                                                                                                                                                                                                                                                                                                           