	PROGRAM	HELLO
C
C	HELLO,	a program to set the RT11 system time and date
C		from the DIGITAL PATHWAYS TCU-50, TCU-50D, or
C		TCU-100 battery powered clock.  This program
C		works ONLY under SJ monitor versions 2C,
C		3, and 3B.
C
C	Written by 
C		Charles J. Morningstar
C		James R. Cutler
C
C		SPACE PHYSICS RESEARCH LABORATORY
C		DEPARTMENT OF ATMOSPHERIC AND OCEANIC SCIENCE
C		UNIVERSITY OF MICHIGAN
C		ANN ARBOR, MICHIGAN 48109
C
C	In support of 
C		NASA Contract  NAS5-2805
C
C
C	DEFINE THE TCU BASE ADDRESS HERE FOR YOUR INSTALLATION!
C
	INTEGER*2 TCUBAS
	TCUBAS="170770
C
C	DEFINE THE YEAR SINCE TCU'S DON'T KNOW ABOUT THEM!
C	See also line 100
C
	INTEGER*2 YEAR
	YEAR=1978
C
	LOGICAL*1 IALPHA (4)
	DATA IALPHA/"33,"107,0,0/
	INTEGER*4 TIME,DATE(12),NO
	INTEGER*2 IME(2)
	INTEGER*2 MONDAY,DAY,MON,HOR,MIN,HOUR,HORMIN,SEC,MONBAS,DATEWD
	LOGICAL*1 MOND(2),HORM(2)
	EQUIVALENCE (IME(1),TIME)
	EQUIVALENCE(MONDAY,MOND(1))
	EQUIVALENCE(HORMIN,HORM(1))
C
C	Find the monitor
C
	MONBAS=IPEEK("54)
C
C	Get the month and day
C
	MONDAY=IPEEK(TCUBAS)
C
C	Make it into date word for system
C
	DAY=MOND(1)
	MON=MOND(2)
	MON=MON*"2000
	DAY=DAY*"40
	DATEWD=YEAR-1972
	DATEWD=DATEWD+MON+DAY
C
C	This step is very dangerous!
C
	CALL IPOKE(MONBAS+"262,DATEWD)
C
C	Get the hour and minute
C	and then the seconds from the TCU
C
	HORMIN=IPEEK(TCUBAS+2)
	SEC=IPEEK(TCUBAS+4)
C
C	Sort out the components for JTIME call
C
	MIN=HORM(1)
	HOUR=HORM(2)
C
	CALL JTIME(HOUR,MIN,SEC,30,TIME)
C
C	This is also very dangerous!!!
C
	CALL IPOKE(MONBAS+"320,IME(1))
	CALL IPOKE(MONBAS+"322,IME(2))
C
C	The system date and time are now set from the TCU.
C	Say hello to the user
C
	WRITE(5,100)HOUR,MIN,SEC,MOND(1),DATE(MOND(2))
C
C
100	FORMAT(/,' Hello, it is ',I2,':',I2,':',I2,' on ',I2,'
	1-',A4,'78.',/,/)
C
	DATA DATE/'Jan-','Feb-','Mar-','Apr-','May-','Jun-','
	1Jul-','Aug-','Sep-','Oct-','Nov-','Dec-'/
C
	CALL EXIT
C
	END
                                                    