      SUBROUTINE SETGRF(X,Y,THETA,H,NCHAR,CHARS)
C
C     MODIFIED BY P. MURPHY, FEB., 1981 FOR INCLUSION IN THE
C     FOURIER DATA ANALYSIS PROGRAM.
C
C NAME OF PGRM  ALPHANUMERIC CHARACTER PLOTTER
C AUTHOR        CHARLES E. COHN, ARGONNE NATIONAL LABORATORY
C PURPOSE       TO BE USED BY FORTRAN PROGRAMS FOR GENERATING
C               ALPHANUMERIC CHARACTERS ON THE PLOTTER FOR
C               PRODUCTION OF LEGENDS, SCALE MARKINGS, ETC. ON
C               PLOTTED GRAPHS
CCCC
C               SETUP STATEMENT "CALL SETGRF(X,Y,THTA,H,NC,CHARS)"
C               X AND Y ARE COORDINATES IN INCHES OF THE LOWER LEFT-HAND
C                       CORNER OF THE FIRST CHARACTER PLOTTED
C               THTA IS THE ANGLE OF INCLINATION OF THE STRING OF
C                       CHARACTERS IN DEGREES
C               H IS THE CHARACTER HEIGHT IN INCHES.
C               NC IS THE INTEGER NUMBER OF CHARACTERS TO BE DRAWN.
C               CHARS IS A BYTE ARRAY OR ALPHANUMERIC LITERAL
C               CONTAINING THE CHARACTERS TO BE DRAWN.
      IMPLICIT INTEGER*2 (I-N)
      INTEGER*2 JOFF(56)
      LOGICAL*1 NLFT
      LOGICAL*1 CHARS(1),OFFSET(330),LLET(2)
      EQUIVALENCE (LLET(1),LETTER)
      DATA JOFF/1,12,12,12,18,24,30,41,46,52,54,59,61,70,75,
     1 83,93,101,110,122,127,143,155,155,155,155,160,160,160,
     2 160,167,179,187,194,201,207,217,223,229,234,240,243,248,
     3 252,261,268,280,289,301,305,309,312,317,322,327,331/
      DATA OFFSET/2,26,35,28,12,5,14,38,22,23,17,
     1 5,14,15,7,6,14, 32,25,19,20,30,39, 0,9,19,20,14,7,
     2 1,37,19,5,33,19,3,35,19,21,17, 3,35,19,17,21,
     3 0,9,10,2,1,9, 3,35, 0,1,9,8,0, 0,39,
     4 8,24,33,38,31,15,6,1,8, 8,24,16,23,14,
     5 32,0,1,36,38,31,15,6, 1,8,24,33,35,28,20,39,15,6,
     6 7,3,35,27,31,24,16,32, 1,8,24,33,35,28,4,7,39,
     7 3,12,28,35,33,24,8,1,6,15,31,38, 6,7,39,17,16,
     8 28,35,33,24,8,1,3,12,28,37,38,31,15,6,5,12,
     9 1,8,24,33,38,31,15,6,4,11,27,36, 2,34,63,4,36,
     A 0,11,23,27,11,27,32, 4,7,31,38,37,28,4,0,24,33,35,28,
     B 33,24,8,1,6,15,31,38, 0,7,31,38,33,24,0,
     C 39,7,4,28,4,0,32, 39,7,4,28,4,0,
     D 27,35,33,24,8,1,6,15,31,38, 0,7,4,36,39,32, 8,24,16,23,15,31,
     E 1,8,24,33,39, 7,0,3,39,21,32, 7,0,32, 0,7,19,39,32,
     F 39,32,7,0, 8,24,33,38,31,15,6,1,8, 0,7,31,38,37,28,4,
     G 8,24,33,38,31,15,6,1,8,63,18,32, 0,7,31,38,37,28,4,12,32,
     H 1,8,24,33,35,28,12,5,6,15,31,38, 16,23,7,39, 7,0,32,39,
     I 39,16,7, 7,8,20,24,39, 0,39,63,32,7, 16,20,39,20,7,
     J 7,39,0,32/
      DATA LETTER/0/
      HA=H/7.
      TRAD=THETA/57.295779513
      XN=HA*COS(TRAD)
      YN=HA*SIN(TRAD)
      XL=XN*10.
      XS=XL*.6
      YL=YN*10.
      YS=YL*.6
      X0=X
      Y0=Y
      XC=X0
      YC=Y0
      DO 1 ICHAR=1,NCHAR
      LLET(1)=CHARS(ICHAR)
      IF(LETTER.LT.36.OR.LETTER.GT.90)GOTO2
      CALL PLTX(32)
      NLFT=.FALSE.
      IOFF=JOFF(LETTER-35)
    3 IF(IOFF.GE.JOFF(LETTER-34))GOTO2
      IOFSET=OFFSET(IOFF)
      IXOFF=IOFSET/8
      IF(IXOFF.NE.7)GOTO4
      CALL PLTX(32)
      NLFT=.FALSE.
      GOTO5
    4 XOFF=IXOFF
      YOFF=MOD(IOFSET,8)
      CALL PLOT(XC+XOFF*XN-YOFF*YN,YC+XOFF*YN+YOFF*XN,1)
      IF(NLFT)GOTO5
      CALL PLTX(16)
      NLFT=.TRUE.
    5 IOFF=IOFF+1
      GOTO3
    2 XC=XC+XS
    1 YC=YC+YS
      RETURN
      END
                                                                                                                                                                                                                       