
      SUBROUTINE PLTOUT(STRING,NCHARS)
C
C  14-Oct-82 DVJensen - Generalized plotter output subroutine.
C     Intended for all output to the plotter to be buffered here to
C     block the characters into nice sized chunks and reduce the
C     the number of carriage return/line feeds generated and therefore
C     reduce the size of the output file.
C
C  4-Nov-82 Calls to OUTPEN removed; no inline driver support. 
C     - Merger with EZPLOT addition of ZGRAPH Common to access common
C       plotter logical unit for Fortran output.  Logical unit
C       zero now results in output being thrown away (like negative
C       logical unit).  Setup of plotter logical unit is accomplished
C       through the INIPLT subroutine.  
C
C PLTOUT - This subroutine accepts strings to be output to a plotter.
C     A buffer of BUFSIZ characters is maintained when output is directed
C     to a plotter logical unit (PLTLUN) which is greater than zero.
C     In this case, a WRITE is issued only when the buffer is full.
C     In the case where PLTLUN=0, the characters are transmitted to
C     subroutine OUTPEN one at a time, where OUTPEN is presumed to be
C     an inline plotter driver which will do its own buffering if
C     appropriate.  Setting PLTLUN negative will result in plotter
C     output being thrown away, equivalent to output to the NL driver.
C
C     A call with NCHARS<=0 will flush the internal PLTOUT buffer.  This
C     should be done prior to closing PLTLUN, but can be done at any
C     time.
C
      IMPLICIT INTEGER*2 (I-P)
      LOGICAL*1 STRING(NCHARS),BUFFER(80)
      INTEGER*2 BUFCNT,BUFSIZ
      DATA BUFCNT /1/, BUFSIZ /80/, BUFFER(1) /' '/
      COMMON /ZGRAPH/ PLTLUN
C
      IF(PLTLUN) 90,30,8
8     IF(NCHARS) 20,20,10
C
C   Move string into buffer and write to unit > 0 when BUFFER full.
10    IF (BUFCNT+NCHARS .LE. BUFSIZ) GOTO 12
C  Do no split input strings across buffer boundaries.
C  Numbers output will get interpreted wrong if split by CR-LF's.
      IF (BUFCNT.GT.1) WRITE(PLTLUN,14,END=60,ERR=60)
     1                      (BUFFER(I),I=1,BUFCNT)
      BUFCNT = 1
      IF (NCHARS .GE. BUFSIZ) GOTO 19
12    DO 18 I=1,NCHARS
        BUFCNT=BUFCNT+1
        BUFFER(BUFCNT)=STRING(I)
        IF(BUFCNT.LT.BUFSIZ) GO TO 18
        WRITE(PLTLUN,14,END=60,ERR=60) BUFFER
14      FORMAT(80A1)
        BUFCNT=1
18      CONTINUE
      RETURN
C Write out string which is bigger than BUFFER.
19    WRITE(PLTLUN,14,END=60,ERR=60) (STRING(I),I=1,NCHARS)
      RETURN
C
C   Process request to flush BUFFER.
20    IF(BUFCNT.LE.1) GO TO 27
      WRITE(PLTLUN,14,END=60,ERR=60) (BUFFER(I),I=1,BUFCNT)
27    BUFCNT=1
      RETURN
C
C   Process output to inline driver via single character transfer to OUTPEN.
30    CONTINUE
C      IF (NCHARS.LE.0) GOTO 90
C      DO 39 I=1,NCHARS
C      CALL OUTPEN(STRING(I))
C39    CONTINUE
      RETURN
C
60    PLTERR=PLTERR+1
90    RETURN
      END
                                                                                    