      SUBROUTINE PLOT (X,Y,IC)
C
C     TO PLOT STRAIGHT LINES OF ANY LENGTH AND DIRECTION, WITH
C     PEN UP, OR PEN DOWN. 
C     Modified: 5-Nov-82 by DVJensen, Ames Lab, Ames, IA.
C     - Dotted and dashed lines have been removed. Use the HIPLOT
C       L command to select the type of line desired.  (See LINTYP.)
C     - Use of PLTX single increment control has been converted to
C       DMPL style multiple relative step control output through 
C       PLTOUT.  A very large decrease in the size of the plot file
C       was realized (factor of ~100!). 
C
C     ORIGINAL PROGRAM BY C. E. COHN FOR THE DDP-24, MODIFIED
C     FOR THE PDP-11/34 BY J. MORMAN, AUG., 1979.  PLOT LIMITS
C     ARE SET FOR THE 10 X 7 IN. AREA OF THE HIPLOT PLOTTER.
C
C     MODIFIED BY P. MURPHY FOR USE WITH THE HIPLOT DMP-4
C     INCREMENTAL PLOTTER (FEB., 1981) .
C
C     THE ROUTINE IS USED BY THE STATEMENT:  CALL PLOT (X,Y,IC)
C     WHERE X AND Y ARE COORDINATES OF THE END POINT OF THE
C     LINE (IN INCHES, FLOATING POINT); IC = CONTROL PARAMETER,
C     INTEGER VALUED.
C     IABS(IC) =  0 OR 1	NO EFFECT
C		  2		LOWER PEN BEFORE TRACING LINE
C		  3		RAISE PEN BEFORE TRACING LINE
C (not supported) 4		DOTTED LINE, DOT EVERY  10 STEPS
C (not supported) 5		DASHED LINE, DASHES AND SPACES
C				10 STEPS LONG
C		 10		NO LINE PLOTTED.  X AND Y ARE SET
C				AS UPPER LIMITS FOR FUTURE PLOT
C				COORDINATES.
C		 11		NO LINE PLOTTED.  X AND Y ARE SET
C				AS LOWER LIMITS FOR FUTURE PLOT
C				COORDINATES.
C     IF IC IS NEGATIVE, END POINT OF LINE IS DEFINED AS NEW
C     ORIGIN OF COORDINATES.  IF ALSO X=Y=0.0, PRESENT PEN
C     POSITION IS DEFINED AS NEW ORIGIN, PEN NOT MOVED.
C     THIS ALSO INITIALIZES  PLTX.
C
      DATA  XMAX,YMAX,XMIN,YMIN/10.4,7.4,0.0,0.0/
      DATA FACTOR/400./
C   STEP SIZE, INCHES    FACTOR
C        .005              400.
C        .01               200.
      LOGICAL*1 STRING(6)
C
      IF (IC) 10,40,40
   10 IF (X) 40,20,40
   20 IF (Y) 40,30,40
   30 NPX =  0
C     NO LINE PLOTTED.  DEFINE PRESENT PEN POSITION AS ORIGIN
      NPY = 0
      CALL PLTX (0)
      RETURN
   40 ICA = IABS(IC)
      IF (ICA-10) 70,50,60
C     SET UPPER LIMITS FOR X AND Y
   50 XMAX = X
      YMAX = Y
      GO TO 310
C     SET LOWER LIMITS FOR X AND Y
   60 XMIN = X
      YMIN = Y
      GO TO 310
C     PLOT A LINE
   70 IF (ICA-2)  100,80,90
   80 CALL PLTX (16)
      GO TO 100
   90 CALL PLTX (32)
  100 NX = (IFIX(FACTOR*AMAX1(XMIN,AMIN1(XMAX,X))))/2
      NY = (IFIX(FACTOR*AMAX1(YMIN,AMIN1(YMAX,Y))))/2
      NDX = NX - NPX
      NDY = NY - NPY
      NPX = NX
      NPY = NY
  110 CALL ICONV(NDX,STRING,LENGTH)
      CALL PLTOUT(STRING,LENGTH)
      CALL PLTOUT(',' , 1)
      CALL ICONV(NDY,STRING,LENGTH)
      CALL PLTOUT(STRING,LENGTH)
      CALL PLTOUT(' ',1)
  290 IF (IC) 300,310,310
C     RESET ORIGIN TO PRESENT PEN  POSITION AFTER PLOTTING
  300 NPX = 0
      NPY = 0
  310 RETURN
      END
                                                                        