/*
 *				s t r f n s . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	strfns	Simple String Functions
index		Convert character to a new string
index		Make a new copy of a string
index		Concatenate strings making new string
index		Extract characters from a string forming a new string
index		Extract segment of a string forming a new string
index		Take leftmost characters forming a new string
index		Take rightmost characters forming a new string

synopsis

	 char *
	 ctos(c)
	 char c;

	 char *
	 scopy(s)
	 char s[];

	 char *
	 scat(s1,s2)
	 char s1[],s2[];

	 char *
	 mid(s,n,l)
	 char s[];
	 int n,l;

	 char *
	 seg(s,n,l)
	 char s[];
	 int n,l;

	 char *
	 right(s,l)
	 char s[];
	 int l;

	 char *
	 left(s,n)
	 char s[];
	 int n;

description

	The functions defined here provide simple manipulation of character
	strings a la BASIC.  The strings returned are all new - i.e. not
	substrings of the strings passed.  All returned strings are in space
	acquired from talloc() (q.v.); you should set a mark before calling
	these functions and then used tfree() to clean up.

	A return of NULL indicates a fatal error - usually it means that the
	function couldn't allocate space for the string it wanted to make.
	.lm +8

 ctos(c)
	.br
	returns a new string containing single character c.
	
 scopy(s)
	.br
	returns a fresh copy of s.

 scat(s,t)
	.br
	concatenates s and t.

 mid(s,n,l)
	.br
	extracts l characters from s starting at character n (first character
	is  n=0, etc.).  If the substring specified does not exist, the part
	that does is extracted.  For example, n<0 is equivalent to n=0.
	
 seg(s,n,m)
	.br
	is the substring of characters in positions n through m inclusive.  
	(The first character is position 0).  If n>m, they are exchanged.  As
	with mid(), if the "substring" specified overflows s, only the	
	"proper" part is extracted.

 left(s,l)
	.br
	extracts the leftmost l characters of s, with "overflow" handled as
	for mid().

 right(s,n)
	.br
	is the substring of characters starting at character n, where the  
	first character is character 0.  Overflow handling is as for mid().
	
	.lm-16
	Note:  These functions have been written to be simple to use, not to
	be particularly efficient.  If you are going to be doing large amounts
	of string processing, you will almost certainly want to use different
	techniques.  Don't forget that every string created in space allocated
	by talloc() requires 4 words of overhead - 2 for malloc() and 1 for
	talloc().

bugs

author

	Jerry Leichter

#endif

/*
 *)EDITLEVEL=04
 * Edit history
 * 0.0 14-May-81 JSL	Invention
 * 0.1 18-May-81 JSL	Converted to use of talloc(); also re-did comments
 */

#define NULL 0
#define EOS '\0'
#define BIG 32767

extern char *talloc();

char *
ctos(c)
char c;
{	register char *s;

	if ((s=talloc(2)) != NULL)
	{	s[0] = c;
		s[1] = EOS;
	}
	return(s);
}

char *
scopy(s)
register char s[];
{	register char *new;
	if ((new=talloc(strlen(s)+1)) != NULL)
		cpystr(new,s);
	return(new);
}

char *
scat(s1,s2)
char s1[],s2[];
{	char *new;
	new = talloc(strlen(s1)+strlen(s2)+1);
	if (new != NULL)
		cpystr(cpystr(new,s1),s2);
	return(new);
}

char *
mid(s,n,l)
char s[];
register int n,l;
{	char *new;
	register int len;
	len = strlen(s);
	if (n < 0)				/* before beginning of s */
		n = 0;
	else if (n > len)			/* beyond end */
		n = len;

	if (l < 0)
		l = 0;
	else if (l > len - n)			/* beyond end of s */
		l = len - n;			/* take rest */

	if ((new = talloc(l + 1)) != NULL)
	{	copy(new,s+n,l);
		new[l] = EOS;
	}
	return(new);
}

char *
seg(s,n,m)
char s[];
register int n,m;
{	register int t;
	if (n > m)
	{	t = n;
		n = m;
		m = t;
	}
	return(mid(s,n,m-n+1));
}

char *
left(s,l)
char s[];
int l;
{	return(mid(s,0,l));	}

char *
right(s,n)
char s[];
int n;
{	return(mid(s,n,BIG));	}
                                                                                              