/*
 *				i r a n d . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	irand	Random number modulus argument
index		Random number generator

synopsis
	.s.nf
	int
	irand(arg)
	int		arg;
Description

	Generate a pseudorandom number in the range 0 .. (arg-1).
	If arg is zero, generate a number in the range 0 .. 32767.

	Note that the algorithm is prone to nonrandom sequences when
	considering the next pseudorandom number.

	irand is equivalent to the following sequence:

		extern long	rand;

		if (arg == 0) arg = 32767;
		return(((rand() >> 8) & 32767) % arg);

Bugs

#endif

int
irand(max)
register int	max;
/*
 * Rand with modulus
 */
{
	register int	temp;
	extern long	rand();

	temp = rand() >> 8;
	temp &= 32767;
	return ((max == 0) ? max : temp % max);
}
                                                                                                                                                                                                                   