
/*
 * esp.  Outputs to a special purpose paper tape punch
 *	(for loading eprom's?)
 */

#include <stdio.h>

#define	FF	0377

FILE *esb;
FILE *pun;

main(argc, argv)
char *argv[];
{
	register int b, n;

	if(argc < 2) {
		fprintf(stderr, "Usage: esp file.\n");
		exit(1);
	}
	if((esb=fopen(argv[1], "r")) == NULL) {
		fprintf(stderr, "%s: cannot open.\n", argv[1]);
		exit(1);
	}
	if((pun=fopen("pp0:", "wn")) == NULL) {
		fprintf(stderr, "Who stole the punch.\n");
		exit(1);
	}
	while((b=get()) != EOF) {
		n = 8;
		do {
			putc(0, pun);
		} while(--n);
		putc(FF, pun);
		putc(b, pun);
		copy();
		n = get();
		putc(n, pun);
		while(n--)
			copy();
		copy();
		copy();
	}
	n = 8;
	do {
		putc(0, pun);
	} while(--n);
	putc(FF, pun);
	putc(FF, pun);
}

copy()
{
	register int b;

	if((b=get()) == EOF)
		botch("copy");
	putc(b, pun);
}

get()
{
	register int c1, c2;

	while((c1=getc(esb))==' ' || c1=='\n')
		;
	if(c1 == EOF)
		return(EOF);
	while((c2=getc(esb))==' ' || c2=='\n')
		;
	if(c2 == EOF)
		botch("get");
	return(val(c1)<<4 | val(c2));
}

val(c)
{
	if(c>='0' && c<='9')
		return(c-'0');
	if(c>='a' && c<='f')
		return(10+c-'a');
	if(c>='A' && c<='F')
		return(10+c-'A');
	botch("val");
}

botch(s)
char *s;
{
	fprintf(stderr, "Botch in %s\n", s);
	exit(1);
}
                                                                                                                                                                         