	INTEGER FUNCTION IPARSE(LINE,COMAND,NARGS,IARGS)
C
C	Detect Octal character codes and Alphabetic commands from the
C	input line (following a "\").  Return Octal codes as received.
C	Convert the ASCII command name to RAD50, count and decode the
C	command arguments.  Command names must be 6 characters or shorter
C	and may be delimited by an opening parenthesis.  If present,
C	argument values must be positive and less than 4 digits long.  A
C	maximum of 20 arguments will be decoded.  Trailing text strings
C	are ignored.
C
C		LINE	- Input ASCII string to be parsed
C		COMAND	- RAD50 coded command returned as a REAL*4
C		NARGS	- Count of the number of arguments found
C		IARGS	- Vector containing the argument values
C
C		IPARSE	> 0	- Found Octal code representing ASCII char.
C			= 0	- Found alphabetic command string
C			 -1	- No closing parenthesis on argument list
C			 -2	- Illegal character found in argument list
C			 -3	- Too many characters in argument string
C
	REAL COMAND
	INTEGER NARGS,IARGS(20),I,IB,IE,NCHARS
	BYTE LINE(1),SAVBYT

	IPARSE = -2			!Assume illegal character found
	IF(LINE(1) .LT. '$')  RETURN
	IF(LINE(1) .NE. '$' .AND. LINE(1) .LT. 'A')  GO TO 70
	IPARSE = 0			!Assume success
	NARGS = 0
	COMAND = 0.0			!Preset to RAD50 zero
C	Convert lowercase commands to uppercase for our use
	DO 1000 I = 1,6
	IF(LINE(I) .EQ. 0 .OR. LINE(I) .EQ. '(')  GO TO 5
	IF(LINE(I) .GT. "140)  LINE(I) = LINE(I) - "40
 1000	CONTINUE
    5	I = IRAD50(6,LINE,COMAND)
	I = I + 1
	IF(LINE(I) .EQ. 0)  RETURN	!No command arguments
	IB = INDEX(LINE,'(') + 1
	IF(IB .EQ. 1)  RETURN		!Ignore trailing garbage
	IE = INDEX(LINE,')')
	IF(IE .GT. 0)  GO TO 10
	IPARSE = -1			!No closing parenthesis found
	RETURN
   10	LINE(IE) = ','			!Temporarily modify input line
	SAVBYT = LINE(IE+1)
	LINE(IE+1) = 0
	I = IVERIF(LINE(IB),',0123456789')
	IF(I .EQ. 0)  GO TO 20
	IPARSE = -2			!Illegal character in argument list
	GO TO 60
   20	IF(IB .GE. IE)  GO TO 60
	NCHARS = INDEX(LINE(IB),',') - 1  !Look for an argument seperator
	IF(NCHARS .GT. 0)  GO TO 30
	IARGS(NARGS+1) = "177777	!FORTRAN null argument code
	IB = IB + 2
	GO TO 50
   30	IF(NCHARS .LE. 3)  GO TO 40
	IPARSE = -3			!Argument value too large
	GO TO 60
   40	DECODE(NCHARS,100,LINE(IB))  IARGS(NARGS+1)
  100	FORMAT(I)
	IB = IB + NCHARS + 1
   50	NARGS = NARGS + 1
	IF(NARGS .GE. 20)  GO TO 60	!Decode maximum of 20 arguments
	GO TO 20
   60	LINE(IE) = ')'			!Restore input line
	LINE(IE+1) = SAVBYT
	RETURN

   70	L = LEN(LINE)			!Look for Octal code commands
	IF(L .GT. 3)  RETURN
	DO 2000 I = 1,L
	IF(IVERIF(LINE(I),'01234567') .NE. 0)  RETURN
 2000	CONTINUE
	DECODE(L,200,LINE(1))  IPARSE
  200	FORMAT(O3)
	IF(IPARSE .GT. "177)  IPARSE = -2
	RETURN
	END
                                                                                                                                                                                                                                                                               