#include "stdio.h"	/* MERGE.C   MERGE TWO FILES OF DIFFERENT LENGTH */
			/* according to specific sort keys		 */
			/* ..these files are assumed to be sorted */
			/*   already by the above sort keys ..... */
char line1[300], line2[300];	/* data input lines .. max 300 characters */
char output[600];		/* data output line ..max 600 characters */
char name1[20], name2[20], name3[20];	/* data filenames */
int  rec1, rec2, rec3;			/* # char in each file */
int  key1, key2;			/* key starting point ..base = 1 */
int  len;				/* length of keys */
int  open1, open2;		/* file status flag; 0=ok ; 1=EOR found */
int  flag2;			/* file 2 match flag; 0=nomatch; 1=match */
int cnt1, cnt2, cnt3;		/* line count for files 1,2 & 3 */
int mis1, mis2;			/* number not matched for file 1 & 2 */

main()
{
FILE *fopen(),*fp1,*fp2,*fp3; 	/* data file pointers */
int test;
int i,j;
char chr;

/* GET FILE INFORMATION FROM USER */
/* PRINT SYSTEM MESSAGE */
printf("HUMAN RESOURCE INFORMATION SYSTEMS \n\n");
printf("FILE MERGE SYSTEM ...\n\n");
printf("Will merge two FSA files based on specific sort keys\n");
printf("File # 1 ... (long file) is the primary data file\n");
printf("File # 2 ... (table file) is cantenated to the end\n");
printf("             of file #1 ...only...if their keys match\n");
printf("\n\n");

/* FILE # 1 INFO */
printf("ENTER : NAME of input file # 1           :");
scanf("%s",name1);
printf("ENTER : file SIZE (characters per record):");
scanf("%d",&rec1); 
printf("ENTER : KEY starting position            :");
scanf("%d",&key1);
printf("ENTER : key LENGTH (number of characters):");
scanf("%d",&len);

/* FILE # 2 INFO */
puts("*");
printf("ENTER : NAME of input file # 2 :");
scanf("%s",name2);
printf("ENTER : file SIZE              :");
scanf("%d",&rec2);
printf("ENTER : KEY starting position  :");
scanf("%d",&key2);

/* FILE # 3 INFO */
puts("*");
printf("ENTER : NAME of output file :");
scanf("%s",name3);

printf("\n\nSTART FILE MERGING ... \n\n");

/* OPEN FILES */
if((fp1=fopen(name1,"rn"))==NULL)printf("CANNOT OPEN FILE # 1 '%s'\n",name1);
if((fp2=fopen(name2,"rn"))==NULL)printf("CANNOT OPEN FILE # 2 '%s'\n",name2);
if((fp3=fopen(name3,"wn"))==NULL)printf("CANNOT OPEN OUTPUT FILE '%s'\n",name3);

if(fp1!=NULL && fp2!=NULL && fp3!=NULL) /* ALL MUST BE OPENED */
{
	/* test files .. if non-printable char are first char */
	/* file 1*/

	while((chr=getc(fp1))<' ')printf("file1..delete char :%d\n",chr);
	ungetc(chr,fp1);

	/* file 2 */
	while((chr=getc(fp2))<' ')printf("file2..delete char :%d\n",chr);
	ungetc(chr,fp2);

	/* init. variables */
	open1=0;
	open2=0;
	cnt1=0;
	cnt2=0;
	cnt3=0;
	mis1=0;
	mis2=0;
	rec3=rec1+rec2;

	/* read both files */
	readfl(3,fp1,fp2);

	/* make comparision */
	while((test=testfl())!=0)
	{
		if(test==1)	/* MATCH ..MERGE TWO FILES UNTO OUTPUT */
		{	j=0;
			for(i=0; i<rec1; i++)	output[j++]=line1[i];
			for(i=0; i<rec2; i++)	output[j++]=line2[i];
			output[j++]='\r';
			output[j]  ='\n';

			fprintf(fp3,"%s",output);
			cnt3++;
			flag2=1;
			readfl(1,fp1,fp2);
		}
		else if(test==2)	/* NEXT READ IS FROM FILE 2 */
		{
			if(flag2==0)
			{	mis2++;
			}	
			readfl(2,fp1,fp2);
		}
		else if(test==3)	/* NEXT READ IS FROM FILE 1 */
		{	mis1++;
			printf("NO MATCH..FILE #1.. LINE #%d >>%s\n",cnt1,line1);
			j=0;
			for(i=0; i<rec1; i++)	output[j++]=line1[i];
			for(i=0; i<rec2; i++)	output[j++]=' ';
			output[j++]='\r';
			output[j]  ='\n';
	
			fprintf(fp3,"%s",output);
			cnt3++;
			readfl(1,fp1,fp2);
		}
	}
}
printf("\n\nSUMMARY OF MERGE RUN ...\n\n");
printf("                number   char.     lines \n");
printf("filename         lines  per line  not matched \n\n");
printf("%-14s   %5d   %5d   %5d\n",name1,cnt1,rec1,mis1);
printf("%-14s   %5d   %5d   %5d\n",name2,cnt2,rec2,mis2);
printf("%-14s   %5d   %5d\n",name3,cnt3,rec3);

}

readfl(fun,fp1,fp2)		/* FUNCTION TO READ FILES */
int fun;		/* fun= function desired */
int *fp1,*fp2;		/* file pointers */
			/* fun=1 ..only file #1 */
			/* fun=2 ..only file #2 */
			/* fun=3 ..both files   */
{
	int i,err;
	
	/* test if file #1 */
	if(fun==1 || fun==3)
	{
		for(i=1; i<=rec1; i++)line1[i]=' '; /* blank out line */
		err=fgets(line1,300,fp1);	/* read one line */
		if(err==NULL)open1=1; 
		else if(line1[0]<' ')open1=1;
		else cnt1++;
	}

	/* test if file #2 */
	if(fun==2 || fun==3)
	{	
		for(i=0; i<=rec2; i++)line2[i]=' '; /* blank out line */
		err=fgets(line2,300,fp2);	/* read one line */
		if(err==NULL)open2=1;		/* EOR ??? */
		else if(line2[0]<' ')open2=1;
		else cnt2++;
		flag2=0;
	}
}

testfl()	/* ROUTINE TO COMPAIR KEY FIELDS */
		/* compairs 2 keys. function returns : */
		/* 0 if...both files are empty		*/
		/* 1 if...both keys are identical	*/
		/* 2 if...file 1 is empty -or-	*/
		/*     ...key1 > key2		*/
		/* 3 if...file 2 is empty -or-	*/
		/*     ...key1 < key2		*/
{
	int i, j, k;

	/* test if files are empty */
	if(open1==1 && open2==1)return(0);
	if(open1==1)return(2);
	if(open2==1)return(3);

	/* compair key fields */
	i=key1-1;
	j=key2-1;
	k=0;
	while(k<len)	/* only conpair 'len' number characters */
	{
		if(line1[i]>line2[j]) return(2);
		if(line1[i]<line2[j]) return(3);
		k++; i++; j++;
	}
	return(1);
}
                                                                                                                                                                                                                                                              