      PROGRAM JACOBI
C
C           ***** BENCHMARK 1 JACOBI *****
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      COMMON/IO/IN,IOUT,IPUNCH
      DIMENSION F(100,100),U(100,100),FM(15),FF(1),VAL(100),SCR(100)
      EQUIVALENCE(FF(1),F(1,1))
      DATA ONE/1.0D0/,FOUR/4.0D0/,TEN/10.0D0/,ZERO/0.0D0/
 2001 FORMAT(' MJEIG TOOK ',I3,' ITERATIONS.'/(1X,5D20.13))
 2002 FORMAT(' ONE CHECK:',I5,D30.20)
 2003 FORMAT(' ZERO CHECK:',2I5,D30.20)
C
C     FILL I/O COMMON.
      IN=5
      IOUT=6
      IPUNCH=7
      NN=100
      MX=100
C
      CALL HEADER ('JACOBI BENCHMARK - 100*100 MATRIX',31)
      CALL TIMRB
C
C     GENERATE MATRIX TO BE DIAGONALIZED.
      PIBY10=(FOUR*DATAN(ONE))/TEN
      CALL FMTSET(0,0,0)
      K=0
      DO 10 I=1,NN
      DO 10 J=1,I
      K=K+1
      M=MOD(I+J,9)+1
      IX1=MOD(I+J-2,10)
      IX2=MOD(2*I+3*J-4,10)
      X1=DFLOAT(IX1)
      X2=DFLOAT(IX2)*PIBY10
      X=X1+X2
      CALL FMTGEN(FM,X,M,ICK)
   10 FF(K)=FM(M)
C
C     PUT INTO SQUARE FORM.
      CALL SQUARE(FF,F,MX,NN,0)
C
C     PERFORM THE DIAGONALIZATION.
      CALL MJEIG(MX,NN,F,U,VAL,SCR,NUMIT)
C
C     SUMMARY PRINTING.
      WRITE(IOUT,2001)NUMIT,(VAL(I),I=1,NN)
C
C     PERFORM CHECK ON MATRIX OF EIGENVECTORS.
C     FORM PRODUCT U(DAGGER)*U, AND TEST TO SEE IF UNIT MATRIX
C     IS OBTAINED.
      DO 20 I=1,NN
      DO 20 J=1,NN
   20 F(I,J)=U(I,J)
      CALL MATREC(F,U,SCR,MX,NN,NN,NN,2)
      ISAVE=0
      SAVE=ZERO
      DO 30 I=1,NN
      TEST=DABS(F(I,I)-ONE)
      IF(TEST.LT.SAVE)GO TO 30
      SAVE=F(I,I)
      ISAVE=I
   30 CONTINUE
      WRITE(IOUT,2002)ISAVE,SAVE
      SAVE=ZERO
      ISAVE=0
      JSAVE=0
      DO 40 I=1,NN
      DO 40 J=1,NN
      IF(I.EQ.J)GO TO 40
      TEST=DABS(F(I,J))
      IF(TEST.LT.SAVE)GO TO 40
      ISAVE=I
      JSAVE=J
      SAVE=F(I,J)
   40 CONTINUE
      WRITE(IOUT,2003)ISAVE,JSAVE,SAVE
	CALL TIMRE
      STOP
      END
      SUBROUTINE MJEIG(M,N,A,S,EVAL,W,NUMIT)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C     SUBROUTINE MJEIG(A,N,RHO,EVAL,IVS,S,IA,IS)
C     THIS ROUTINE PERFORMS A JACOBI DIAGONALISATION OF INPUT MATRIX
C     A(N,N). RHO IS THE ACCURACY LIMIT. THE EIGENVALUES ARE LEFT INITIA
C     IN A(I,I). LATER THESE ARE TRANSFERRED TO EVAL(I), AND PLACED IN
C     ASCENDING ORDER. THE EIGENVECTORS STORED IN S(N,N) ARE REORDERED A
C     ACCORDINGLY. SETTING IVS=1 GENERATES THE EIGENVALUES ONLY*****   .
      INTEGER P,Q
      DOUBLE PRECISION INT1,NORM1,NORM2,MU,NN
      DIMENSION A(M,M),S(M,M),EVAL(M),W(M)
      EQUIVALENCE(STCT,TEMP)
      DATA ZERO/0.0D0/,ONE/1.0D0/,TWO/2.0D0/
      DATA PT5/0.5D0/
      DATA RHOSQ/1.0D-9/
C
C      *******DELETE FOLLOWING FROM ORIGINAL PROGRAM (IT WAS WRONG ANYWA
C     FLOATF(X)=DFLOAT(X)
C
C     ***********THESE DEFINITIONS ARE NO LONGER NEEDED
C     ABSF(X)=DABS(X)
C     SQRTF(X)=DSQRT(X)
C
      RHO=RHOSQ
      IVS=0
C     **********STATEMENT REMOVED FROM ORIGINAL
C     NN=FLOATF(N)
      NN=N
      NUMIT=0
      IF(IVS-1)100,26,100
  100 DO 1 I=1,N
      DO 2 J=1,N
    2 S(I,J)=ZERO
    1 S(I,I)=ONE
   26 NORM=ZERO
      DO 10 I=1,N
      RS=ZERO
      DO 99 J=1,N
   99 RS=RS+DABS(A(I,J))
      IF(RS-NORM1)10,10,12
   12 NORM1=RS
   10 CONTINUE
      NORM2=(RHO/NN)*NORM1
      THR=NORM1
      IND=0
    3 THR=THR/NN
    5 NUMIT=NUMIT+1
      DO 4 Q=2,N
      IZ=Q-1
      DO 4 P=1,IZ
      IF(THR-DABS(A(P,Q)))25,25,4
   25 IND=1
      V1=A(P,P)
      V2=A(P,Q)
      V3=A(Q,Q)
      MU=PT5*(V1-V3)
      IF(MU)6,7,7
    6 SIGN=ONE
      GO TO 8
    7 SIGN=-ONE
    8 OMEGA=SIGN*V2/DSQRT(V2**2+MU**2)
      XTEMP=ONE+DSQRT(DABS(ONE-OMEGA*OMEGA))
      SINT=OMEGA/DSQRT(XTEMP+XTEMP)
      COST=DSQRT(DABS(ONE-SINT*SINT))
      DO 13 I=1,N
      IF(I-Q)15,14,15
   15 IF(I-P)16,14,16
   16 INT1=A(I,P)
      MU=A(I,Q)
      TEMP=INT1*SINT+MU*COST
      A(I,Q)=TEMP
      A(Q,I)=TEMP
      TEMP=INT1*COST-MU*SINT
      A(I,P)=TEMP
      A(P,I)=TEMP
   14 CONTINUE
      IF(IVS-1)70,13,70
   70 INT1=S(I,P)
      MU=S(I,Q)
      S(I,Q)=INT1*SINT+MU*COST
      S(I,P)=INT1*COST-MU*SINT
   13 CONTINUE
      STCT=SINT*COST
      COST2=COST*COST
      SINT2=SINT*SINT
      A(P,P)=V1*COST2+V3*SINT2-(V2+V2)*STCT
      A(Q,Q)=V1*SINT2+V3*COST2+(V2+V2)*STCT
      TEMP=(V1-V3)*STCT+V2*(COST2-SINT2)
      A(P,Q)=TEMP
      A(Q,P)=TEMP
    4 CONTINUE
      IF(IND)20,20,21
   21 IND=0
      GO TO 5
   20 IF(NORM2-THR)3,22,22
   22 CONTINUE
      DO 50 I=1,N
   50 EVAL(I)=A(I,I)
      IF(N-1)88,88,81
   81 N1=N-1
      DO 51 I=1,N1
      V1=EVAL(I)
      I1=I+1
      DO 51 J=I1,N
      IF(EVAL(J)-V1)82,51,51
   82 V1=EVAL(J)
      EVAL(J)=EVAL(I)
      EVAL(I)=V1
      IF(IVS-1)83,51,83
   83 DO 52 P=1,N
      V2=S(P,I)
      S(P,I)=S(P,J)
   52 S(P,J)=V2
   51 CONTINUE
   88 RETURN
      END
      SUBROUTINE FMTSET(KOP1,KOP2,KOP3)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C     ROUTINE TO PRE-SET CUTOFFS FOR FMTGEN.
C
      COMMON/FM/GA(15),RPITWO,FMZERO(15),TOL,CUT0S,CUTSM,CUTML
      COMMON/IO/IN,IOUT,IPUNCH
      COMMON/FMCONS/FOUR,ONE,HALF,TWO,ZERO,TEN,TENM9,F20,F42,F500
      DIMENSION F(15)
      DATA FOUR/4.0D0/,ONE/1.0D0/,HALF/0.5D0/,TWO/2.0D0/,ZERO/0.0D0/
      DATA TEN/10.0D0/,TENM9/1.0D-9/,F20/20.0D0/,F42/42.0D0/,F500/500.0D
     $0/
C
C     COMPUTE PI RELATED CONSTANTS.
      PI=FOUR*DATAN(ONE)
      GA(1)=DSQRT(PI)
      RPITWO=HALF*GA(1)
C
C     FILL GAMMA FUNCTION ARRAY.
      TOL=HALF
      DO 10 I=2,15
      GA(I)=GA(I-1)*TOL
   10 TOL=TOL+ONE
C
C     FILL FMZERO (FOR ARGUMENT OF ZERO).
      TOL=ONE
      FMZERO(1)=ONE
      DO 20 I=2,15
      TOL=TOL+TWO
   20 FMZERO(I)=ONE/TOL
C
C     OBTAIN CUTOFFS.
C
C        CUT0S = CUTOFF, ZERO TO SMALL.
C        CUTSM = CUTOFF, SMALL TO MEDIUM.
C        CUTML = CUTOFF, MEDIUM TO LARGE.
C
C     CUTOS IS OBTAINED FROM KOP1.
      CUT0S=ZERO
      IF(KOP1)30,40,30
   30 CUT0S=TEN**(-2*KOP1)
C
C     CUTSM IS OBTAINED FROM KOP2.
C     KOP2 SPECIFIES THE DESIRED ACCURACY OF THE ASSYMPTOTIC
C     EXPANSION.  ROUTINE FMTGEN IS CALLED TO CHECK THE VIABILITY
C     OF THE ASSYMPTOTIC EXPANSION FOR VARIOUS VALUES OF CUTSM.
   40 TOL=TENM9
      CUTSM=TEN
      IF(KOP2)50,90,50
   50 TOL=TEN**(-6-KOP2)
      T=F20
   60 CALL FMTGEN(F,T,1,ICK)
      IF(ICK)80,70,80
   70 T=T-ONE
      IF(T-TEN)90,60,60
   80 CUT=T+ONE
C
C     CUTML IS TAKEN FROM KOP3.
   90 CUTML=F42
      IF(KOP3)100,130,100
  100 IF(KOP3-7)120,110,120
  110 CUTML=F500
      GO TO 130
  120 CUTML=DFLOAT(KOP3)*FOUR
  130 WRITE(IOUT,2001)KOP1,KOP2,KOP3,CUT0S,CUTSM,CUTML
      RETURN
 2001 FORMAT(21H0FROM FMTSET, KOPS = ,3I2,12H AND CUTS = ,3E10.3/)
      END
      SUBROUTINE FMTGEN(F,T,M,ICK)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C     --------------------------
C     GAUSSIAN 74 (QCPE VERSION)
C     DECEMBER 1974
C     UNIVAC 1108/CDC 7600
C     --------------------------
C
      DIMENSION F(M)
      COMMON/IO/IN,IOUT,IPUNCH
      COMMON/FMCONS/FOUR,ONE,HALF,TWO,ZERO,TEN,TENM9,F20,F42,F500
      COMMON/FM/GA(15),RPITWO,FMZERO(15),TOL,CUT0S,CUTSM,CUTML
      EQUIVALENCE(APPROX,OLDSUM)
      DATA ZERO/0.0D0/,TEN/10.0D0/,HALF/0.5D0/,ONE/1.0D0/,F42/42.0D0/
      DATA TWO/2.0D0/
 2001 FORMAT(41H0FAILURE IN FMGEN FOR SMALL T:  IX ' 50, /              |
     $ 6H IX = ,I3,7H,  T = ,E20.14)
 2002 FORMAT(37H0FAILURE IN FMGEN FOR INTERMEDIATE T:/                  |
     $  6H  T = ,E20.14)
C
C     ICK IS AN ERROR INDICATOR.
C     ON RETURN, ICK=0 IMPLIES THAT ALL IS WELL.
C     IF ON RETURN, ICK IS NON-ZERO, THE ASSYMPTOTIC EXPANSION
C     HAS FAILED.
      ICK=0
C     TEST FOR TYPE OF ALGORITHM.
      IF(DABS(T)-CUT0S)1,1,3
C        FILL F(M) FOR ARGUMENT OF ZERO.
    1 DO 2 I=1,M
    2 F(I)=FMZERO(I)
      RETURN
C     TEST FOR EVALUATION OF THE EXP.
    3 TEXP=ZERO
      IF(DABS(T)-CUTML)4,150,150
    4 TEXP=DEXP(-T)
      IF(DABS(T)-CUTSM)10,80,80
C        0 .LT. T .LT. 10
   10 A=DFLOAT(M-1)+HALF
      TERM=ONE/A
      SUM=TERM
      DO 20 IX=2,200
      A=A+ONE
      TERM=TERM*T/A
      SUM=SUM+TERM
      IF(DABS(TERM/SUM)-TOL)30,20,20
   20 CONTINUE
      WRITE(IOUT,2001)IX,T
      STOP
   30 F(M)=HALF*SUM*TEXP
      GO TO 160
C
C        10 .LE. T .LT. 42
   80 A=DFLOAT(M-1)
      B=A+HALF
      A=A-HALF
      TX=ONE/T
      MM1=M-1
      APPROX=RPITWO*DSQRT(TX)*(TX**MM1)
      IF(MM1)90,110,90
   90 DO 100 IX=1,MM1
      B=B-ONE
  100 APPROX=APPROX*B
  110 FIMULT=HALF*TEXP*TX
      SUM=ZERO
      IF(FIMULT)120,140,120
  120 FIPROP=FIMULT/APPROX
      TERM=ONE
      SUM =ONE
      NOTRMS=IDINT(T)+MM1
      DO 130 IX=2,NOTRMS
      TERM=TERM*A*TX
      SUM=SUM+TERM
      IF(DABS(TERM*FIPROP/SUM)-TOL)140,140,130
  130 A=A-ONE
      WRITE(IOUT,2002)T
      ICK=1
      RETURN
  140 F(M)=APPROX-FIMULT*SUM
      GO TO 160
C        T .GE. 42
  150 TX=DFLOAT(M)-HALF
      F(M)=HALF*GA(M)/(T**TX)
C        RECUR DOWNWARDS TO F(1)
  160 TX=T+T
      SUM=DFLOAT(M+M-3)
      MM1=M-1
      IF(MM1)170,190,170
  170 DO 180 IX=1,MM1
      F(M-IX)=(TX*F(M-IX+1)+TEXP)/SUM
  180 SUM=SUM-TWO
  190 RETURN
      END
      SUBROUTINE SQUARE(A,B,M,N,KEY)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C     --------------------------
C     GAUSSIAN 74 (QCPE VERSION)
C     DECEMBER 1974
C     UNIVAC 1108/CDC 7600
C     --------------------------
C
C     PLACES LINEAR ARRAY IN SQUARE FORM
C     TWO PARTS ... KEY =
C     1  SQUARE ARRAY TO BE FORMED NOT SYMMETRIC
C     0  SQUARE ARRAY TO BE FORMED SYMMETRIC
C
      DIMENSION A(1),B(M,M)
C
      IF(KEY)1,3,1
C
C     KEY=1  ARRAY NOT SYMMETRIC
C
    1 K=N*N
      DO 2 J=1,N
      JX=N-J+1
      DO 2 I=1,N
      IX=N-I+1
      B(IX,JX)=A(K)
    2 K=K-1
      RETURN
C
C     KEY=0  ARRAY SYMMETRIC
C
    3 K=N*(N+1)/2
      DO 4 J=1,N
      JX=N-J+1
      DO 4 I=1,JX
      IX=JX-I+1
      B(IX,JX)=A(K)
    4 K=K-1
      DO 5 J=1,N
      DO 5 I=1,J
    5 B(J,I)=B(I,J)
      RETURN
      END
      SUBROUTINE MATREC(A,B,D,MAXDIM,L,M,N,MODE)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION A(MAXDIM,MAXDIM),B(MAXDIM,MAXDIM),D(MAXDIM)
      EQUIVALENCE(SWAP,SUM)
      DATA ZERO/0.0D0/
C
      JLIM=N
      IF(L-N)10,20,30
   10 ILIM=L
      GO TO 35
   20 ILIM=N-1
      GO TO 35
   30 ILIM=N
      JLIM=L
   35 GO TO(1,2,3,4,5,6),MODE
C
 1    DO 60 I=1,L
      DO 50 J=1,N
      SUM=ZERO
      DO 40 K=1,M
   40 SUM=SUM+(A(I,K)*B(K,J))
   50 D(J)=SUM
      DO 60 J=1,N
   60 A(I,J)=D(J)
      GO TO 260
 2    DO 90 I=1,L
      DO 80 J=1,N
      SUM=ZERO
      DO 70 K=1,M
   70 SUM=SUM+(A(K,I)*B(K,J))
   80 D(J)=SUM
      DO 90 J=1,N
   90 A(J,I)=D(J)
      DO 110 I=1,ILIM
      IP1=I+1
      DO 110 J=IP1,JLIM
      SWAP=A(I,J)
      A(I,J)=A(J,I)
  110 A(J,I)=SWAP
      GO TO 260
 3    DO 140 I=1,L
      DO 130 J=1,N
      SUM=ZERO
      DO 120 K=1,M
  120 SUM=SUM+(A(I,K)*B(J,K))
  130 D(J)=SUM
      DO 140 J=1,N
  140 A(I,J)=D(J)
      GO TO 260
 4    DO 170 J=1,N
      DO 160 I=1,L
      SUM=ZERO
      DO 150 K=1,M
  150 SUM=SUM+(A(I,K)*B(K,J))
  160 D(I)=SUM
      DO 170 I=1,L
  170 B(I,J)=D(I)
      GO TO 260
 5    DO 200 J=1,N
      DO 190 I=1,L
      SUM=ZERO
      DO 180 K=1,M
  180 SUM=SUM+(A(K,I)*B(K,J))
  190 D(I)=SUM
      DO 200 I=1,L
  200 B(I,J)=D(I)
      GO TO 260
 6    DO 230 J=1,N
      DO 220 I=1,L
      SUM=ZERO
      DO 210 K=1,M
  210 SUM=SUM+(A(I,K)*B(J,K))
  220 D(I)=SUM
      DO 230 I=1,L
  230 B(J,I)=D(I)
      DO 250 I=1,ILIM
      IP1=I+1
      DO 250 J=IP1,JLIM
      SWAP=B(I,J)
      B(I,J)=B(J,I)
  250 B(J,I)=SWAP
  260 RETURN
      END
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                