#include <std.h>
#include <rt11.h>
#include <virt.h>

/* vrtble.c 
**
** REV 1281.021
**
** trouble(code)is designed to be held in its own overlay.  It reports
** troubles that are beyond repair and causes an orderly exit from
** the virtual array routines. It requires the use of the GLOBAL variable
** error which is held in the root module portion of the program using
** the virtual array package. The variable error passes a wide variety of
** information to trouble() which cannot be easily characterized.
*/

VOID trouble(code)
    FAST COUNT code;	/* error code */
    {

    IMPORT COUNT err_index;
    IMPORT COUNT error;		/* RT-11 error &'d with -256 */
    IMPORT struct rt ROOT[];
    IMPORT VOID snap_shot();

    error &= BYTMASK;		/* look at only low 8 bits */
    switch(code) {
    case ROOM: 
	putfmt("VIRT-F-1 couldn't get any memory space.\n");
	break;
    case WRITERR:
	putfmt("In virtual array number: %i\n",err_index);
	switch(error) {
	case 0:
    	    putfmt("VWRITE-F-1 attempt to write pase EOF.\n");
	    break;
	case 1:
	    putfmt("VWRITE-F-2 hardware error.\n");
	    break;
	case 2:
	    putfmt("VWRITE-F-3 channel not open.\n");
	    break;
	default:
   	    putfmt("VWRITE-?-0 unexplainable error code.\n");
	    break;
	}
        break;
    case READERR:
	putfmt("In virtual array number: %i\n",err_index);
	switch(error) {
	case 0:
	    putfmt("VREAD-F-1 attempt to read pase EOF\n");
	    break;
	case 1:
	    putfmt("VREAD-F-2 hardware error.\n");
	    break;
 	case 2:
	    putfmt("VREAD-F-3 channel not open.\n");
  	    break;
	default:
	    putfmt("VREAD-?-? undefinable error code %i.\n",error);
	}
	break;
    case ENTER:
	putfmt("In virtual array number: %i\n",err_index);
	switch(error) {
	case 0:
		ROOT[err_index].chan++;	/* update channel number */
		return;		/* give it another chance */
	case 1:
		putfmt("VINIT-F-1 not enough contiguous space on disk.\n");
		break;
	case 3:
		putfmt("VINIT-F-2 Protected filename already exists.\n");
	default:
		putfmt("VINIT-?-0 Unknown error code #: %i.\n",error);
	}
	break;
    case CREATERR:
	putfmt("In virtual array number: %i\n",err_index);
	switch(error) {
	case 1:
	    putfmt("VDIM-F-2 Not enough continuous disk space available.\n");
	    break;
	case 3:
	    putfmt("VDIM-F-3 Protected file already exits.\n");
	    break;
	default:
	    putfmt("VDIM-PANIC-1 Unknown create error returned: %i\n",error);
	    break;
	}
	break;
    case OPENERR:
	putfmt("In virtual array number: %i\n",err_index);
	switch(error) {
	case 1:
	    putfmt("VDIM-F-4 File indicated was not found.");
	    break;
	default:
	    putfmt("VDIM-PANIC-2 Unknown open error returned: %i\n",error);
	}
    case VDIM:
	putfmt("In virtual array number: %i\n",err_index);
	putfmt("VDIM-F-1 Call to VDIM with invalid file disposition value\n");
	break;
    case DATA_SIZE:
	putfmt("VWRITE-F-4 data size of %i incompatible with numeric types\n"\
		, code);
	break;
    default:
	putfmt("TROUBLE-PANIC-1 Call to trouble with unidentified error");
	putfmt("In virtual array number: %i\n",err_index);
	putfmt(" code %i with ERROR of %i\n",code,error);
    }
    vexit();
    exit(NO);
    }
                                                                                                                                                                                                                                                                                                                        