PROCEDURE decodeCSI(	VAR outputFile:String14;
			VAR FirstInputdevice,
			    secondInputdevice:String6;
			VAR Options:OptionArray);

TYPE	Radixstring4=ARRAY[1..4] OF INTEGER;
	outputFileType=RECORD
		name:radixString4;
		length:INTEGER;
		END;
	CSIReceptionBlockType=RECORD
		Output:ARRAY[1..3] OF OutputFileType;
		Input: ARRAY[1..6] OF RadixString4;
		END;
	OptionInformation=RECORD
		name,blank:CHAR;
		WhatReturned:(Didntoccur,noValue,ValueReturned);
		FileOptionOccuredOn,
		Value		:INTEGER;
		END;
	OptionInfoArray=ARRAY[OptionTypes] OF OptionInformation;
	ValuesReturnedByICSI=
		(OK,IllegalCommandLine,IllegalDevice,Illegaloption);
	String81= ARRAY[1..81] OF CHAR;
	String2 =ARRAY[1..2] OF CHAR;

VAR	CSIReceptionBlock:CSIReceptionBlockType;
	DefaultTypes	:RadixString4;
	CSIString ORIGIN 0: INTEGER;
	OptionsReturned	:OptionInfoArray;
	NumberOfOptions	:INTEGER;
	CSIReturnStatus :ValuesReturnedbyICSI;
	I,J		:INTEGER;
	VersionReport	:ARRAY[1..32] OF CHAR;
	OptionCounter	: OptionTypes;

FUNCTION	ICSI(VAR   CSIReceptionBlock:CSIReceptionBlockType;
		     VAR   DefaultExtensions:Radixstring4;
		     VAR   CSIString	    :INTEGER;
		     VAR   options	    :OptionInfoArray;
		     VAR   NumberOfOptions  :INTEGER)
		     :ValuesReturnedByICSI;
		     FORTRAN;


PROCEDURE R50ASC( VAR inptr:Radix50; VAR output:CHAR; NumChars:INTEGER);
		EXTERNAL;


{$A-}
PROCEDURE init;

BEGIN{init}
    DefaultTypes[1]:=0;
    DefaultTypes[2]:=015156B;{Rad50 for DIF}
    DefaultTypes[3]:=0;
    DefaultTypes[4]:=0;
    OutputFile:='              ';
    FirstInputDevice:='      ';
    SecondInputdevice:='      ';
    numberofOptions:=8;
    OptionsReturned[ ProcessVolumeID].Name := 'V';
    OptionsReturned[ ScanDev1       ].Name := 'U';
    OptionsReturned[ ScanDev2       ].Name := 'U';
    OptionsReturned[ CompareFiles   ].Name := 'N';
    OptionsReturned[ CompareByDate  ].Name := 'D';
    OptionsReturned[ sortAlpha      ].Name := 'S';
    OptionsReturned[ Printresult    ].Name := 'P';
    OptionsReturned[ wait           ].Name := 'W';
END;


PROCEDURE ProcessOptions;
BEGIN
    FOR OptionCounter := PrintResult TO Wait DO
       options[ OptionCounter ] :=
		(OptionsReturned[ OptionCounter ].WhatReturned	= NoValue);
    IF OptionsReturned[ScanDev1].WhatReturned  =  NoValue
    THEN 
    	IF OptionsReturned[ScanDev1].FileOptionOccuredOn = 3
    	THEN Options[ScanDev2] :=  FALSE
    	ELSE Options[ScanDev1] :=  FALSE;	
    IF OptionsReturned[SortAlpha].WhatReturned IN [didntOccur,noValue]
    THEN Options[SortAlpha]:=TRUE
    ELSE IF OptionsReturned[SortAlpha].Value= 100370B
    	 THEN Options[SortAlpha]:=FALSE;
    CASE OptionsReturned[CompareFiles].WhatReturned OF
	didntOccur: Options[CompareFiles]:=TRUE;
   	NoValue	  : Options[CompareFiles]:=FALSE;
  	ValueReturned: 
	    IF OptionsReturned[CompareFiles].Value=  30521 {decimal for 
							   'SCA' in RAD50}
	    THEN 					BEGIN
	       Options[CompareFiles]:=TRUE;
	       Options[ScanDev1]:=FALSE;
	       Options[ScanDev2]:=FALSE;
	       END
	    ELSE Options[CompareFiles]:=FALSE;
	END;{CASE}

END;



FUNCTION empty(r:Radixstring4):BOOLEAN;

BEGIN{empty}
    IF (r[1]=0) AND (r[2]=0) AND (r[3]=0) AND (r[4]=0)
    THEN empty:=TRUE
    ELSE empty:=FALSE
END;

BEGIN{DecodeCSI}
    REPEAT
	init;
	CSIReturnStatus:=ICSI(CSIReceptionBlock,defaultTypes,CSIString ,
				OptionsReturned,NumberOfOptions);
	ProcessOptions;
	{DEBUG WRITELN('Completed ICSI!!!');}
	{DEBUG}
	       {WRITELN('Options: ');
		IF Options[ScanDev1] THEN WRITELN('	Scan 1');
		IF Options[ScanDev2] THEN WRITELN('	Scan 2');
		IF Options[SortAlpha] THEN WRITELN('	Sort')
				      ELSE WRITELN('	Sort By Type');
		IF Options[CompareFiles] THEN WRITELN('	Compare');
		}

	CASE CSIReturnStatus OF
	    IllegalCommandLine:WRITELN('***** Illegal Command');    
	    IllegalDevice     :WRITELN('***** Illegal Device');
	    IllegalOption     :WRITELN('***** Illegal Option');
	    OK: BEGIN
		IF empty(CSIReceptionBlock.Output[1].name)
		THEN  IF NOT Options[PrintResult] 
		      THEN OutputFile:='TT:           '
		      ELSE OutputFile:='LP:           '
		ELSE 					BEGIN
		    R50ASC(CSIReceptionBlock.Output[1].Name[1],
				Outputfile[1],3);
			{decode 3 rad50 characters and put in the
			  first 3 locations of outputFile}
		    {Now insert ':' if a device name is present}
		    IF CSIReceptionBlock.Output[1].Name[1]#0
		     THEN OutputFile[4]:=':';
		    IF CSIReceptionBlock.Output[1].Name[2]#0
		    THEN 				BEGIN
			R50ASC(CSIReceptionBlock.Output[1].Name[2],
				Outputfile[5],6);
			{decode 6 rad50 characters and put in the
			  6 locations of outputFile,starting at '5'}
			OutputFile[11]:='.';
			R50ASC(CSIReceptionBlock.Output[1].Name[4],
				Outputfile[12],3);
			END;
		    END;
		IF empty(CSIReceptionBlock.Input[1])
		  OR empty(CSIReceptionBlock.Input[2])
		THEN				BEGIN
		    WRITELN( '***DSC - I - Version',version:3:1,'***');
		    CSIReturnstatus := IllegalCommandLine
		    END
		ELSE				BEGIN
		    R50ASC(CSIReceptionBlock.Input[1,1],
		    FirstInputDevice[1],3);
		    R50ASC(CSIReceptionBlock.Input[2,1],
				SecondInputDevice[1],3);
		    For j:=4 DOWNTO 1 DO 
		       IF FirstInputDevice[j]=' ' THEN i:=j;
		    FirstInputdevice[i]:=':';
		    For j:=4 DOWNTO 1 DO 
			IF SecondInputDevice[j]=' ' THEN i:=j;
		    SecondInputDevice[i]:=':';
		    END{ELSE}
		END{ok:}
	    END;{CASE}
	UNTIL CSIReturnStatus = OK;
END;

BEGIN
DecodeCSI(outputName,FirstDeviceName,SecondDeviceName,Options);
END.

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     