	SUBROUTINE SCALE(X,Y,VX,VY)
C
C	THIS SUBROUTINE CONVERTS THE POINT (X,Y) FROM WORLD COORDINATES
C	TO THE POINT (VX,VY) IN VIRTUAL COORDINATES.
C
	LOGICAL*1 LOGX, LOGY
	COMMON /PLTCOM/ UX0, UDX, UY0, UDY, LOGX, LOGY
	COMMON /PLTSIZ/ XVSTRT, YVSTRT, XVLEN, YVLEN
C
C	DEFINE "LOG10(0.0)" AS SMLLOG
C
	DATA SMLLOG /-100.0/
C
	XX = X
	IF (.NOT. LOGX) GO TO 10
		IF (X .LE. 0.0) GO TO 5
			XX = ALOG10(X)
			GO TO 10
5		    CONTINUE
			XX = SMLLOG
10	CONTINUE
	YY = Y
	IF (.NOT. LOGY) GO TO 20
		IF (Y .LE. 0.0) GO TO 15
			YY = ALOG10(Y)
			GO TO 20
15		    CONTINUE
			YY = SMLLOG
20	CONTINUE
	VX = XVSTRT + XVLEN*(XX-UX0)/UDX
	VY = YVSTRT + YVLEN*(YY-UY0)/UDY
	RETURN
	END
                                                                                                                                                                                                                                                                                                                                