	INTEGER FUNCTION MONTYP()
C
C	Determine which operating system is currently in use.
C	From the version 5.0 release of both RT-11 & TSX+ on,
C	DEC and S&H have agreed to use bit 15 of the RMON
C	fixed offset 372 to indicate which operating system is
C	in control of the hardware.
C					0 = RT-11
C					1 = TSX+
C	The appropriate numeric is returned as the function value.
C
	INTEGER SYSGEN,ISPY
	DATA SYSGEN /"372/
	MONTYP = 0               !Assume RT-11
	IF((ISPY(SYSGEN) .AND. "100000) .NE. 0)  MONTYP = 1
	RETURN
	END
	SUBROUTINE IDFSTS(QUIET)
C
C	Check the RT-11 monitor's Indirect File status word.
C	If this task is being executed through a command file
C	and the SET TT QUIET state has been set, then the
C	LOGICAL*1 flag QUIET is set to warn the program not to
C	display prompt strings.
C
	INTEGER IDFSW,ISPY,I
	LOGICAL*1 QUIET
	DATA IDFSW /"366/
	QUIET = .FALSE.
	I = ISPY(IDFSW)                     !Get the DCL/@file status word
	IF((I.AND."100000) .EQ. 0)  RETURN  !Task not run from command file
C
C	Don't display prompts if "TT QUIET" is set
C
	IF((I .AND. "2000) .NE. 0)  QUIET = .TRUE.
	RETURN
	END
	SUBROUTINE FNCRLF
C
C	Force terminal driver to NO_CRLF condition
C
	INTEGER SYSGEN,SYSVER,TCFIG,BUF
	INTEGER ISPY,IPEEK,IPOKE,MTATCH,MTGET,MTSET,MTRCTO,MTDTCH
	INTEGER MVERSN,TTUNIT,SVETSW
	LOGICAL*1 MTT
	COMMON /CRLF01/ MVERSN,TTUNIT,SVETSW,BUF(8),MTT
	DATA SYSVER /"276/, SYSGEN /"372/, TCFIG /"424/
C
C	Check if monitor supports multi-terminal service
C
	MTT = .FALSE.
	IF((ISPY(SYSGEN) .AND. "20000) .NE. 0)  MTT = .TRUE.
	IF(MTT)  GO TO 10
C
C	Monitor supports only the console terminal
C
	MVERSN = ISPY(SYSVER)            !Get monitor's version number
	IF(MVERSN .LT. 5)  RETURN        !Feature added in RT-11 V5.0
	TTUNIT = ISPY(TCFIG)             !Get terminal status word address 
	SVETSW = IPEEK(TTUNIT)           !Save original value
	CALL IPOKE(TTUNIT,(SVETSW.AND."177775)) !Jam in NO_CRLF
	CALL RCTRLO                      !Insist it take effect now
	RETURN
C
C	Monitor supports multi-terminal feature
C
   10	CALL GTJB(BUF)
	TTUNIT = BUF(6).AND. "377            !Load unit# of job's console
	IF(MTATCH(TTUNIT) .NE. 0)     RETURN !Get access to terminal
	IF(MTGET(TTUNIT,BUF) .NE. 0)  RETURN !Load it's characteristics
	SVETSW = BUF(1)                      !Save original value
	BUF(1) = SVETSW .AND. "177775        !Request NO_CRLF
	IF(MTSET(TTUNIT,BUF) .NE. 0)  RETURN !Install for this terminal
	IF(MTRCTO(TTUNIT) .NE. 0)     RETURN !Insist it take effect now
	IF(MTDTCH(TTUNIT) .NE. 0)     RETURN !Release access to terminal
	RETURN
	END
	SUBROUTINE ENCRLF
C
C	Restore terminal driver to its state before the FNCRLF call
C
	INTEGER BUF,IPOKE,MTATCH,MTSET,MTRCTO,MTDTCH
	INTEGER MVERSN,TTUNIT,SVETSW
	LOGICAL*1 MTT
	COMMON /CRLF01/ MVERSN,TTUNIT,SVETSW,BUF(8),MTT
C
C	Check if monitor supports multi-terminal service
C
	IF(MTT)  GO TO 10
C
C	Monitor supports only the console terminal
C
	IF(MVERSN .LT. 5)  RETURN        !Feature added in RT-11 V5.0
	CALL IPOKE(TTUNIT,SVETSW)        !Restore original status word
	CALL RCTRLO                      !Insist it take effect now
	RETURN
C
C	Monitor supports multi-terminal feature
C
   10	IF(MTATCH(TTUNIT) .NE. 0)     RETURN !Get access to terminal
	IF(MTGET(TTUNIT,BUF) .NE. 0)  RETURN !Load it's characteristics
	BUF(1) = SVETSW                      !Restore original status word
	IF(MTSET(TTUNIT,BUF) .NE. 0)  RETURN !Install for this terminal
	IF(MTRCTO(TTUNIT) .NE. 0)     RETURN !Insist it take effect now
	IF(MTDTCH(TTUNIT) .NE. 0)     RETURN !Release access to terminal
	RETURN
	END
	SUBROUTINE TSXSTU
C
C	TSX+ terminal characteristics control  (uses TSXLIB subroutine)
C
	INTEGER SCAM,NOCRLF
	DATA SCAM /"123/       !ASCII "S"
	CALL ITRCTL(SCAM,0)    !Enable single character activation mode
	RETURN
	END
                                                                                                                                                                                       