Program string_test;

{String test and demonstration program

	Author : Earl Chew

	Date   : 06-Dec-83}

const
  stringlength = 25;
  rad50length = 9;
  nul = chr(0);

type
  string = array [1..stringlength+1] of char;
  relation = (lt, le, eq, ge, gt, ne);

type
  rad50 = array [1..rad50length] of integer;

var
  nbsversion : @string;
  s, s1, s2, s3 : string;
  r : rad50;
  rel : relation;

function version:@string; external;

procedure stor50(s:string; var r:rad50; m:integer); external;

procedure r50tos(r : rad50; l:integer; var s:string; m:integer); external;

function compare(src1:string; comparison:relation; src2:string):boolean; external;

function match(src1,src2 : string):relation; external;

function position(pattern,src:string; index:integer):integer; external;

procedure delete(var dst:string; index,size:integer); external;

function length(src:string):integer; external;

procedure concatenate(src1,src2:string; maxlength:integer); external;

procedure substring(src:string; var dst:string; index,size:integer); external;

procedure insert(src:string; var dst:string; index,maxlength:integer); external;

procedure itos(n:integer; var dst:string; base:integer; sign:boolean; maxlength:integer); external;

function stoi(src:string; base, start:integer; var stop:integer):integer; external;

procedure date(var dat:string); external;

procedure time(var tim:string); external;

procedure left(s1:string; var s:string; sp:integer); external;

procedure pad(var s:string; sp,maxlength:integer); external;

procedure padleft(var s:string; sp,maxlength:integer); external;

procedure padright(var s:string; sp,maxlength:integer); external;

procedure right(s1:string; var s2:string; sp:integer); external;

procedure trim(var s:string); external;

procedure trimleft(var s:string); external;

procedure trimright(var s:string); external;

function verify(s1,s2:string):integer; external;


procedure readwrite;

var
  l:integer;
begin
    writeln('Readln and Writeln');
    repeat
	write('String : ');
	readln(s);
	write('Field  : ');
	readln(l);
	writeln('"', s:l, '"')
    until s[1] = nul;
end;

procedure compare_;

var
  rel:relation;
begin
    writeln('Compare');
    repeat
	write('First   : ');
	readln(s1);
	write('Second  : ');
	readln(s2);
	writeln('    LT    LE    EQ    GE    GT    NE');
	for rel := lt to ne do
	  write(compare(s1, rel, s2):6);
	writeln
    until (s1[1] = nul) and (s2[1] = nul);
end;

procedure concatenate_;
begin
    writeln('Concatenate');
    repeat
	write('First   : ');
	readln(s1);
	write('Second  : ');
	readln(s2);
	concatenate(s1, s2, stringlength);
	writeln('"', s1, '"');
	writeln('"', s2, '"')
    until (s1[1] = nul) and (s2[1] = nul);
end;

procedure date_;
begin
    writeln('Date');
    date(s);
    writeln('"', s, '"');
end;

procedure delete_;

var
  i,j,l:integer;
begin
    writeln('Delete');
    repeat
	write('String :');
	readln(s);
	l := length(s);
	for i := 1 to l do begin
	  writeln('Start   Span   String');
	    for j := 0 to l-i+1 do begin
	    s1 := s;
	    delete(s1, i, j);
	    writeln('"', s, '"');
	    writeln(i:5, j:7, '   "', s1, '"')
	  end
	end
    until s[1] = nul;
end;

procedure insert_;

var
  i:integer;
begin
    writeln('Insert');
    repeat
	write('Insert : ');
	readln(s1);
	write('String : ');
	readln(s2);
	writeln('Start   String');
	for i := 1 to length(s2)+1 do begin
	  s:=s2;
	  insert(s1, s, i, stringlength);
	  writeln('"', s1, '"');
	  writeln('"', s2, '"');
	  writeln(i:5, '   "', s, '"')
	end
    until (s1[1] = nul) and (s2[1] = nul);
end;

procedure itos_;

var
  i,j:integer;
begin
    writeln('Itos');
    repeat
	write('Number :');
	readln(i);
	writeln('Radix   Number (Signed/Unsigned)');
	for j := 2 to 36 do begin
	  itos(i, s1, j, true, stringlength);
	  itos(i, s2, j, false, stringlength);
	  writeln(j:5,'   "', s1, '"');
	  writeln('        "', s2, '"')
	end
    until i = 0;
end;

procedure left_;

var
  i:integer;
begin
    writeln('Left');
    repeat
	write('String :');
	readln(s);
	for i := length(s) downto 0 do begin
	  left(s, s1, i);
	  writeln('"', s, '"   "', s1, '"')
	end
    until s[1] = nul;
end;

procedure length_;
begin
    writeln('Length');
    repeat
	write('String : ');
	readln(s);
	writeln(length(s))
    until s[1] = nul;
end;

procedure match_;
begin
    writeln('Match');
    repeat
	write('First  : ');
	readln(s1);
	write('Second : ');
	readln(s2);
	case match(s1, s2) of
	  lt : writeln('LT');
	  eq : writeln('EQ');
	  gt : writeln('GT')
	end
    until (s1[1] = nul) and (s2[1] = nul);
end;

procedure pad_;

var
  i:integer;
begin
    writeln('Pad, Padleft and Padright');
    repeat
	write('String : ');
	readln(s);
	write('Field  : ');
	readln(i);
	s1 := s;
	s2 := s;
	s3 := s;
	pad(s1, i, stringlength);
	padleft(s2, i, stringlength);
	padright(s3, i, stringlength);
	writeln('"', s, '"');
	writeln('"', s1, '"');
	writeln('"', s2, '"');
	writeln('"', s3, '"')
    until s[1] = nul;
end;

procedure position_;

var
  i:integer;
begin
    writeln('Position');
    repeat
	write('String  : ');
	readln(s1);
	write('Pattern : ');
	readln(s2);
	writeln('Start   String');
	for i := 1 to length(s1) do begin
	  writeln('        "', s1, '"');
	  writeln(i:5, '^':position(s1, s2,i)+4, 'First match')
	end
    until (s1[1] = nul) and (s2[1] = nul);
end;

procedure r50tos_;

var
  l, i : integer;

begin
  writeln('R50tos');
  repeat
    write('Number of RAD50 characters : ');
    readln(l);
    for i := 1 to ((l + 2) div 3) do begin
      write('Character Code ', i:2, ' : ');
      readln(r[i])
    end;
    r50tos(r, l, s, stringlength);
    writeln('"', s, '"')
  until l = 0
end;

procedure right_;

var
  i,l:integer;
begin
    writeln('Right');
    repeat
	write('String : ');
	readln(s);
	l := length(s);
	for i := l downto 0 do begin
	  right(s, s1, i);
	  writeln('"', s, '"', '"':l-i+4, s1, '"')
	end
    until s[1] = nul;
end;

procedure stoi_;

var
  i,j,k,l:integer;
begin
    writeln('Stoi');
    repeat
	write('String : ');
	read(s);
	write('Radix  : ');
	readln(i);
	l := length(s);
	writeln('Number   String');
	for j := 1 to l do begin
	  writeln('         "', s, '"');
	  writeln(stoi(s, i, j, k):6, '*':j+4, 'Start of Scan');
	  writeln('^':k+10, 'End of Scan')
	end
    until s[1] = nul;
end;

procedure stor50_;

var
  l, i : integer;

begin
  writeln('Stor50');
  repeat
    write('String : ');
    readln(s);
    write('Length : ');
    readln(l);
    l := min(l, rad50length);
    stor50(s, r, l);
    for i := 1 to rad50length do
      writeln('Element ', i:2, ' : ', r[i]:6)
  until s[1] = nul
end;

procedure substring_;

var
  i,j,l:integer;
begin
    writeln('Substring');
    repeat
	write('String : ');
	readln(s);
	l := length(s);
	for i := 1 to l do
	  for j := 0 to l-i+1 do begin
	    writeln('"', s, '"');
	    substring(s, s1, i, j);
	    writeln('*':i+1, 'Start of Substring');
	    writeln('^':i+j, 'End of Substring');
	    writeln('"', s1, '"')
	  end
    until s[1] = nul;
end;

procedure time_;
begin
    writeln('Time');
    time(s);
    writeln('"', s, '"');
end;

procedure trim_;
begin
    writeln('Trim, Trimleft and Trimright');
    repeat
	write('String : ');
	readln(s);
	s1 := s;
	s2 := s;
	s3 := s;
	trim(s1);
	trimleft(s2);
	trimright(s3);
	writeln('"', s, '"');
	writeln('"', s1, '"');
	writeln('"', s2, '"');
	writeln('"', s3, '"')
    until s[1] = nul;
end;

procedure verify_;
begin
    writeln('Verify');
    repeat
	write('String   : ');
	readln(s1);
	write('Template : ');
	readln(s2);
	writeln('"', s2, '"');
	writeln('"', s1, '"');
	writeln('^':verify(s1, s2)+1, 'First mismatch')
    until (s1[1] = nul) and (s2[1] = nul)
end;


begin
  nbsversion := version;
  repeat

    writeln('String demonstration program for NBS ', nbsversion@);
    writeln;
    readwrite;
    compare_;
    concatenate_;
    date_;
    delete_;
    insert_;
    itos_;
    left_;
    length_;
    match_;
    pad_;
    position_;
    r50tos_;
    right_;
    stoi_;
    stor50_;
    substring_;
    time_;
    trim_;
    verify_

  until false
end.
                                                                                                                                                                                                             