/*	VC - Programme to calculate respiratory function parameters

	V2	14-Mar-88	Rewritten in C, using RNSH equations.
*/

char vermes[]="VC (Vital Capacity Programme), Version 2, 14-Mar-88";

/*	Equations Used:


	male	 6-12		VC = 0.0411 * height - 3.3
		13-17		VC = 0.0628 * height - 6.66
		<=18		VC = 0.058  * height - 0.025 * age - 4.24

	female	 6-12		VC = 0.0424 * height - 3.643
		13-17		VC = 0.0507 * height - 5.064
		<=18		VC = 0.045  * height - 0.024 * age - 2.85

 

	male	 6-12		FEV1 = 0.0343 * height - 2.65
		13-17		FEV1 = VC * 0.82
		<=18		FEV1 = 0.036 * height - 0.032 * age - 1.26

	female	 6-12		FEV1 = 0.0381 * height - 3.262
		13-17		FEV1 = VC * 0.82
		<=18		FEV1 = 0.035 * height - 0.035 * age - 1.932

Explanation of non-standard C subroutines:

	datsub()	Prints date & day banner across top of screen
	cthclr()	Homes cursor, clears screen
	ctpos(row,col)	Positions cursor to row & column specified
	cgtlin(&line,&prompt) Prompts the user for a line and reads it,
			(in TSX able to track command files, and allows
			editing of input line for typos)

*/

#include "sy:stdio.h"

$$narg=1;

float	height,age;
int	iheight,iage;
char	line[84],sex;
float	vc,fev1;
main()
{
    datsub();
    printf(vermes);

    for(;;)
    {

	for(;;)
	{	ctpos(17,1);
		fflush(stdout);
	 	cgtlin(line,"Sex: \200");
		if(line[0]==0)quit();
		line[0]=tolower(line[0]);
		sex=line[0];
		if( (line[0]=='m') || (line[0]=='f') )break;
	}

	for(;;)
	{	iage=0;
		cgtlin(line,"Age: \200");
		sscanf(line,"%f",&age);
		iage=age;
		if( (age>=6) && (age<=100) )break;
		printf("Age must be from 6 to 100\r\n");
	}
		
	for(;;)
	{	iheight=0;
		cgtlin(line,"Height: \200");
		sscanf(line,"%f",&height);
		iheight=height;
		if( (height>=80) && (height<=250) )break;
		printf("Height must be from 80 to 200\r\n");
	}		

	cthclr();

	if(sex=='m')
	{
	    if(iage<13)
	    {						/* Boys 6 - 12 */
		vc = 0.0411 * height - 3.3 ;
		fev1 = 0.0343 * height - 2.65 ;
	    } else
	    {
		if(iage<18)
		{					/* Boys 13 - 17 */
		    vc = 0.0628 * height - 6.66 ;
		    fev1 = vc * 0.82 ;
		} else
		{
			vc = 0.058  * height - 0.025 * age - 4.24 ;
			fev1 = 0.036 * height - 0.032 * age - 1.26 ;
		}
	    }
	} else
	{
	    if(iage<13)
	    {						/* girls 6 - 12 */
		vc = 0.0424 * height - 3.643 ;
		fev1 = 0.0381 * height - 3.262 ;
	    } else
	    {
		if(iage<18)
		{					/* Girls 13 - 17 */
		vc = 0.0507 * height - 5.064 ;
		fev1 = vc * 0.82 ;
		} else
		{					/* Girls <= 18 */
		    vc = 0.045  * height - 0.024 * age - 2.85 ;
		    fev1 = 0.035 * height - 0.035 * age - 1.932 ;
		}
	    }
	}

	printf("%s, %d years old, %d centimetres tall\r\n\r\n",
		(sex=='m') ? "Male" : "Female" ,iage,iheight);

	if( (vc>0) && (fev1>0) )
	{
	    printf("Expected FEV1           = %6.2f\r\n",fev1);
	    printf("Expected Vital Capacity = %6.2f\r\n",vc);
	} else
	{
	printf("Height &/or Age out of range - cannot produce sensible results.");
	}
    }
}
/* QUIT - exit to monitor, giving it the command "R CLOCK"	*/

quit()
{
	char *p,*q;
	register int i;

	p=(char *) 0510;
	*p=8;
	p += 2;

	for(i=0, q="r clock" ; i<8 ; i++) *(p++) = *(q++);

	* (int *) 044 = (*(int*)044) | 04040;
	exit();
}
                                                                                                                                                                                                                                                                          