      PROGRAM STAR
C
C     DESCRIPTION:
C      Tis program draws a yellow star on a blue background and writes
C      the title 'Star' in green under the star.
C     CONFORMANCE:
C      GKS level: ma
C      FORTRAN-77 binding with FORTRAN-77 Subset comments.
C      At least one output or outin workstation.
C
C
C     Define GKS constants
C
      INCLUDE 'GKENUM.FIN'
C
C     Implementation dependent constants
C
      INTEGER    ERROUT,   TTOUT,   WSTYPE,   NBYTES
      PARAMETER (ERROUT=1, TTOUT=5, WSTYPE=0, NBYTES=-1)
C
C     Define coordinates for drawing the star.
C
      REAL       STARX(5), STARY(5)
      DATA       STARX /.951057, -.951057, .587785, 0.0, -.587785/
      DATA       STARY /.309017, .309017, -.951057, 1.0, -.951057/
C
C     Format statements.
C
5     FORMAT (1H+, 'PAUSE -- Hit return to continue.', $)
10    FORMAT (1A1)
C
C     Perform implementation dependent initialization.
C
      OPEN (TTOUT, STATUS='NEW')
C
C     Open GKS and activate a workstation.
C
      CALL GOPKS  (ERROUT, NBYTES)
      CALL GOPWK  (1, TTOUT, WSTYPE)
      CALL GACWK  (1)
C
C     Center the window around the origin.
C
      CALL GSWN   (1, -1.25, 1.25, -1.25, 1.25)
      CALL GSELNT (1)
C
C     Define the colors we'll be using.
C
      CALL GSCR   (1, 0, 0.0, 0.0, 1.0)
      CALL GSCR   (1, 1, 1.0, 1.0, 0.0)
      CALL GSCR   (1, 2, 0.0, 1.0, 0.0)
C
C     Fill the star with solid yellow.
C
      CALL GSFAIS (GSOLID)
      CALL GSFACI (1)
C
C     Draw the star
C
      CALL GFA    (5, STARX, STARY)
C
C     Select large characters centered under the star.
C
      CALL GSCHH  (0.15)
      CALL GSTXAL (GACENT, GAHALF)
      CALL GSTXCI (2)
C
C     Draw the title
C
      CALL GTX    (0.0, -1.1, 'Star')
C
C     The next three lines of code illustrate a sort of kludgy solution to
C     the problem of how to suspend the picture. The ultimate solution will
C     be to include an escape function to PAUSE, or to implement the LOCATOR
C     function.
C
      CALL GUWK   (1, GPERFO)		! Update the workstation to be sure
					!   that all the buffers are flushed.
      TYPE 5				! Present the prompt to the user.
      READ (5, 10) INLINE		! Wait for his response.
C
C     Close the workstation and shutdown GKS.
C
      CALL GDAWK  (1)
      CALL GCLWK  (1)
      CALL GCLKS
      STOP
      END
                                                                                                                                                                